/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source.inlined;

import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.inlined.AbstractInlinedAnnotation;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GlyphMetrics;

public class LineContentAnnotation
extends AbstractInlinedAnnotation {
    private int width;
    private int redrawnCharacterWidth;

    public LineContentAnnotation(Position position, ISourceViewer viewer) {
        super(position, viewer);
    }

    public final int getWidth() {
        return this.width;
    }

    @Override
    public final void draw(GC gc, StyledText textWidget, int offset, int length, Color color, int x, int y) {
        this.width = this.drawAndComputeWidth(gc, textWidget, offset, length, color, x, y);
    }

    protected int drawAndComputeWidth(GC gc, StyledText textWidget, int offset, int length, Color color, int x, int y) {
        super.draw(gc, textWidget, offset, length, color, x, y);
        return (int)((double)gc.stringExtent((String)this.getText()).x + 2.0 * gc.getFontMetrics().getAverageCharacterWidth());
    }

    int getRedrawnCharacterWidth() {
        return this.redrawnCharacterWidth;
    }

    void setRedrawnCharacterWidth(int redrawnCharacterWidth) {
        this.redrawnCharacterWidth = redrawnCharacterWidth;
    }

    @Override
    boolean contains(int x, int y) {
        return x >= this.fX && x <= this.fX + this.width && y >= this.fY && y <= this.fY + this.getTextWidget().getLineHeight();
    }

    StyleRange updateStyle(StyleRange style, FontMetrics fontMetrics, ITextViewer viewer, boolean afterPosition) {
        Position widgetPosition = this.computeWidgetPosition(viewer);
        if (widgetPosition == null) {
            return null;
        }
        StyledText textWidget = viewer.getTextWidget();
        boolean usePreviousChar = false;
        if (!afterPosition) {
            usePreviousChar = LineContentAnnotation.drawRightToPreviousChar(widgetPosition.getOffset(), textWidget);
        }
        if (this.width == 0 || this.getRedrawnCharacterWidth() == 0) {
            return null;
        }
        int fullWidth = this.width + this.getRedrawnCharacterWidth();
        if (style == null) {
            style = new StyleRange();
            style.start = widgetPosition.getOffset();
            if (usePreviousChar) {
                --style.start;
            }
            style.length = 1;
        }
        GlyphMetrics metrics = style.metrics;
        if (!this.isMarkedDeleted()) {
            if (metrics == null) {
                metrics = new GlyphMetrics(fontMetrics.getAscent(), fontMetrics.getDescent(), fullWidth);
            } else {
                if (metrics.width == fullWidth) {
                    return null;
                }
                metrics = new GlyphMetrics(fontMetrics.getAscent(), fontMetrics.getDescent(), fullWidth);
            }
        } else {
            metrics = null;
        }
        style.metrics = metrics;
        return style;
    }

    static boolean drawRightToPreviousChar(int widgetOffset, StyledText textWidget) {
        return widgetOffset > 0 && widgetOffset < textWidget.getCharCount() && textWidget.getLineAtOffset(widgetOffset) == textWidget.getLineAtOffset(widgetOffset - 1);
    }

    boolean isEmptyLine(int widgetOffset, StyledText text) {
        if (text.getCharCount() <= widgetOffset) {
            return true;
        }
        int line = text.getLineAtOffset(widgetOffset);
        String lineStr = text.getLine(line);
        return lineStr.length() == 0;
    }
}

