/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;

class StreamUtil {
    private static final long MAX_MEMORY = Runtime.getRuntime().maxMemory();

    StreamUtil() {
    }

    static int findLimit(InputStream inputStream) {
        if (inputStream instanceof ByteArrayInputStream) {
            return ((ByteArrayInputStream)inputStream).available();
        }
        if (inputStream instanceof FileInputStream) {
            try {
                long l;
                FileChannel fileChannel = ((FileInputStream)inputStream).getChannel();
                long l2 = l = fileChannel != null ? fileChannel.size() : Integer.MAX_VALUE;
                if (l < Integer.MAX_VALUE) {
                    return (int)l;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (MAX_MEMORY > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)MAX_MEMORY;
    }

    static void writeNewPacketLength(OutputStream outputStream, long l) throws IOException {
        if (l < 192L) {
            outputStream.write((byte)l);
        } else if (l <= 8383L) {
            outputStream.write((byte)(((l -= 192L) >> 8 & 0xFFL) + 192L));
            outputStream.write((byte)l);
        } else {
            outputStream.write(255);
            StreamUtil.writeBodyLen(outputStream, l);
        }
    }

    static void writeBodyLen(OutputStream outputStream, long l) throws IOException {
        outputStream.write((byte)(l >> 24));
        outputStream.write((byte)(l >> 16));
        outputStream.write((byte)(l >> 8));
        outputStream.write((byte)l);
    }

    static void writeKeyID(BCPGOutputStream bCPGOutputStream, long l) throws IOException {
        bCPGOutputStream.write((byte)(l >> 56));
        bCPGOutputStream.write((byte)(l >> 48));
        bCPGOutputStream.write((byte)(l >> 40));
        bCPGOutputStream.write((byte)(l >> 32));
        bCPGOutputStream.write((byte)(l >> 24));
        bCPGOutputStream.write((byte)(l >> 16));
        bCPGOutputStream.write((byte)(l >> 8));
        bCPGOutputStream.write((byte)l);
    }

    static long readKeyID(BCPGInputStream bCPGInputStream) throws IOException {
        long l = (long)bCPGInputStream.read() << 56;
        l |= (long)bCPGInputStream.read() << 48;
        l |= (long)bCPGInputStream.read() << 40;
        l |= (long)bCPGInputStream.read() << 32;
        l |= (long)bCPGInputStream.read() << 24;
        l |= (long)bCPGInputStream.read() << 16;
        return (l |= (long)bCPGInputStream.read() << 8) | (long)bCPGInputStream.read();
    }

    static void writeTime(BCPGOutputStream bCPGOutputStream, long l) throws IOException {
        bCPGOutputStream.write((byte)(l >> 24));
        bCPGOutputStream.write((byte)(l >> 16));
        bCPGOutputStream.write((byte)(l >> 8));
        bCPGOutputStream.write((byte)l);
    }
}

