/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.URIHandler;
import org.eclipse.emf.ecore.resource.impl.URIHandlerImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.oomph.base.ModelElement;
import org.eclipse.oomph.base.util.BaseUtil;
import org.eclipse.oomph.base.util.BytesResourceFactoryImpl;
import org.eclipse.oomph.base.util.EAnnotations;
import org.eclipse.oomph.setup.Configuration;
import org.eclipse.oomph.setup.Stream;
import org.eclipse.oomph.setup.Workspace;
import org.eclipse.oomph.setup.internal.core.Messages;
import org.eclipse.oomph.setup.internal.core.SetupContext;
import org.eclipse.oomph.setup.internal.core.util.ECFURIHandlerImpl;
import org.eclipse.oomph.setup.internal.core.util.ResourceMirror;
import org.eclipse.oomph.setup.internal.core.util.SetupCoreUtil;
import org.eclipse.oomph.util.IORuntimeException;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.OS;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.osgi.util.NLS;

public class SetupArchiver
implements IApplication {
    private static final URI GITHUB_MODELS = URI.createURI((String)"https://raw.githubusercontent.com/eclipse-oomph/oomph/master/setups/models/");
    private static final URI HTTPS_LEGACY_MODELS = URI.createURI((String)"https://git.eclipse.org/c/oomph/org.eclipse.oomph.git/plain/setups/models/");
    private static final URI HTTP_LEGACY_MODELS = URI.createURI((String)"http://git.eclipse.org/c/oomph/org.eclipse.oomph.git/plain/setups/models/");

    public Object start(IApplicationContext context) {
        long finalLastModified;
        Iterator normalizedURI;
        URI uri;
        URI outputLocation;
        File temp;
        long lastModified;
        HashSet<String> entryNames;
        LinkedHashSet<URI> uris;
        File file;
        ConcurrentHashMap configurationImages;
        URIConverter uriConverter;
        ResourceSet resourceSet;
        block76: {
            String[] arguments = (String[])context.getArguments().get("application.args");
            resourceSet = SetupCoreUtil.createResourceSet();
            uriConverter = resourceSet.getURIConverter();
            configurationImages = new ConcurrentHashMap();
            EList uriHandlers = uriConverter.getURIHandlers();
            uriHandlers.add(0, (Object)new URIHandlerImpl(){

                public boolean canHandle(URI uri) {
                    return configurationImages.containsKey(uri);
                }

                public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
                    return super.createInputStream((URI)configurationImages.get(uri), options);
                }
            });
            ListIterator it = uriHandlers.listIterator();
            while (it.hasNext()) {
                final URIHandler uriHandler = (URIHandler)it.next();
                if (!(uriHandler instanceof ECFURIHandlerImpl)) continue;
                it.set(new URIHandler(){

                    public void setAttributes(URI uri, Map<String, ?> attributes, Map<?, ?> options) throws IOException {
                        uriHandler.setAttributes(uri, attributes, options);
                    }

                    public Map<String, ?> getAttributes(URI uri, Map<?, ?> options) {
                        return uriHandler.getAttributes(uri, options);
                    }

                    public boolean exists(URI uri, Map<?, ?> options) {
                        return uriHandler.exists(uri, options);
                    }

                    public void delete(URI uri, Map<?, ?> options) throws IOException {
                        uriHandler.delete(uri, options);
                    }

                    public OutputStream createOutputStream(URI uri, Map<?, ?> options) throws IOException {
                        return uriHandler.createOutputStream(uri, options);
                    }

                    public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
                        InputStream result = uriHandler.createInputStream(uri, options);
                        try {
                            ByteArrayOutputStream initialOut = new ByteArrayOutputStream();
                            IOUtil.copy((InputStream)result, (OutputStream)initialOut);
                            result.close();
                            byte[] initialBytes = initialOut.toByteArray();
                            result = uriHandler.createInputStream(uri, options);
                            ByteArrayOutputStream secondaryOut = new ByteArrayOutputStream();
                            IOUtil.copy((InputStream)result, (OutputStream)secondaryOut);
                            result.close();
                            byte[] secondaryBytes = secondaryOut.toByteArray();
                            if (Arrays.equals(initialBytes, secondaryBytes)) {
                                return new ByteArrayInputStream(initialBytes);
                            }
                            throw new IOException(NLS.bind((String)Messages.SetupArchiver_InconsistentResults_exception, (Object)uri));
                        }
                        catch (IORuntimeException ex) {
                            throw new IOException(ex);
                        }
                    }

                    public Map<String, ?> contentDescription(URI uri, Map<?, ?> options) throws IOException {
                        return uriHandler.contentDescription(uri, options);
                    }

                    public boolean canHandle(URI uri) {
                        return uriHandler.canHandle(uri);
                    }
                });
            }
            URI archiveLocation = uriConverter.normalize(SetupContext.INDEX_SETUP_ARCHIVE_LOCATION_URI);
            file = new File(ECFURIHandlerImpl.getCacheFile(archiveLocation).toFileString());
            uris = new LinkedHashSet<URI>();
            uris.add(SetupContext.INDEX_SETUP_URI);
            boolean expectURIs = false;
            int i = 0;
            while (i < arguments.length) {
                String argument = arguments[i];
                if (argument.startsWith("-")) {
                    expectURIs = false;
                }
                if (expectURIs) {
                    uris.add(URI.createURI((String)argument));
                } else if ("-target".equals(argument)) {
                    file = new File(arguments[++i]);
                } else if ("-uris".equals(argument)) {
                    expectURIs = true;
                }
                ++i;
            }
            String url = file.getAbsolutePath();
            if (url.startsWith("/home/data/httpd/")) {
                url = "https://" + url.substring("/home/data/httpd/".length());
                System.out.println();
                System.out.println("--> " + url);
                System.out.println();
            }
            entryNames = new HashSet<String>();
            lastModified = file.lastModified();
            temp = new File(String.valueOf(file.toString()) + ".tmp");
            if (lastModified == 0L) {
                outputLocation = URI.createURI((String)("archive:" + URI.createFileURI((String)file.toString()) + "!/"));
            } else {
                IOUtil.copyFile((File)file, (File)temp);
                if (!temp.setLastModified(lastModified)) {
                    throw new IORuntimeException(NLS.bind((String)Messages.SetupArchiver_CouldNotSetTimestamp_exception, (Object)temp));
                }
                outputLocation = URI.createURI((String)("archive:" + URI.createFileURI((String)temp.toString()) + "!/"));
                ZipFile zipFile = null;
                try {
                    try {
                        zipFile = new ZipFile(temp);
                        Enumeration<? extends ZipEntry> entries = zipFile.entries();
                        while (entries.hasMoreElements()) {
                            ZipEntry zipEntry = entries.nextElement();
                            String name = zipEntry.getName();
                            entryNames.add(name);
                            URI path = URI.createURI((String)name);
                            URI uri2 = URI.createURI((String)(String.valueOf(path.segment(0)) + ":" + "//" + path.segment(1)));
                            int i2 = 2;
                            int length = path.segmentCount();
                            while (i2 < length) {
                                uri2 = uri2.appendSegment(path.segment(i2));
                                ++i2;
                            }
                            Iterator archiveEntry = URI.createURI((String)("archive:" + URI.createFileURI((String)file.toString()) + "!/" + path));
                            System.out.println(NLS.bind((String)Messages.SetupArchiver_PreviouslyMirrored_message, (Object)uri2, (Object)archiveEntry));
                        }
                    }
                    catch (IOException ex) {
                        if (!file.delete()) {
                            throw new IORuntimeException(NLS.bind((String)Messages.SetupArchiver_CouldNotDeleteBadVersion_exception, (Object)file));
                        }
                        lastModified = 0L;
                        outputLocation = URI.createURI((String)("archive:" + URI.createFileURI((String)file.toString()) + "!/"));
                        try {
                            if (zipFile != null) {
                                zipFile.close();
                            }
                            break block76;
                        }
                        catch (IOException ex2) {
                            ex2.printStackTrace();
                        }
                        break block76;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (zipFile != null) {
                            zipFile.close();
                        }
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                    throw throwable;
                }
                try {
                    if (zipFile != null) {
                        zipFile.close();
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        ECFURIHandlerImpl.CacheHandling cacheHandling = ECFURIHandlerImpl.CacheHandling.valueOf(System.getProperty("OPTION_CACHE_HANDLING", ECFURIHandlerImpl.CacheHandling.CACHE_IGNORE.toString()));
        resourceSet.getLoadOptions().put("OPTION_CACHE_HANDLING", cacheHandling);
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("svg", new BytesResourceFactoryImpl());
        Map uriMap = uriConverter.getURIMap();
        uriMap.put(HTTPS_LEGACY_MODELS, GITHUB_MODELS);
        uriMap.put(HTTP_LEGACY_MODELS, GITHUB_MODELS);
        ResourceMirror.WithProductImages resourceMirror = new ResourceMirror.WithProductImages(resourceSet){

            @Override
            protected void visit(EObject eObject) {
                URI imageURI;
                EClass eClass;
                if (eObject instanceof EClass && !(eClass = (EClass)eObject).isAbstract() && (imageURI = EAnnotations.getImageURI((EClass)eClass)) != null && resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().containsKey(imageURI.fileExtension())) {
                    this.schedule(imageURI, true);
                }
                if (eObject instanceof Configuration) {
                    Configuration configuration = (Configuration)eObject;
                    String badgeLabel = BaseUtil.getAnnotation((ModelElement)configuration, (String)"http://www.eclipse.org/oomph/setup/BrandingInfo", (String)"badgeLabel");
                    if (!StringUtil.isEmpty((String)badgeLabel)) {
                        this.schedule(badgeLabel, badgeLabel);
                    } else {
                        Workspace workspace = configuration.getWorkspace();
                        if (workspace != null) {
                            UniqueEList projects = new UniqueEList();
                            for (Stream stream : workspace.getStreams()) {
                                String proxyURI = EcoreUtil.getURI((EObject)stream).toString();
                                Matcher matcher = Pattern.compile("/@projects\\[name='([^']+)'\\]").matcher(proxyURI);
                                if (!matcher.find()) continue;
                                projects.add(URI.decode((String)matcher.group(1)));
                            }
                            if (!projects.isEmpty()) {
                                StringBuilder compositeLabel = new StringBuilder();
                                StringBuilder compositeFileName = new StringBuilder();
                                for (String project : projects) {
                                    if (compositeLabel.length() != 0) {
                                        compositeLabel.append(" + ");
                                        compositeFileName.append("_");
                                    }
                                    compositeLabel.append(project);
                                    compositeFileName.append(project);
                                    if (projects.size() <= 1) continue;
                                    this.schedule(project, project);
                                }
                                this.schedule(compositeFileName.toString(), compositeLabel.toString());
                            }
                        }
                    }
                }
                super.visit(eObject);
            }

            private void schedule(String fileName, String label) {
                URI svgURI = URI.createURI((String)("svg:/" + IOUtil.encodeFileName((String)fileName).replace(' ', '_') + ".svg"));
                URI imageURI = URI.createURI((String)SetupArchiver.this.getConfigurationImage(label));
                configurationImages.put(svgURI, imageURI);
                this.schedule(svgURI);
            }
        };
        resourceMirror.perform(uris);
        resourceMirror.dispose();
        EList resources = resourceSet.getResources();
        int i = 0;
        while (i < resources.size()) {
            for (EObject eObject : ((Resource)resources.get(i)).getContents()) {
                try {
                    eObject.eContainer();
                }
                catch (RuntimeException ex) {
                    System.err.println("Unresolved proxy " + ((InternalEObject)eObject).eInternalContainer());
                }
                this.resolveAll(eObject);
            }
            ++i;
        }
        ECFURIHandlerImpl.clearExpectedETags();
        HashMap<String, String> options = new HashMap<String, String>();
        if (lastModified != 0L) {
            options.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        }
        options.put("LINE_DELIMITER", "\n");
        Iterator it = uriMap.keySet().iterator();
        while (it.hasNext()) {
            URI uri3 = (URI)it.next();
            URI deresolvedURI = uri3.deresolve(SetupContext.INDEX_ROOT_LOCATION_URI);
            if (!deresolvedURI.isRelative()) continue;
            it.remove();
        }
        uriMap.remove(SetupContext.INDEX_ROOT_LOCATION_URI);
        boolean hasEcoreFailures = false;
        for (Resource resource : resourceSet.getResources()) {
            URI schemLocationURI;
            String schemaLocation;
            uri = resource.getURI();
            if (!"ecore".equals(uri.fileExtension())) continue;
            normalizedURI = uriConverter.normalize(uri);
            if (resource.getContents().isEmpty() || !resource.getErrors().isEmpty()) {
                System.err.println(NLS.bind((String)Messages.SetupArchiver_FailedToLoad_message, normalizedURI));
                this.printDiagnostics((List<Resource.Diagnostic>)resource.getErrors());
                System.err.println(Messages.SetupArchiver_Aborting_message);
                hasEcoreFailures = true;
                break;
            }
            EPackage ePackage = (EPackage)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)EcorePackage.Literals.EPACKAGE);
            if (ePackage != null && (schemaLocation = EcoreUtil.getAnnotation((EModelElement)ePackage, (String)"http://www.eclipse.org/emf/2002/Ecore", (String)"schemaLocation")) != null && uriConverter.normalize(schemLocationURI = URI.createURI((String)schemaLocation)).equals(normalizedURI)) {
                URI newSchemaLocation = schemLocationURI.replacePrefix(HTTP_LEGACY_MODELS, GITHUB_MODELS);
                if (newSchemaLocation != null) {
                    schemLocationURI = newSchemaLocation;
                }
                resource.setURI(schemLocationURI);
                continue;
            }
            resource.setURI(normalizedURI);
        }
        if (PropertiesUtil.isProperty((String)"org.eclipse.oomph.setup.internal.core.SetupArchiver.traceEcore")) {
            for (Resource resource : resourceSet.getResources()) {
                uri = resource.getURI();
                normalizedURI = uriConverter.normalize(uri);
                if (!"ecore".equals(uri.fileExtension()) && !"ecore".equals(normalizedURI.fileExtension())) continue;
                System.out.println("Model: " + uri + " -> " + normalizedURI);
            }
        }
        if (!hasEcoreFailures) {
            URI output;
            URI path;
            String scheme;
            boolean hasFailures = false;
            LinkedHashMap<Resource, URI> legacyResources = new LinkedHashMap<Resource, URI>();
            for (Resource resource : resourceSet.getResources()) {
                URI uri4 = resource.getURI();
                URI normalizedURI2 = uriConverter.normalize(uri4);
                scheme = normalizedURI2.scheme();
                if (normalizedURI2.query() == null && ("http".equals(scheme) || "https".equals(scheme) || "svg".equals(scheme))) {
                    path = URI.createURI((String)scheme);
                    if (normalizedURI2.hasAuthority()) {
                        path = path.appendSegment(normalizedURI2.authority());
                    }
                    path = path.appendSegments(normalizedURI2.segments());
                    System.out.println(NLS.bind((String)Messages.SetupArchiver_Mirroring_message, (Object)normalizedURI2));
                    output = path.resolve(outputLocation);
                    entryNames.remove(path.toString());
                    URI old = uriMap.put(uri4, output);
                    if (resource.getContents().isEmpty() || !resource.getErrors().isEmpty()) {
                        System.err.println(NLS.bind((String)Messages.SetupArchiver_FailedToLoad_message, (Object)normalizedURI2));
                        this.printDiagnostics((List<Resource.Diagnostic>)resource.getErrors());
                        hasFailures = true;
                    } else if (this.hasUnrecongizedXMLContent(resource)) {
                        System.err.println(NLS.bind((String)Messages.SetupArchiver_FailedToLoadProperly_message, (Object)normalizedURI2));
                    } else {
                        try {
                            URI legacyURI = normalizedURI2.replacePrefix(SetupContext.INDEX_ROOT_LOCATION_URI, SetupContext.LEGACY_INDEX_ROOT_LOCATION_URI);
                            if (legacyURI != null) {
                                legacyResources.put(resource, legacyURI);
                            }
                            long before = resource.getTimeStamp();
                            resource.save(options);
                            long after = resource.getTimeStamp();
                            if (after - before > 0L) {
                                System.err.println(NLS.bind((String)Messages.SetupArchiver_Changed_message, (Object)normalizedURI2));
                            }
                        }
                        catch (IOException ex) {
                            System.err.println(NLS.bind((String)Messages.SetupArchiver_FailedToSave_message, (Object)normalizedURI2));
                            ex.printStackTrace();
                        }
                    }
                    uriMap.put(uri4, old);
                    continue;
                }
                System.out.println(NLS.bind((String)Messages.SetupArchiver_Ignoring_message, (Object)normalizedURI2));
            }
            for (Map.Entry entry : legacyResources.entrySet()) {
                URI legacyURI = (URI)entry.getValue();
                if ("ecore".equals(legacyURI.fileExtension())) continue;
                URI indexURI = legacyURI.replacePrefix(SetupContext.LEGACY_INDEX_ROOT_LOCATION_URI, SetupContext.INDEX_ROOT_URI);
                uriMap.put(indexURI, legacyURI);
                ((Resource)entry.getKey()).setURI(indexURI);
            }
            for (Map.Entry entry : legacyResources.entrySet()) {
                Resource resource = (Resource)entry.getKey();
                URI uri5 = (URI)entry.getValue();
                scheme = uri5.scheme();
                path = URI.createURI((String)scheme);
                path = path.appendSegment(uri5.authority());
                path = path.appendSegments(uri5.segments());
                System.out.println(NLS.bind((String)Messages.SetupArchiver_MirroringLegacy_message, (Object)uri5));
                output = path.resolve(outputLocation);
                entryNames.remove(path.toString());
                uriMap.put(resource.getURI(), output);
                uriMap.put(uri5, output);
                try {
                    long before = resource.getTimeStamp();
                    resource.save(options);
                    long after = resource.getTimeStamp();
                    if (after - before <= 0L) continue;
                    System.err.println(NLS.bind((String)Messages.SetupArchiver_Changed_message, (Object)uri5));
                }
                catch (IOException ex) {
                    System.err.println(NLS.bind((String)Messages.SetupArchiver_FailedToSave_message, (Object)uri5));
                    ex.printStackTrace();
                }
            }
            if (hasFailures) {
                System.err.println(Messages.SetupArchiver_Failures_message);
            } else {
                for (String entryName : entryNames) {
                    URI archiveEntry = URI.createURI((String)(outputLocation + entryName));
                    try {
                        uriConverter.delete(archiveEntry, null);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
        long l = finalLastModified = lastModified == 0L ? file.lastModified() : temp.lastModified();
        if (lastModified != finalLastModified) {
            if (OS.INSTANCE.isWin() && lastModified != 0L && !file.delete()) {
                System.err.println(NLS.bind((String)Messages.SetupArchiver_CouldNotDelete_message, (Object)file));
            }
            if (lastModified == 0L) {
                if (this.isDamaged(file)) {
                    System.err.println(NLS.bind((String)Messages.SetupArchiver_ArchiveDamaged_message, (Object)file));
                    file.delete();
                } else {
                    System.out.println(NLS.bind((String)Messages.SetupArchiver_SuccessfullyCreated_message, (Object)file));
                }
            } else if (this.isDamaged(temp)) {
                System.err.println(NLS.bind((String)Messages.SetupArchiver_ArchiveDamagedKeepOld_message, (Object)temp));
                temp.delete();
            } else {
                File backup = new File(file.getParentFile(), String.valueOf(file.getName()) + ".bak");
                try {
                    IOUtil.copyFile((File)temp, (File)backup);
                }
                catch (Throwable throwable) {
                    System.err.println(NLS.bind((String)Messages.SetupArchiver_CouldNotBackUp_message, (Object)backup));
                }
                if (temp.renameTo(file)) {
                    System.out.println(NLS.bind((String)Messages.SetupArchiver_SuccessfulUpdates_message, (Object)file));
                } else {
                    System.err.println(NLS.bind((String)Messages.SetupArchiver_CouldNotRename_message, (Object)temp, (Object)file));
                }
            }
        } else {
            System.out.println(NLS.bind((String)Messages.SetupArchiver_NoUpdates_message, (Object)file));
            if (!temp.delete()) {
                System.err.println(NLS.bind((String)Messages.SetupArchiver_CouldNotDelete_message, (Object)temp));
            }
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private boolean isDamaged(File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[CATCHBLOCK]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean hasUnrecongizedXMLContent(Resource resource) {
        if (resource instanceof XMLResource) {
            Map eObjectToExtensionMap = ((XMLResource)resource).getEObjectToExtensionMap();
            for (AnyType anyType : eObjectToExtensionMap.values()) {
                FeatureMap any = anyType.getAny();
                if (any.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    private void printDiagnostics(List<Resource.Diagnostic> diagnostics) {
        for (Resource.Diagnostic diagnostic : diagnostics) {
            System.err.println(NLS.bind((String)Messages.SetupArchiver_DiagnosticError_message, (Object[])new Object[]{diagnostic.getMessage(), diagnostic.getLine(), diagnostic.getLine(), diagnostic.getColumn()}));
        }
    }

    public void stop() {
    }

    private void resolveAll(EObject eObject) {
        this.resolveAll((EList<EObject>)eObject.eCrossReferences(), false);
        this.resolveAll((EList<EObject>)eObject.eContents(), true);
    }

    private void resolveAll(EList<EObject> references, boolean recursive) {
        Iterator it2 = references.iterator();
        Iterator it3 = ((InternalEList)references).basicIterator();
        while (it3.hasNext()) {
            EObject reference = (EObject)it3.next();
            try {
                EObject resolvedReference = (EObject)it2.next();
                if (!recursive) continue;
                this.resolveAll(resolvedReference);
            }
            catch (RuntimeException ex) {
                System.err.println("Unresolved proxy " + reference);
            }
        }
    }

    String getConfigurationImage(String label) {
        String encodedLabel = URI.encodeQuery((String)StringUtil.safe((String)label), (boolean)false).toString().replace("+", "%2B").replace("&", "%26");
        return "https://img.shields.io/static/v1?logo=eclipseide&label=Create%20Development%20Environment&message=" + encodedLabel + "&style=for-the-badge&logoColor=white&labelColor=darkorange&color=gray";
    }
}

