/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.version.ui.preferences;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxViewerCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.oomph.internal.ui.AbstractPreferencePage;
import org.eclipse.oomph.internal.version.Activator;
import org.eclipse.oomph.version.VersionUtil;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class VersionBuilderPreferencePage
extends AbstractPreferencePage {
    public VersionBuilderPreferencePage() {
        this.noDefaultAndApplyButton();
    }

    protected Control doCreateContents(Composite parent) {
        ArrayList releasePaths = new ArrayList(Activator.getReleasePaths());
        Collections.sort(releasePaths);
        final TableViewer viewer = new TableViewer(parent, 68112);
        final Table table = viewer.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableViewerColumn releaseViewerColumn = new TableViewerColumn(viewer, 0);
        final TableColumn releaseColumn = releaseViewerColumn.getColumn();
        releaseColumn.setText("Release");
        releaseColumn.setResizable(false);
        releaseColumn.setMoveable(false);
        TableViewerColumn checkModeViewerColumn = new TableViewerColumn(viewer, 0);
        final TableColumn checkModeColumn = checkModeViewerColumn.getColumn();
        checkModeColumn.setText("Check Mode");
        checkModeColumn.setResizable(false);
        checkModeColumn.setMoveable(false);
        final ControlAdapter columnResizer = new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Point size = table.getSize();
                ScrollBar bar = table.getVerticalBar();
                if (bar != null && bar.isVisible()) {
                    size.x -= bar.getSize().x;
                }
                releaseColumn.setWidth(size.x - checkModeColumn.getWidth());
            }
        };
        checkModeColumn.pack();
        checkModeColumn.setWidth(checkModeColumn.getWidth() + 10);
        table.addControlListener((ControlListener)columnResizer);
        table.getDisplay().asyncExec(new Runnable(){

            public void run() {
                columnResizer.controlResized(null);
            }
        });
        viewer.setColumnProperties(new String[]{"releasePath", "checkMode"});
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new ReleaseCheckModeLabelProvider());
        viewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return "checkMode".equals(property);
            }

            public Object getValue(Object element, String property) {
                return Activator.getReleaseCheckMode((String)((String)element));
            }

            public void modify(Object element, String property, Object value) {
                if (element instanceof TableItem) {
                    element = ((TableItem)element).getData();
                }
                String releasePath = (String)element;
                Activator.setReleaseCheckMode((String)releasePath, (Activator.ReleaseCheckMode)((Activator.ReleaseCheckMode)value));
                viewer.update(element, new String[]{property});
                VersionUtil.cleanReleaseProjects((String)releasePath);
            }
        });
        ComboBoxViewerCellEditor cellEditor = new ComboBoxViewerCellEditor((Composite)table);
        cellEditor.setContentProvider(new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return Activator.ReleaseCheckMode.values();
            }
        });
        CellEditor[] cellEditorArray = new CellEditor[2];
        cellEditorArray[1] = cellEditor;
        viewer.setCellEditors(cellEditorArray);
        cellEditor.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        viewer.setInput(releasePaths);
        cellEditor.setInput(releasePaths);
        return table;
    }

    private static final class ReleaseCheckModeLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ReleaseCheckModeLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String releasePath = element.toString();
            if (columnIndex == 0) {
                return releasePath;
            }
            Activator.ReleaseCheckMode releaseCheckMode = Activator.getReleaseCheckMode((String)releasePath);
            return releaseCheckMode == null ? "bad" : releaseCheckMode.toString();
        }
    }
}

