/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.ui;

import org.eclipse.oomph.ui.StackComposite;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public abstract class MouseHandler {
    private final MouseTrackListener mouseTrackListener = new MouseTrackListener(){

        public void mouseEnter(MouseEvent e) {
        }

        public void mouseHover(MouseEvent e) {
        }

        public void mouseExit(MouseEvent e) {
            MouseHandler.this.onMouseMove(e.widget, Integer.MIN_VALUE, Integer.MIN_VALUE);
        }
    };
    private final MouseMoveListener mouseMoveListener = new MouseMoveListener(){

        public void mouseMove(MouseEvent e) {
            MouseHandler.this.onMouseMove(e.widget, e.x, e.y);
        }
    };
    private final MouseListener mouseListener = new MouseListener(){

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
            if (e.button == 1 && e.widget instanceof Control) {
                Control control = (Control)e.widget;
                MouseHandler.this.start = MouseHandler.this.getStart(control, e.x, e.y);
            }
        }

        public void mouseUp(MouseEvent e) {
            if (MouseHandler.this.start != null) {
                if (e.widget instanceof Control) {
                    Control control = (Control)e.widget;
                    MouseHandler.this.afterEnd(control, MouseHandler.this.start, e.x, e.y);
                }
                MouseHandler.this.start = null;
            }
        }
    };
    private Point start;

    public void hookControl(Control control) {
        if (this.shouldHookControl(control)) {
            control.addMouseTrackListener(this.mouseTrackListener);
            control.addMouseMoveListener(this.mouseMoveListener);
            control.addMouseListener(this.mouseListener);
        }
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.hookControl(child);
                ++n2;
            }
        }
    }

    protected boolean shouldHookControl(Control control) {
        Class<?> c = control.getClass();
        return c == Composite.class || c == StackComposite.class || control instanceof Shell || c == Label.class || c == Link.class;
    }

    protected Point getStart(Control control, int x, int y) {
        return new Point(x, y);
    }

    protected void beforeStart(Control control, int x, int y) {
    }

    protected void afterStart(Control control, Point start, int x, int y) {
    }

    protected void afterEnd(Control control, Point start, int x, int y) {
    }

    protected boolean moveShell(Control control, Point start, int x, int y) {
        Shell shell = control.getShell();
        Point location = shell.getLocation();
        location.x += x - start.x;
        location.y += y - start.y;
        shell.setLocation(location);
        return true;
    }

    private void onMouseMove(Widget widget, int x, int y) {
        if (widget instanceof Control) {
            Control control = (Control)widget;
            if (this.start == null) {
                this.beforeStart(control, x, y);
            } else {
                this.afterStart(control, this.start, x, y);
            }
        }
    }

    public static class Move
    extends MouseHandler {
        @Override
        protected void afterStart(Control control, Point start, int x, int y) {
            this.moveShell(control, start, x, y);
        }
    }

    public static class MoveAndResize
    extends MouseHandler {
        private static final int AREA_THICKNESS = 5;
        private static final int CORNER_SIZE = 25;
        private static final int NORTH = 1;
        private static final int SOUTH = 2;
        private static final int EAST = 4;
        private static final int WEST = 8;
        private static final Cursor[] CURSORS = new Cursor[11];
        private final Rectangle[] areas = new Rectangle[11];
        private final Control mainControl;
        private BoundsUpdater boundsUpdater;
        private Rectangle bounds;
        private int index;

        static {
            Display display = UIUtil.getDisplay();
            MoveAndResize.CURSORS[1] = display.getSystemCursor(10);
            MoveAndResize.CURSORS[2] = display.getSystemCursor(11);
            MoveAndResize.CURSORS[8] = display.getSystemCursor(13);
            MoveAndResize.CURSORS[4] = display.getSystemCursor(12);
            MoveAndResize.CURSORS[9] = display.getSystemCursor(17);
            MoveAndResize.CURSORS[5] = display.getSystemCursor(14);
            MoveAndResize.CURSORS[10] = display.getSystemCursor(16);
            MoveAndResize.CURSORS[6] = display.getSystemCursor(15);
        }

        public MoveAndResize(Control control) {
            this.mainControl = control;
            this.computeAreas(control);
            this.hookControl(control);
        }

        public final int getIndex() {
            return this.index;
        }

        @Override
        protected void beforeStart(Control control, int x, int y) {
            if (control == this.mainControl) {
                this.index = this.getIndex(control, x, y);
                if (this.index >= 0) {
                    control.setCursor(CURSORS[this.index]);
                    return;
                }
            }
            this.resetCursor(control);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void afterStart(Control control, Point start, int x, int y) {
            if (control == this.mainControl && this.index >= 0) {
                Rectangle currentBounds = control.getBounds();
                Rectangle newBounds = new Rectangle(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
                x -= start.x;
                y -= start.y;
                if ((this.index & 1) != 0) {
                    newBounds.y += (y -= this.bounds.y - currentBounds.y);
                    newBounds.height -= y;
                }
                if ((this.index & 2) != 0) {
                    newBounds.height += y;
                }
                if ((this.index & 8) != 0) {
                    newBounds.x += (x -= this.bounds.x - currentBounds.x);
                    newBounds.width -= x;
                }
                if ((this.index & 4) != 0) {
                    newBounds.width += x;
                }
                MoveAndResize moveAndResize = this;
                synchronized (moveAndResize) {
                    if (this.boundsUpdater == null) {
                        this.boundsUpdater = new BoundsUpdater();
                    }
                    this.boundsUpdater.updateBounds(newBounds);
                }
                return;
            }
            this.moveShell(control, start, x, y);
            this.computeAreas(this.mainControl);
        }

        @Override
        protected void afterEnd(Control control, Point start, int x, int y) {
            if (control == this.mainControl) {
                if (this.index >= 0) {
                    this.resetCursor(control);
                    this.computeAreas(control);
                }
                this.index = -1;
            }
        }

        private void computeAreas(Control control) {
            this.bounds = control.getBounds();
            this.areas[1] = new Rectangle(this.bounds.x + 25, this.bounds.y, this.bounds.width - 50, 5);
            this.areas[2] = new Rectangle(this.bounds.x + 25, this.bounds.y + this.bounds.height - 5, this.bounds.width - 50, 5);
            this.areas[8] = new Rectangle(this.bounds.x, this.bounds.y + 25, 5, this.bounds.height - 50);
            this.areas[4] = new Rectangle(this.bounds.x + this.bounds.width - 5, this.bounds.y + 25, 5, this.bounds.height - 50);
            this.areas[9] = new Rectangle(this.bounds.x, this.bounds.y, 25, 25);
            this.areas[5] = new Rectangle(this.bounds.x + this.bounds.width - 25, this.bounds.y, 25, 25);
            this.areas[10] = new Rectangle(this.bounds.x, this.bounds.y + this.bounds.height - 25, 25, 25);
            this.areas[6] = new Rectangle(this.bounds.x + this.bounds.width - 25, this.bounds.y + this.bounds.height - 25, 25, 25);
        }

        private int getIndex(Control control, int x, int y) {
            x += this.bounds.x;
            y += this.bounds.y;
            int i = 0;
            while (i < this.areas.length) {
                Rectangle area = this.areas[i];
                if (area != null && area.contains(x, y)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        private void resetCursor(Control control) {
            if (control.getCursor() != null) {
                control.setCursor(null);
            }
        }

        public static String format(int index) {
            StringBuilder builder = new StringBuilder();
            if ((index & 1) != 0) {
                builder.append(" NORTH");
            }
            if ((index & 2) != 0) {
                builder.append(" SOUTH");
            }
            if ((index & 8) != 0) {
                builder.append(" WEST");
            }
            if ((index & 4) != 0) {
                builder.append(" EAST");
            }
            return builder.toString().trim();
        }

        private final class BoundsUpdater
        implements Runnable {
            private Rectangle newBounds;

            private BoundsUpdater() {
            }

            public void updateBounds(Rectangle newBounds) {
                boolean schedule = this.newBounds == null;
                this.newBounds = newBounds;
                if (schedule) {
                    MoveAndResize.this.mainControl.getDisplay().asyncExec((Runnable)this);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Rectangle bounds;
                    MoveAndResize moveAndResize = MoveAndResize.this;
                    synchronized (moveAndResize) {
                        bounds = this.newBounds;
                        this.newBounds = null;
                    }
                    if (bounds != null) {
                        MoveAndResize.this.mainControl.setBounds(bounds);
                        MoveAndResize.this.mainControl.getDisplay().asyncExec((Runnable)this);
                    } else {
                        MoveAndResize.this.boundsUpdater = null;
                    }
                }
                catch (Exception ex) {
                    MoveAndResize.this.boundsUpdater = null;
                }
            }
        }
    }
}

