/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.themes;

import java.util.Hashtable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.themes.ColorUtil;
import org.eclipse.ui.themes.IColorFactory;

public class RGBVisibleContrastColorFactory
implements IColorFactory,
IExecutableExtension {
    private String fg;
    private String bg;
    private String altBg;

    @Override
    public RGB createColor() {
        RGB cfg = this.fg != null ? ColorUtil.getColorValue(this.fg) : new RGB(0, 0, 0);
        RGB cbg = this.bg != null ? ColorUtil.getColorValue(this.bg) : new RGB(255, 255, 255);
        RGB cbgAlt = this.altBg != null ? ColorUtil.getColorValue(this.altBg) : new RGB(255, 255, 255);
        float bfg = cfg.getHSB()[2];
        float bbg = cbg.getHSB()[2];
        float bbgAlt = cbgAlt.getHSB()[2];
        if (Math.abs(bbg - bfg) < 0.5f && Math.abs(bbgAlt - bfg) > Math.abs(bbg - bfg)) {
            return cbgAlt;
        }
        return cbg;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) {
        if (data instanceof Hashtable) {
            Hashtable table = (Hashtable)data;
            this.fg = (String)table.get("foreground");
            this.bg = (String)table.get("background");
            this.altBg = (String)table.get("alternativeBackground");
        }
    }
}

