/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.contexts;

import java.util.Objects;
import java.util.Set;
import org.eclipse.e4.core.contexts.IContextFunction;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.IInjector;
import org.eclipse.e4.core.internal.contexts.Computation;
import org.eclipse.e4.core.internal.contexts.ContextChangeEvent;
import org.eclipse.e4.core.internal.contexts.EclipseContext;

public class ValueComputation
extends Computation {
    private static final Object NotAValue = new Object();
    private final IContextFunction function;
    private final EclipseContext originatingContext;
    private final String name;
    private Object cachedValue = NotAValue;
    private volatile boolean computing;
    private boolean valid = true;

    public ValueComputation(String name, IEclipseContext originatingContext, IContextFunction computedValue) {
        this.originatingContext = (EclipseContext)originatingContext;
        this.function = computedValue;
        this.name = name;
        this.init();
    }

    @Override
    public void handleInvalid(ContextChangeEvent event, Set<EclipseContext.Scheduled> scheduled) {
        if (this.cachedValue == NotAValue) {
            return;
        }
        this.cachedValue = NotAValue;
        this.originatingContext.invalidate(this.name, 6, event.getOldValue(), IInjector.NOT_A_VALUE, scheduled);
    }

    public boolean shouldRemove(ContextChangeEvent event) {
        boolean definitionChanged;
        int eventType = event.getEventType();
        boolean containerDisposed = eventType == 3 && event.getContext() == this.originatingContext;
        boolean bl = definitionChanged = eventType != 6 && this.name.equals(event.getName());
        return containerDisposed || definitionChanged;
    }

    public Object get() {
        boolean hasCycle;
        if (this.cachedValue != NotAValue) {
            return this.cachedValue;
        }
        if (this.computing && (hasCycle = this.originatingContext.hasComputation(this))) {
            throw new RuntimeException("Cycle while computing value " + String.valueOf(this));
        }
        this.originatingContext.pushComputation(this);
        this.computing = true;
        try {
            Object computed = this.function.compute(this.originatingContext, this.name);
            this.cacheComputedValue(computed);
        }
        finally {
            this.computing = false;
            this.originatingContext.popComputation(this);
        }
        return this.cachedValue;
    }

    private synchronized void cacheComputedValue(Object computed) {
        if (this.cachedValue == NotAValue) {
            this.cachedValue = computed;
        }
    }

    public String toString() {
        if (this.function == null) {
            return super.toString();
        }
        return this.function.toString();
    }

    @Override
    protected int calcHashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(this.function);
        result = 31 * result + Objects.hashCode(this.name);
        return 31 * result + Objects.hashCode(this.originatingContext);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValueComputation other = (ValueComputation)obj;
        return Objects.equals(this.function, other.function) && Objects.equals(this.name, other.name) && Objects.equals(this.originatingContext, other.originatingContext);
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    public void dispose() {
        this.valid = false;
    }
}

