/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.SWTFontProvider;
import org.eclipse.swt.internal.win32.LOGFONT;
import org.eclipse.swt.internal.win32.OS;

public final class Font
extends Resource {
    public long handle;
    int zoom;

    Font(Device device) {
        super(device);
        this.zoom = Font.extractZoom(this.device);
    }

    public Font(Device device, FontData fd) {
        super(device);
        this.zoom = Font.extractZoom(this.device);
        this.init(fd);
        this.init();
    }

    private Font(Device device, FontData fd, int zoom) {
        super(device);
        this.zoom = zoom;
        this.init(fd);
        this.init();
    }

    public Font(Device device, FontData[] fds) {
        super(device);
        if (fds == null) {
            SWT.error(4);
        }
        if (fds.length == 0) {
            SWT.error(5);
        }
        FontData[] fontDataArray = fds;
        int n = fds.length;
        int n2 = 0;
        while (n2 < n) {
            FontData fd = fontDataArray[n2];
            if (fd == null) {
                SWT.error(5);
            }
            ++n2;
        }
        this.zoom = Font.extractZoom(this.device);
        this.init(fds[0]);
        this.init();
    }

    public Font(Device device, String name, int height, int style) {
        super(device);
        if (name == null) {
            SWT.error(4);
        }
        this.zoom = Font.extractZoom(this.device);
        this.init(new FontData(name, height, style));
        this.init();
    }

    Font(Device device, String name, float height, int style) {
        super(device);
        if (name == null) {
            SWT.error(4);
        }
        this.zoom = Font.extractZoom(this.device);
        this.init(new FontData(name, height, style));
        this.init();
    }

    @Override
    void destroy() {
        OS.DeleteObject(this.handle);
        this.handle = 0L;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Font)) {
            return false;
        }
        Font font = (Font)object;
        return this.device == font.device && this.handle == font.handle;
    }

    public FontData[] getFontData() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        LOGFONT logFont = new LOGFONT();
        OS.GetObject(this.handle, LOGFONT.sizeof, logFont);
        float heightInPoints = this.device.computePoints(logFont, this.handle, this.zoom);
        return new FontData[]{FontData.win32_new(logFont, heightInPoints)};
    }

    public int hashCode() {
        return (int)this.handle;
    }

    void init(FontData fd) {
        if (fd == null) {
            SWT.error(4);
        }
        LOGFONT logFont = fd.data;
        int lfHeight = logFont.lfHeight;
        logFont.lfHeight = this.device.computePixels(fd.height, this.zoom);
        this.handle = OS.CreateFontIndirect(logFont);
        logFont.lfHeight = lfHeight;
        if (this.handle == 0L) {
            SWT.error(2);
        }
    }

    @Override
    public boolean isDisposed() {
        return this.handle == 0L;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Font {*DISPOSED*}";
        }
        return "Font {" + this.handle + "}";
    }

    private static int extractZoom(Device device) {
        if (device == null) {
            return DPIUtil.getNativeDeviceZoom();
        }
        return device.getDeviceZoom();
    }

    public static Font win32_new(Device device, long handle) {
        Font font = new Font(device);
        font.zoom = Font.extractZoom(font.device);
        font.handle = handle;
        font.ignoreNonDisposed();
        return font;
    }

    public static Font win32_new(Device device, long handle, int zoom) {
        Font font = new Font(device);
        font.zoom = zoom;
        font.handle = handle;
        font.ignoreNonDisposed();
        return font;
    }

    public static Font win32_new(Device device, FontData fontData, int zoom) {
        return new Font(device, fontData, zoom);
    }

    public static Font win32_new(Font font, int targetZoom) {
        if (targetZoom == font.zoom) {
            return font;
        }
        return SWTFontProvider.getFont(font.getDevice(), font.getFontData()[0], targetZoom);
    }
}

