/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.userstorage.ui.internal;

import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public final class UIUtil {
    private UIUtil() {
    }

    public static Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            try {
                display = PlatformUI.getWorkbench().getDisplay();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (display == null) {
            display = new Display();
        }
        return display;
    }

    public static Shell getShell() {
        final Shell[] shell = new Shell[1];
        final Display display = UIUtil.getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                Shell[] shells;
                shell[0] = display.getActiveShell();
                if (shell[0] == null) {
                    try {
                        IWorkbenchWindow[] windows;
                        IWorkbench workbench = PlatformUI.getWorkbench();
                        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                        if (window == null && (windows = PlatformUI.getWorkbench().getWorkbenchWindows()).length != 0) {
                            window = windows[0];
                        }
                        if (window != null) {
                            shell[0] = window.getShell();
                        }
                    }
                    catch (Throwable workbench) {
                        // empty catch block
                    }
                }
                if (shell[0] == null && (shells = display.getShells()).length > 0) {
                    shell[0] = shells[0];
                }
            }
        });
        return shell[0];
    }

    public static GridLayout createGridLayout(int numColumns) {
        GridLayout layout = new GridLayout(numColumns, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        return layout;
    }
}

