/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.engine.phases;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.engine.CollectEvent;
import org.eclipse.equinox.internal.p2.engine.DownloadManager;
import org.eclipse.equinox.internal.p2.engine.InstallableUnitOperand;
import org.eclipse.equinox.internal.p2.engine.InstallableUnitPhase;
import org.eclipse.equinox.internal.p2.engine.Messages;
import org.eclipse.equinox.internal.p2.engine.phases.AuthorityChecker;
import org.eclipse.equinox.internal.p2.repository.DownloadPauseResumeEvent;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.IProvisioningEventBus;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.PhaseSetFactory;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.engine.spi.ProvisioningAction;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.ITouchpointType;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRequest;
import org.eclipse.osgi.util.NLS;

public class Collect
extends InstallableUnitPhase {
    public static final String PARM_ARTIFACT_REQUESTS = "artifactRequests";
    public static final String NO_ARTIFACT_REPOSITORIES_AVAILABLE = "noArtifactRepositoriesAvailable";
    private static final String PARM_IUS = "ius";
    private IProvisioningAgent agent = null;

    public Collect(int weight) {
        super(PhaseSetFactory.PHASE_COLLECT, weight);
        this.prePerformWork = 0;
        this.mainPerformWork = 100;
        this.postPerformWork = 1000;
    }

    @Override
    protected boolean isApplicable(InstallableUnitOperand op) {
        return op.second() != null && !op.second().equals((Object)op.first());
    }

    @Override
    protected List<ProvisioningAction> getActions(InstallableUnitOperand operand) {
        IInstallableUnit unit = operand.second();
        List<ProvisioningAction> parsedActions = this.getActions(unit, this.phaseId);
        if (parsedActions != null) {
            return parsedActions;
        }
        ITouchpointType type = unit.getTouchpointType();
        if (type == null || type == ITouchpointType.NONE) {
            return null;
        }
        String actionId = this.getActionManager().getTouchpointQualifiedActionId(this.phaseId, type);
        ProvisioningAction action = this.getActionManager().getAction(actionId, null);
        if (action == null) {
            return null;
        }
        return Collections.singletonList(action);
    }

    @Override
    protected String getProblemMessage() {
        return Messages.Phase_Collect_Error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IStatus completePhase(IProgressMonitor monitor, IProfile profile, Map<String, Object> parameters) {
        IStatus iStatus;
        Set ius;
        IStatus authorityStatus;
        if (monitor.isCanceled()) {
            return Status.OK_STATUS;
        }
        List artifactRequests = (List)parameters.get(PARM_ARTIFACT_REQUESTS);
        if (artifactRequests.size() == 0) {
            return Status.OK_STATUS;
        }
        ProvisioningContext context = (ProvisioningContext)parameters.get("context");
        Collect collect = this;
        synchronized (collect) {
            this.agent = (IProvisioningAgent)parameters.get("agent");
        }
        if (Boolean.parseBoolean(context.getProperty("org.eclipse.equinox.p2.director.checkAuthorities")) && !(authorityStatus = new AuthorityChecker(this.agent, context, ius = (Set)parameters.get(PARM_IUS), artifactRequests.stream().flatMap(Arrays::stream).map(IArtifactRequest::getArtifactKey).collect(Collectors.toList()), profile).start(monitor)).isOK()) {
            return authorityStatus;
        }
        if (this.isPaused) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                return new Status(4, "org.eclipse.equinox.p2.engine", NLS.bind((String)Messages.phase_thread_interrupted_error, (Object)this.phaseId), (Throwable)e);
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
        }
        ArrayList<IArtifactRequest> totalArtifactRequests = new ArrayList<IArtifactRequest>(artifactRequests.size());
        DownloadManager dm = new DownloadManager(context, this.agent);
        Iterator iterator = artifactRequests.iterator();
        while (iterator.hasNext()) {
            IArtifactRequest[] requests;
            IArtifactRequest[] iArtifactRequestArray = requests = (IArtifactRequest[])iterator.next();
            int n = requests.length;
            int n2 = 0;
            while (n2 < n) {
                IArtifactRequest request = iArtifactRequestArray[n2];
                dm.add(request);
                totalArtifactRequests.add(request);
                ++n2;
            }
        }
        IProvisioningEventBus bus = (IProvisioningEventBus)this.agent.getService(IProvisioningEventBus.class);
        if (bus != null) {
            bus.publishEvent((EventObject)new CollectEvent(1, null, context, totalArtifactRequests.toArray(new IArtifactRequest[totalArtifactRequests.size()])));
        }
        IStatus downloadStatus = dm.start(monitor);
        try {
            iStatus = downloadStatus;
        }
        catch (Throwable throwable) {
            if (downloadStatus.isOK() && bus != null) {
                bus.publishEvent((EventObject)new CollectEvent(2, null, context, totalArtifactRequests.toArray(new IArtifactRequest[totalArtifactRequests.size()])));
            }
            Collect collect2 = this;
            synchronized (collect2) {
                this.agent = null;
            }
            throw throwable;
        }
        if (downloadStatus.isOK() && bus != null) {
            bus.publishEvent((EventObject)new CollectEvent(2, null, context, totalArtifactRequests.toArray(new IArtifactRequest[totalArtifactRequests.size()])));
        }
        Collect collect3 = this;
        synchronized (collect3) {
            this.agent = null;
        }
        return iStatus;
    }

    @Override
    protected IStatus initializePhase(IProgressMonitor monitor, IProfile profile, Map<String, Object> parameters) {
        parameters.put(PARM_ARTIFACT_REQUESTS, new ArrayList());
        parameters.put(PARM_IUS, new HashSet());
        return null;
    }

    @Override
    protected void setPaused(boolean isPaused) {
        super.setPaused(isPaused);
        this.firePauseEventToDownloadJobs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePauseEventToDownloadJobs() {
        Collect collect = this;
        synchronized (collect) {
            IProvisioningEventBus bus;
            if (this.agent != null && (bus = (IProvisioningEventBus)this.agent.getService(IProvisioningEventBus.class)) != null) {
                bus.publishEvent((EventObject)new DownloadPauseResumeEvent(this.isPaused ? 1 : 2));
            }
        }
    }

    @Override
    protected IStatus initializeOperand(IProfile profile, InstallableUnitOperand operand, Map<String, Object> parameters, IProgressMonitor monitor) {
        IStatus status = super.initializeOperand(profile, operand, parameters, monitor);
        IInstallableUnit iu = operand.second();
        parameters.put("iu", iu);
        Set ius = (Set)parameters.get(PARM_IUS);
        ius.add(iu);
        return status;
    }
}

