/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.dialogs;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.e4.ui.progress.UIJob;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.dialogs.URLDropAdapter;
import org.eclipse.equinox.p2.operations.RepositoryTracker;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.widgets.Control;

public class RepositoryManipulatorDropTarget
extends URLDropAdapter {
    ProvisioningUI ui;
    RepositoryTracker tracker;
    Control control;

    public RepositoryManipulatorDropTarget(ProvisioningUI ui, Control control) {
        super(true);
        Assert.isNotNull((Object)ui);
        this.ui = ui;
        this.tracker = ui.getRepositoryTracker();
        this.control = control;
    }

    @Override
    protected void handleDrop(String urlText, DropTargetEvent event) {
        event.detail = 0;
        URI[] location = new URI[1];
        try {
            location[0] = URIUtil.fromString((String)urlText);
        }
        catch (URISyntaxException uRISyntaxException) {
            ProvUI.reportStatus(this.tracker.getInvalidLocationStatus(urlText), 3);
            return;
        }
        if (location[0] == null) {
            return;
        }
        UIJob job = UIJob.create((String)ProvUIMessages.RepositoryManipulatorDropTarget_DragAndDropJobLabel, monitor -> {
            IStatus status = this.tracker.validateRepositoryLocation(this.ui.getSession(), location[0], false, monitor);
            if (status.isOK()) {
                this.tracker.addRepository(location[0], null, this.ui.getSession());
                dropTargetEvent.detail = 4;
            } else if (status.getSeverity() == 8) {
                dropTargetEvent.detail = 0;
            } else {
                status = new MultiStatus("org.eclipse.equinox.p2.ui", 0, new IStatus[]{status}, NLS.bind((String)ProvUIMessages.RepositoryManipulatorDropTarget_DragSourceNotValid, (Object)URIUtil.toUnencodedString((URI)location[0])), null);
                dropTargetEvent.detail = 0;
            }
            return status;
        });
        job.setPriority(20);
        job.setUser(true);
        job.schedule();
    }
}

