/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.hqc;

import org.bouncycastle.pqc.crypto.hqc.HQCKeccakRandomGenerator;
import org.bouncycastle.pqc.crypto.hqc.ReedMuller;
import org.bouncycastle.pqc.crypto.hqc.ReedSolomon;
import org.bouncycastle.pqc.crypto.hqc.Utils;
import org.bouncycastle.pqc.math.linearalgebra.GF2mField;
import org.bouncycastle.pqc.math.linearalgebra.PolynomialGF2mSmallM;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class HQCEngine {
    private int n;
    private int n1;
    private int n2;
    private int k;
    private int delta;
    private int w;
    private int wr;
    private int we;
    private int g;
    private int rejectionThreshold;
    private int fft;
    private int mulParam;
    private GF2mField field;
    private PolynomialGF2mSmallM reductionPoly;
    private int SEED_SIZE = 40;
    private byte G_FCT_DOMAIN = (byte)3;
    private byte H_FCT_DOMAIN = (byte)4;
    private byte K_FCT_DOMAIN = (byte)5;
    private int N_BYTE;
    private int n1n2;
    private int N_BYTE_64;
    private int K_BYTE;
    private int K_BYTE_64;
    private int N1_BYTE_64;
    private int N1N2_BYTE_64;
    private int N1N2_BYTE;
    private int N1_BYTE;
    private int[] generatorPoly;
    private int SHA512_BYTES = 64;

    public HQCEngine(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int[] nArray) {
        GF2mField gF2mField;
        this.n = n;
        this.k = n4;
        this.delta = n6;
        this.w = n7;
        this.wr = n8;
        this.we = n9;
        this.n1 = n2;
        this.n2 = n3;
        this.n1n2 = n2 * n3;
        this.generatorPoly = nArray;
        this.g = n5;
        this.rejectionThreshold = n10;
        this.fft = n11;
        this.mulParam = (int)Math.ceil(n3 / 128);
        this.N_BYTE = Utils.getByteSizeFromBitSize(n);
        this.K_BYTE = n4;
        this.N_BYTE_64 = Utils.getByte64SizeFromBitSize(n);
        this.K_BYTE_64 = Utils.getByteSizeFromBitSize(n4);
        this.N1_BYTE_64 = Utils.getByteSizeFromBitSize(n2);
        this.N1N2_BYTE_64 = Utils.getByte64SizeFromBitSize(n2 * n3);
        this.N1N2_BYTE = Utils.getByteSizeFromBitSize(n2 * n3);
        this.N1_BYTE = Utils.getByteSizeFromBitSize(n2);
        this.field = gF2mField = new GF2mField(1);
        PolynomialGF2mSmallM polynomialGF2mSmallM = new PolynomialGF2mSmallM(gF2mField, n);
        this.reductionPoly = polynomialGF2mSmallM.addMonomial(0);
    }

    public void genKeyPair(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        byte[] byArray4 = new byte[this.SEED_SIZE];
        HQCKeccakRandomGenerator hQCKeccakRandomGenerator = new HQCKeccakRandomGenerator(256);
        hQCKeccakRandomGenerator.randomGeneratorInit(byArray3, null, byArray3.length, 0);
        hQCKeccakRandomGenerator.squeeze(byArray4, 40);
        HQCKeccakRandomGenerator hQCKeccakRandomGenerator2 = new HQCKeccakRandomGenerator(256);
        hQCKeccakRandomGenerator2.seedExpanderInit(byArray4, byArray4.length);
        long[] lArray = new long[this.N_BYTE_64];
        int[] nArray = new int[this.w];
        this.generateSecretKey(lArray, hQCKeccakRandomGenerator2, this.w);
        this.generateSecretKeyByCoordinates(nArray, hQCKeccakRandomGenerator2, this.w);
        byte[] byArray5 = Utils.fromListOfPos1ToBitArray(nArray, this.n);
        byte[] byArray6 = new byte[this.n];
        Utils.fromLongArrayToBitArray(byArray6, lArray);
        byte[] byArray7 = new byte[this.SEED_SIZE];
        hQCKeccakRandomGenerator.squeeze(byArray7, 40);
        HQCKeccakRandomGenerator hQCKeccakRandomGenerator3 = new HQCKeccakRandomGenerator(256);
        hQCKeccakRandomGenerator3.seedExpanderInit(byArray7, byArray7.length);
        long[] lArray2 = new long[this.N_BYTE_64];
        this.generatePublicKeyH(lArray2, hQCKeccakRandomGenerator3);
        byte[] byArray8 = new byte[this.n];
        Utils.fromLongArrayToBitArray(byArray8, lArray2);
        PolynomialGF2mSmallM polynomialGF2mSmallM = new PolynomialGF2mSmallM(this.field, Utils.removeLast0Bits(byArray6));
        PolynomialGF2mSmallM polynomialGF2mSmallM2 = new PolynomialGF2mSmallM(this.field, Utils.removeLast0Bits(byArray5));
        PolynomialGF2mSmallM polynomialGF2mSmallM3 = new PolynomialGF2mSmallM(this.field, Utils.removeLast0Bits(byArray8));
        PolynomialGF2mSmallM polynomialGF2mSmallM4 = polynomialGF2mSmallM.add(polynomialGF2mSmallM3.modKaratsubaMultiplyBigDeg(polynomialGF2mSmallM2, this.reductionPoly));
        byte[] byArray9 = polynomialGF2mSmallM4.getEncoded();
        byte[] byArray10 = new byte[this.N_BYTE];
        Utils.fromBitArrayToByteArray(byArray10, byArray9);
        byte[] byArray11 = Arrays.concatenate(byArray7, byArray10);
        byte[] byArray12 = Arrays.concatenate(byArray4, byArray11);
        System.arraycopy(byArray11, 0, byArray, 0, byArray11.length);
        System.arraycopy(byArray12, 0, byArray2, 0, byArray12.length);
    }

    public void encaps(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, byte[] byArray6) {
        byte[] byArray7 = new byte[this.K_BYTE];
        byte[] byArray8 = new byte[this.SEED_SIZE];
        HQCKeccakRandomGenerator hQCKeccakRandomGenerator = new HQCKeccakRandomGenerator(256);
        hQCKeccakRandomGenerator.randomGeneratorInit(byArray6, null, byArray6.length, 0);
        hQCKeccakRandomGenerator.squeeze(byArray8, 40);
        byte[] byArray9 = new byte[this.SEED_SIZE];
        hQCKeccakRandomGenerator.squeeze(byArray9, 40);
        hQCKeccakRandomGenerator.squeeze(byArray7, this.K_BYTE);
        long[] lArray = new long[this.K_BYTE_64];
        Utils.fromByteArrayToLongArray(lArray, byArray7);
        byte[] byArray10 = new byte[this.SHA512_BYTES];
        HQCKeccakRandomGenerator hQCKeccakRandomGenerator2 = new HQCKeccakRandomGenerator(256);
        hQCKeccakRandomGenerator2.SHAKE256_512_ds(byArray10, byArray7, byArray7.length, new byte[]{this.G_FCT_DOMAIN});
        long[] lArray2 = new long[this.N_BYTE_64];
        byte[] byArray11 = new byte[this.N_BYTE];
        this.extractPublicKeys(lArray2, byArray11, byArray5);
        long[] lArray3 = new long[this.N_BYTE_64];
        long[] lArray4 = new long[this.N1N2_BYTE_64];
        this.encrypt(lArray3, lArray4, lArray2, byArray11, lArray, byArray10);
        Utils.fromLongArrayToByteArray(byArray2, lArray4, this.n1n2);
        Utils.fromLongArrayToByteArray(byArray, lArray3, this.n);
        hQCKeccakRandomGenerator2.SHAKE256_512_ds(byArray4, byArray7, byArray7.length, new byte[]{this.H_FCT_DOMAIN});
        byte[] byArray12 = new byte[this.K_BYTE + this.N_BYTE + this.N1N2_BYTE];
        byArray12 = Arrays.concatenate(byArray7, byArray);
        byArray12 = Arrays.concatenate(byArray12, byArray2);
        hQCKeccakRandomGenerator2.SHAKE256_512_ds(byArray3, byArray12, byArray12.length, new byte[]{this.K_FCT_DOMAIN});
    }

    public void decaps(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        byte[] byArray4 = new byte[this.n];
        byte[] byArray5 = new byte[40 + this.N_BYTE];
        this.extractKeysFromSecretKeys(byArray4, byArray5, byArray3);
        byte[] byArray6 = new byte[this.N_BYTE];
        byte[] byArray7 = new byte[this.N1N2_BYTE];
        byte[] byArray8 = new byte[this.SHA512_BYTES];
        this.extractCiphertexts(byArray6, byArray7, byArray8, byArray2);
        long[] lArray = new long[this.K_BYTE_64];
        this.decrypt(lArray, lArray, byArray6, byArray7, byArray4);
        byte[] byArray9 = new byte[this.k];
        Utils.fromLongArrayToByteArray(byArray9, lArray, this.k * 8);
        byte[] byArray10 = new byte[this.SHA512_BYTES];
        HQCKeccakRandomGenerator hQCKeccakRandomGenerator = new HQCKeccakRandomGenerator(256);
        hQCKeccakRandomGenerator.SHAKE256_512_ds(byArray10, byArray9, byArray9.length, new byte[]{this.G_FCT_DOMAIN});
        long[] lArray2 = new long[this.N_BYTE_64];
        byte[] byArray11 = new byte[this.N_BYTE];
        this.extractPublicKeys(lArray2, byArray11, byArray5);
        long[] lArray3 = new long[this.N_BYTE_64];
        long[] lArray4 = new long[this.N1N2_BYTE_64];
        this.encrypt(lArray3, lArray4, lArray2, byArray11, lArray, byArray10);
        byte[] byArray12 = new byte[this.N_BYTE];
        byte[] byArray13 = new byte[this.N1N2_BYTE];
        Utils.fromLongArrayToByteArray(byArray12, lArray3, this.n);
        Utils.fromLongArrayToByteArray(byArray13, lArray4, this.n1n2);
        byte[] byArray14 = new byte[this.SHA512_BYTES];
        hQCKeccakRandomGenerator.SHAKE256_512_ds(byArray14, byArray9, byArray9.length, new byte[]{this.H_FCT_DOMAIN});
        byte[] byArray15 = new byte[this.K_BYTE + this.N_BYTE + this.N1N2_BYTE];
        byArray15 = Arrays.concatenate(byArray9, byArray6);
        byArray15 = Arrays.concatenate(byArray15, byArray7);
        hQCKeccakRandomGenerator.SHAKE256_512_ds(byArray, byArray15, byArray15.length, new byte[]{this.K_FCT_DOMAIN});
        boolean bl = true;
        if (!Arrays.areEqual(byArray6, byArray12)) {
            bl = false;
        }
        if (!Arrays.areEqual(byArray7, byArray13)) {
            bl = false;
        }
        if (!Arrays.areEqual(byArray8, byArray14)) {
            bl = false;
        }
        if (!bl) {
            for (int i = 0; i < this.getSessionKeySize(); ++i) {
                byArray[i] = 0;
            }
        }
    }

    int getSessionKeySize() {
        return this.SHA512_BYTES;
    }

    private void encrypt(long[] lArray, long[] lArray2, long[] lArray3, byte[] byArray, long[] lArray4, byte[] byArray2) {
        HQCKeccakRandomGenerator hQCKeccakRandomGenerator = new HQCKeccakRandomGenerator(256);
        hQCKeccakRandomGenerator.seedExpanderInit(byArray2, this.SEED_SIZE);
        long[] lArray5 = new long[this.N_BYTE_64];
        long[] lArray6 = new long[this.N_BYTE_64];
        int[] nArray = new int[this.wr];
        this.generateSecretKey(lArray6, hQCKeccakRandomGenerator, this.wr);
        this.generateSecretKeyByCoordinates(nArray, hQCKeccakRandomGenerator, this.wr);
        this.generateSecretKey(lArray5, hQCKeccakRandomGenerator, this.we);
        byte[] byArray3 = new byte[this.n];
        Utils.fromLongArrayToBitArray(byArray3, lArray3);
        byte[] byArray4 = new byte[this.n];
        Utils.fromLongArrayToBitArray(byArray4, lArray6);
        byte[] byArray5 = new byte[this.n];
        byArray5 = Utils.fromListOfPos1ToBitArray(nArray, byArray5.length);
        byte[] byArray6 = new byte[this.n];
        Utils.fromLongArrayToBitArray(byArray6, lArray5);
        byte[] byArray7 = new byte[this.n];
        Utils.fromByteArrayToBitArray(byArray7, byArray);
        PolynomialGF2mSmallM polynomialGF2mSmallM = new PolynomialGF2mSmallM(this.field, Utils.removeLast0Bits(byArray4));
        PolynomialGF2mSmallM polynomialGF2mSmallM2 = new PolynomialGF2mSmallM(this.field, Utils.removeLast0Bits(byArray5));
        PolynomialGF2mSmallM polynomialGF2mSmallM3 = new PolynomialGF2mSmallM(this.field, Utils.removeLast0Bits(byArray3));
        PolynomialGF2mSmallM polynomialGF2mSmallM4 = polynomialGF2mSmallM.add(polynomialGF2mSmallM2.modKaratsubaMultiplyBigDeg(polynomialGF2mSmallM3, this.reductionPoly));
        Utils.fromBitArrayToLongArray(lArray, polynomialGF2mSmallM4.getEncoded());
        PolynomialGF2mSmallM polynomialGF2mSmallM5 = new PolynomialGF2mSmallM(this.field, Utils.removeLast0Bits(byArray7));
        PolynomialGF2mSmallM polynomialGF2mSmallM6 = new PolynomialGF2mSmallM(this.field, Utils.removeLast0Bits(byArray6));
        long[] lArray7 = new long[this.N1_BYTE_64];
        ReedSolomon.encode(lArray7, lArray4, this.K_BYTE * 8, this.n1, this.k, this.g, this.generatorPoly);
        ReedMuller.encode(lArray2, lArray7, this.n1, this.mulParam);
        byte[] byArray8 = new byte[this.n1n2];
        Utils.fromLongArrayToBitArray(byArray8, lArray2);
        PolynomialGF2mSmallM polynomialGF2mSmallM7 = new PolynomialGF2mSmallM(this.field, Utils.removeLast0Bits(byArray8));
        polynomialGF2mSmallM7 = polynomialGF2mSmallM7.add(polynomialGF2mSmallM5.modKaratsubaMultiplyBigDeg(polynomialGF2mSmallM2, this.reductionPoly));
        polynomialGF2mSmallM7 = polynomialGF2mSmallM7.add(polynomialGF2mSmallM6);
        long[] lArray8 = new long[this.N_BYTE_64];
        Utils.fromBitArrayToLongArray(lArray8, polynomialGF2mSmallM7.getEncoded());
        Utils.resizeArray(lArray2, this.n1n2, lArray8, this.n, this.N1N2_BYTE_64, this.N1N2_BYTE_64);
    }

    private void decrypt(long[] lArray, long[] lArray2, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        byte[] byArray4 = new byte[this.n];
        Utils.fromByteArrayToBitArray(byArray4, byArray);
        byte[] byArray5 = new byte[this.n1n2];
        Utils.fromByteArrayToBitArray(byArray5, byArray2);
        long[] lArray3 = new long[this.N_BYTE_64];
        Utils.fromBitArrayToLongArray(lArray3, byArray4);
        long[] lArray4 = new long[this.N1N2_BYTE_64];
        Utils.fromBitArrayToLongArray(lArray4, byArray5);
        PolynomialGF2mSmallM polynomialGF2mSmallM = new PolynomialGF2mSmallM(this.field, Utils.removeLast0Bits(byArray4));
        PolynomialGF2mSmallM polynomialGF2mSmallM2 = new PolynomialGF2mSmallM(this.field, Utils.removeLast0Bits(byArray5));
        PolynomialGF2mSmallM polynomialGF2mSmallM3 = new PolynomialGF2mSmallM(this.field, Utils.removeLast0Bits(byArray3));
        PolynomialGF2mSmallM polynomialGF2mSmallM4 = polynomialGF2mSmallM2.add(polynomialGF2mSmallM.modKaratsubaMultiplyBigDeg(polynomialGF2mSmallM3, this.reductionPoly));
        long[] lArray5 = new long[this.N_BYTE_64];
        Utils.fromBitArrayToLongArray(lArray5, polynomialGF2mSmallM4.getEncoded());
        long[] lArray6 = new long[this.N1_BYTE_64];
        ReedMuller.decode(lArray6, lArray5, this.n1, this.mulParam);
        ReedSolomon.decode(lArray2, lArray6, this.n1, this.fft, this.delta, this.k, this.g);
        System.arraycopy(lArray2, 0, lArray, 0, lArray.length);
    }

    private void generateSecretKey(long[] lArray, HQCKeccakRandomGenerator hQCKeccakRandomGenerator, int n) {
        int[] nArray = new int[n];
        this.generateSecretKeyByCoordinates(nArray, hQCKeccakRandomGenerator, n);
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i] / 64;
            int n3 = nArray[i] % 64;
            long l = 1L << n3;
            int n4 = n2;
            lArray[n4] = lArray[n4] | l;
        }
    }

    private void generateSecretKeyByCoordinates(int[] nArray, HQCKeccakRandomGenerator hQCKeccakRandomGenerator, int n) {
        int n2;
        int n3 = 3 * n;
        byte[] byArray = new byte[3 * this.wr];
        int n4 = n3;
        for (int i = 0; i < n; i += n2) {
            do {
                if (n4 == n3) {
                    hQCKeccakRandomGenerator.expandSeed(byArray, n3);
                    n4 = 0;
                }
                nArray[i] = (byArray[n4++] & 0xFF) << 16;
                int n5 = i;
                nArray[n5] = nArray[n5] | (byArray[n4++] & 0xFF) << 8;
                int n6 = i;
                nArray[n6] = nArray[n6] | byArray[n4++] & 0xFF;
            } while (nArray[i] >= this.rejectionThreshold);
            nArray[i] = nArray[i] % this.n;
            n2 = 1;
            for (int j = 0; j < i; ++j) {
                if (nArray[j] != nArray[i]) continue;
                n2 = 0;
            }
        }
    }

    void generatePublicKeyH(long[] lArray, HQCKeccakRandomGenerator hQCKeccakRandomGenerator) {
        byte[] byArray = new byte[this.N_BYTE];
        hQCKeccakRandomGenerator.expandSeed(byArray, this.N_BYTE);
        long[] lArray2 = new long[this.N_BYTE_64];
        Utils.fromByteArrayToLongArray(lArray2, byArray);
        int n = this.N_BYTE_64 - 1;
        lArray2[n] = lArray2[n] & Utils.bitMask(this.n, 64L);
        System.arraycopy(lArray2, 0, lArray, 0, lArray.length);
    }

    private void extractPublicKeys(long[] lArray, byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[this.SEED_SIZE];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray3.length);
        HQCKeccakRandomGenerator hQCKeccakRandomGenerator = new HQCKeccakRandomGenerator(256);
        hQCKeccakRandomGenerator.seedExpanderInit(byArray3, byArray3.length);
        long[] lArray2 = new long[this.N_BYTE_64];
        this.generatePublicKeyH(lArray2, hQCKeccakRandomGenerator);
        System.arraycopy(lArray2, 0, lArray, 0, lArray.length);
        System.arraycopy(byArray2, 40, byArray, 0, byArray.length);
    }

    private void extractKeysFromSecretKeys(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        byte[] byArray4 = new byte[this.SEED_SIZE];
        System.arraycopy(byArray3, 0, byArray4, 0, byArray4.length);
        HQCKeccakRandomGenerator hQCKeccakRandomGenerator = new HQCKeccakRandomGenerator(256);
        hQCKeccakRandomGenerator.seedExpanderInit(byArray4, byArray4.length);
        long[] lArray = new long[this.N_BYTE_64];
        int[] nArray = new int[this.w];
        this.generateSecretKey(lArray, hQCKeccakRandomGenerator, this.w);
        this.generateSecretKeyByCoordinates(nArray, hQCKeccakRandomGenerator, this.w);
        byte[] byArray5 = Utils.fromListOfPos1ToBitArray(nArray, this.n);
        System.arraycopy(byArray5, 0, byArray, 0, byArray.length);
        System.arraycopy(byArray3, this.SEED_SIZE, byArray2, 0, byArray2.length);
    }

    private void extractCiphertexts(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        System.arraycopy(byArray4, 0, byArray, 0, byArray.length);
        System.arraycopy(byArray4, byArray.length, byArray2, 0, byArray2.length);
        System.arraycopy(byArray4, byArray.length + byArray2.length, byArray3, 0, byArray3.length);
    }
}

