/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.p2.core;

import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.p2.metadata.expression.LDAPFilter;
import org.eclipse.equinox.p2.core.IAgentLocation;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitFragment;
import org.eclipse.equinox.p2.metadata.IInstallableUnitPatch;
import org.eclipse.equinox.p2.metadata.ILicense;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.IRequirementChange;
import org.eclipse.equinox.p2.metadata.ITouchpointData;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.expression.ExpressionUtil;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.metadata.expression.IFilterExpression;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.repository.IRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.oomph.p2.core.Agent;
import org.eclipse.oomph.p2.core.AgentManager;
import org.eclipse.oomph.p2.internal.core.AgentImpl;
import org.eclipse.oomph.p2.internal.core.AgentManagerImpl;
import org.eclipse.oomph.p2.internal.core.CachingRepositoryManager;
import org.eclipse.oomph.p2.internal.core.CachingTransport;
import org.eclipse.oomph.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class P2Util {
    private static final Pattern OSGI_PROPERTY_FILTER = Pattern.compile("(!?)\\((osgi.arch|osgi.os|osgi.ws)=([^)]+)\\)");

    private P2Util() {
    }

    public static synchronized AgentManager getAgentManager() {
        if (AgentManagerImpl.instance == null) {
            AgentManagerImpl.instance = new AgentManagerImpl();
        }
        return AgentManagerImpl.instance;
    }

    public static File getAgentLocation(IProvisioningAgent agent) {
        IAgentLocation location = (IAgentLocation)agent.getService(IAgentLocation.SERVICE_NAME);
        return URIUtil.toFile((URI)location.getRootLocation());
    }

    public static IProvisioningAgent getCurrentProvisioningAgent() {
        return P2Util.getAgentManager().getCurrentAgent().getProvisioningAgent();
    }

    public static Agent createAgent(File agentLocation) {
        return new AgentImpl((AgentManagerImpl)P2Util.getAgentManager(), agentLocation);
    }

    public static Set<String> getKnownRepositories(IRepositoryManager<?> manager) {
        HashSet<String> result = new HashSet<String>();
        URI[] uRIArray = manager.getKnownRepositories(2);
        int n = uRIArray.length;
        int n2 = 0;
        while (n2 < n) {
            URI uri = uRIArray[n2];
            result.add(uri.toString());
            ++n2;
        }
        return result;
    }

    public static File getCacheFile(URI uri) {
        CachingTransport transport;
        Agent agent = P2Util.getAgentManager().getCurrentAgent();
        IMetadataRepositoryManager manager = agent.getMetadataRepositoryManager();
        if (manager instanceof CachingRepositoryManager && (transport = ((CachingRepositoryManager)manager).getTransport()) != null) {
            return transport.getCacheFile(uri);
        }
        return null;
    }

    public static <T> Iterable<T> asIterable(final IQueryResult<T> queryResult) {
        if (queryResult instanceof Iterable) {
            return (Iterable)Iterable.class.cast(queryResult);
        }
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return queryResult.iterator();
            }
        };
    }

    public static boolean isSimpleRequiredCapability(IRequirement requirement) {
        return requirement instanceof IRequiredCapability;
    }

    public static Runnable preserveBundlePoolTimestamps(File bundlePoolLocation) {
        final File featuresFolder = new File(bundlePoolLocation, "features");
        final long featuresFolderLastModified = featuresFolder.lastModified();
        final File pluginsFolder = new File(bundlePoolLocation, "plugins");
        final long pluginsFolderLastModified = pluginsFolder.lastModified();
        return new Runnable(){

            public void run() {
                if (featuresFolderLastModified != 0L) {
                    featuresFolder.setLastModified(featuresFolderLastModified);
                }
                if (pluginsFolderLastModified != 0L) {
                    pluginsFolder.setLastModified(pluginsFolderLastModified);
                }
            }
        };
    }

    public static String getName(IInstallableUnit iu) {
        String name = iu.getProperty("org.eclipse.equinox.p2.name", null);
        if (StringUtil.isEmpty((String)name)) {
            return iu.getId();
        }
        return name;
    }

    public static Map<String, String> toProfilePropertiesMap(String profileProperties) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        if (!StringUtil.isEmpty((String)profileProperties)) {
            String[] properties;
            String[] stringArray = properties = profileProperties.split(",");
            int n = properties.length;
            int n2 = 0;
            while (n2 < n) {
                String property = stringArray[n2];
                int index = property.indexOf(61);
                if (index == -1) {
                    result.put(property, null);
                } else {
                    result.put(property.substring(0, index), property.substring(index + 1));
                }
                ++n2;
            }
        }
        return result;
    }

    public static String toProfilePropertiesString(Map<String, String> profileProperties) {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, String> entry : profileProperties.entrySet()) {
            if (result.length() != 0) {
                result.append(",");
            }
            String key = entry.getKey();
            result.append(key);
            String value = entry.getValue();
            if (value == null) continue;
            result.append(' ').append(value);
        }
        return result.toString();
    }

    public static IInstallableUnit createGeneralizedIU(IInstallableUnit iu, boolean isIncludeAllPlatforms, boolean isIncludeAllRequirements, boolean isIncludeNegativeRequirements) {
        MetadataFactory.InstallableUnitDescription description;
        if (!isIncludeAllPlatforms && isIncludeAllRequirements && isIncludeNegativeRequirements) {
            return iu;
        }
        IMatchExpression<IInstallableUnit> filter = iu.getFilter();
        IMatchExpression<IInstallableUnit> generalizedFilter = isIncludeAllPlatforms ? P2Util.generalize(filter) : filter;
        boolean needsGeneralization = filter != generalizedFilter;
        Collection requirements = iu.getRequirements();
        IRequirement[] generalizedRequirements = requirements.toArray(new IRequirement[requirements.size()]);
        int i = 0;
        while (i < generalizedRequirements.length) {
            IRequirement requirement = generalizedRequirements[i];
            IMatchExpression<IInstallableUnit> requirementFilter = requirement.getFilter();
            IMatchExpression<IInstallableUnit> generalizedRequirementFilter = isIncludeAllPlatforms ? P2Util.generalize(requirementFilter) : requirementFilter;
            int max = requirement.getMax();
            int min = requirement.getMin();
            if (requirementFilter != generalizedRequirementFilter || !isIncludeAllRequirements && min != 0 || !isIncludeNegativeRequirements && max == 0) {
                IRequirement generalizedRequirement;
                needsGeneralization = true;
                generalizedRequirements[i] = generalizedRequirement = MetadataFactory.createRequirement((IMatchExpression)requirement.getMatches(), generalizedRequirementFilter, (int)(requirementFilter != generalizedRequirementFilter || !isIncludeAllRequirements ? 0 : min), (int)(!isIncludeNegativeRequirements && max == 0 ? Integer.MAX_VALUE : max), (boolean)true, (String)requirement.getDescription());
            }
            ++i;
        }
        if (!needsGeneralization) {
            return iu;
        }
        if (iu instanceof IInstallableUnitFragment) {
            IInstallableUnitFragment installableUnitFragment = (IInstallableUnitFragment)iu;
            MetadataFactory.InstallableUnitFragmentDescription fragmentDescription = new MetadataFactory.InstallableUnitFragmentDescription();
            Collection host = installableUnitFragment.getHost();
            fragmentDescription.setHost(host.toArray(new IRequirement[host.size()]));
            description = fragmentDescription;
        } else if (iu instanceof IInstallableUnitPatch) {
            IInstallableUnitPatch installableUnitPatch = (IInstallableUnitPatch)iu;
            MetadataFactory.InstallableUnitPatchDescription patchDescription = new MetadataFactory.InstallableUnitPatchDescription();
            patchDescription.setApplicabilityScope(installableUnitPatch.getApplicabilityScope());
            patchDescription.setLifeCycle(installableUnitPatch.getLifeCycle());
            List requirementsChange = installableUnitPatch.getRequirementsChange();
            patchDescription.setRequirementChanges(requirementsChange.toArray(new IRequirementChange[requirementsChange.size()]));
            description = patchDescription;
        } else {
            description = new MetadataFactory.InstallableUnitDescription();
        }
        description.setId(iu.getId());
        description.setVersion(iu.getVersion());
        Collection artifacts = iu.getArtifacts();
        description.setArtifacts(artifacts.toArray(new IArtifactKey[artifacts.size()]));
        Collection providedCapabilities = iu.getProvidedCapabilities();
        description.setCapabilities(providedCapabilities.toArray(new IProvidedCapability[providedCapabilities.size()]));
        description.setCopyright(iu.getCopyright());
        description.setFilter(generalizedFilter);
        Collection licenses = iu.getLicenses();
        description.setLicenses(licenses.toArray(new ILicense[licenses.size()]));
        Collection metaRequirements = iu.getMetaRequirements();
        description.setMetaRequirements(metaRequirements.toArray(new IRequirement[metaRequirements.size()]));
        description.setRequirements(generalizedRequirements);
        description.setSingleton(iu.isSingleton());
        description.setTouchpointType(iu.getTouchpointType());
        description.setUpdateDescriptor(iu.getUpdateDescriptor());
        for (Map.Entry entry : iu.getProperties().entrySet()) {
            description.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        for (ITouchpointData touchpointData : iu.getTouchpointData()) {
            description.addTouchpointData(touchpointData);
        }
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)description);
    }

    private static IMatchExpression<IInstallableUnit> generalize(IMatchExpression<IInstallableUnit> filter) {
        if (filter == null) {
            return null;
        }
        Object[] generalizedParameters = null;
        Object[] parameters = filter.getParameters();
        int i = 0;
        while (i < parameters.length) {
            String value;
            Matcher matcher;
            Object parameter = parameters[i];
            if (parameter instanceof LDAPFilter && (matcher = OSGI_PROPERTY_FILTER.matcher(value = parameter.toString())).find()) {
                if (generalizedParameters == null) {
                    generalizedParameters = new Object[parameters.length];
                    System.arraycopy(parameters, 0, generalizedParameters, 0, parameters.length);
                }
                StringBuffer result = new StringBuffer();
                if (matcher.group(1).length() == 0) {
                    matcher.appendReplacement(result, "($2=*)");
                } else {
                    matcher.appendReplacement(result, "!($2=nothing)");
                }
                while (matcher.find()) {
                    if (matcher.group(1).length() == 0) {
                        matcher.appendReplacement(result, "($2=*)");
                        continue;
                    }
                    matcher.appendReplacement(result, "!($2=nothing)");
                }
                matcher.appendTail(result);
                IFilterExpression ldap = ExpressionUtil.parseLDAP((String)result.toString());
                generalizedParameters[i] = ldap;
            }
            ++i;
        }
        if (generalizedParameters != null) {
            IExpression expression = ExpressionUtil.parse((String)filter.toString());
            return ExpressionUtil.getFactory().matchExpression(expression, generalizedParameters);
        }
        return filter;
    }

    private static MetadataFactory.InstallableUnitDescription createDescription(IInstallableUnit iu) {
        MetadataFactory.InstallableUnitDescription description = new MetadataFactory.InstallableUnitDescription();
        description.setId(iu.getId());
        description.setVersion(iu.getVersion());
        Collection artifacts = iu.getArtifacts();
        description.setArtifacts(artifacts.toArray(new IArtifactKey[artifacts.size()]));
        Collection providedCapabilities = iu.getProvidedCapabilities();
        description.setCapabilities(providedCapabilities.toArray(new IProvidedCapability[providedCapabilities.size()]));
        description.setCopyright(iu.getCopyright());
        IMatchExpression filter = iu.getFilter();
        description.setFilter(filter);
        Collection licenses = iu.getLicenses();
        description.setLicenses(licenses.toArray(new ILicense[licenses.size()]));
        Collection metaRequirements = iu.getMetaRequirements();
        description.setMetaRequirements(metaRequirements.toArray(new IRequirement[metaRequirements.size()]));
        Collection requirements = iu.getRequirements();
        description.setRequirements(requirements.toArray(new IRequirement[requirements.size()]));
        description.setSingleton(iu.isSingleton());
        description.setTouchpointType(iu.getTouchpointType());
        description.setUpdateDescriptor(iu.getUpdateDescriptor());
        for (Map.Entry entry : iu.getProperties().entrySet()) {
            description.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        for (ITouchpointData touchpointData : iu.getTouchpointData()) {
            description.addTouchpointData(touchpointData);
        }
        return description;
    }

    public static interface VersionedIdFilter {
        public boolean matches(IVersionedId var1);
    }
}

