/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.oomph.setup.SetupTaskContext;
import org.eclipse.oomph.setup.Trigger;
import org.eclipse.oomph.setup.util.StringExpander;
import org.eclipse.oomph.util.PropertiesUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SetupUtil {
    private static final String DEFAULT_INSTALLER_UPDATE_URL = "http://download.eclipse.org/oomph/products/repository";
    private static final String RESOLVING_TARGET_PLATFORM_DEFINITIONS = "oomph.setup.resolving.target.platform.definitions";
    private static final Map<EClass, Set<Trigger>> TRIGGERS = Collections.synchronizedMap(new HashMap());
    private static final StringExpander UNESCAPE_STRING_EXPANDER = new StringExpander(){

        protected String resolve(String key) {
            return CONTROL_CHARACTER_VALUES.containsKey(key) ? (String)CONTROL_CHARACTER_VALUES.get(key) : key;
        }

        protected boolean isUnexpanded(String key) {
            return !CONTROL_CHARACTER_VALUES.containsKey(key);
        }

        protected String filter(String value, String filterName) {
            return value;
        }
    };
    public static final String INSTALLER_UPDATE_URL = PropertiesUtil.getProperty((String)"oomph.installer.update.url", (String)"http://download.eclipse.org/oomph/products/repository").replace('\\', '/');
    public static final boolean INSTALLER_APPLICATION = "org.eclipse.oomph.setup.installer.application".equals(PropertiesUtil.getApplicationID());
    public static final boolean SETUP_ARCHIVER_APPLICATION = "org.eclipse.oomph.setup.core.SetupArchiver".equals(PropertiesUtil.getApplicationID());

    private SetupUtil() {
    }

    public static String escape(String string) {
        if (string == null) {
            return null;
        }
        Matcher matcher = StringExpander.STRING_EXPANSION_PATTERN.matcher(string);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String group1 = matcher.group(1);
            if ("$".equals(group1)) {
                matcher.appendReplacement(result, "\\$\\$\\$\\$");
                continue;
            }
            matcher.appendReplacement(result, "\\$$0");
        }
        matcher.appendTail(result);
        int i = 0;
        int length = result.length();
        while (i < length) {
            char c = result.charAt(i);
            if (c < StringExpander.CONTROL_CHARACTER_REPLACEMENTS.length && c != '\n' && c != '\r' && c != '\t') {
                String replacement = StringExpander.CONTROL_CHARACTER_REPLACEMENTS[c];
                result.replace(i, i + 1, replacement);
                length += replacement.length() - 1;
            }
            ++i;
        }
        return result.toString();
    }

    public static String unescape(String string) {
        return UNESCAPE_STRING_EXPANDER.expandString(string);
    }

    public static Set<String> getResolvingTargetDefinitions(SetupTaskContext context) {
        LinkedHashSet targetDefinitions = (LinkedHashSet)context.get(RESOLVING_TARGET_PLATFORM_DEFINITIONS);
        if (targetDefinitions == null) {
            targetDefinitions = new LinkedHashSet();
            context.put(RESOLVING_TARGET_PLATFORM_DEFINITIONS, targetDefinitions);
        }
        return targetDefinitions;
    }

    public static Set<Trigger> getTriggers(EClass eClass) {
        Set<Trigger> result = TRIGGERS.get(eClass);
        if (result == null) {
            String triggers = EcoreUtil.getAnnotation((EModelElement)eClass, (String)"http://www.eclipse.org/oomph/setup/ValidTriggers", (String)"triggers");
            if (triggers != null) {
                String[] triggerValueLiterals = triggers.split("\\s");
                Trigger[] triggerValues = new Trigger[triggerValueLiterals.length];
                int i = 0;
                while (i < triggerValueLiterals.length) {
                    triggerValues[i] = Trigger.get(triggerValueLiterals[i]);
                    ++i;
                }
                result = Trigger.toSet(triggerValues);
            } else {
                result = Trigger.ALL_TRIGGERS;
            }
            TRIGGERS.put(eClass, result);
        }
        return result;
    }
}

