/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.ui;

import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class SpriteAnimator
extends Canvas
implements Runnable,
PaintListener {
    private static final int NONE = -1;
    private final Image[] images;
    private final int width;
    private final int height;
    private long delay;
    private int firstIndex = -1;
    private int lastIndex = -1;
    private int index = -1;
    private boolean running;

    public SpriteAnimator(Composite parent, int style, Image textureAtlas, int countX, int countY, long delay) {
        super(parent, style);
        this.delay = delay;
        this.images = UIUtil.extractSprites(textureAtlas, countX, countY);
        Rectangle spriteBounds = this.images[0].getBounds();
        this.width = spriteBounds.width;
        this.height = spriteBounds.height;
        this.addPaintListener(this);
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final void setDelay(long delay) {
        this.delay = delay;
    }

    public final long getDelay() {
        return this.delay;
    }

    public final Image[] getImages() {
        return this.images;
    }

    public final void start() {
        this.start(0, this.images.length - 1);
    }

    public final synchronized void start(int firstIndex, int lastIndex) {
        if (this.running && this.firstIndex == firstIndex && this.lastIndex == lastIndex) {
            return;
        }
        this.firstIndex = firstIndex;
        this.lastIndex = lastIndex;
        this.index = firstIndex;
        this.running = true;
        this.getDisplay().asyncExec((Runnable)this);
    }

    public final synchronized void stop() {
        this.running = false;
        this.getDisplay().asyncExec(new Runnable(){

            public void run() {
                block3: {
                    try {
                        if (!SpriteAnimator.this.isDisposed()) {
                            SpriteAnimator.this.redraw();
                        }
                    }
                    catch (SWTException ex) {
                        if (SpriteAnimator.this.isDisposed()) break block3;
                        throw ex;
                    }
                }
            }
        });
    }

    public final synchronized void run() {
        block4: {
            try {
                if (this.running && !this.isDisposed()) {
                    this.redraw();
                    if (++this.index > this.lastIndex) {
                        this.index = this.firstIndex;
                    }
                    this.getDisplay().timerExec((int)this.delay, (Runnable)this);
                }
            }
            catch (SWTException ex) {
                if (this.isDisposed()) break block4;
                throw ex;
            }
        }
    }

    public final void paintControl(PaintEvent e) {
        int index = this.index;
        if (index != -1) {
            Rectangle clientArea = this.getClientArea();
            int x = (clientArea.width - this.width) / 2;
            int y = (clientArea.height - this.height) / 2;
            GC gc = e.gc;
            gc.drawImage(this.images[index], x, y);
        }
    }

    public void dispose() {
        Image[] imageArray = this.images;
        int n = this.images.length;
        int n2 = 0;
        while (n2 < n) {
            Image image = imageArray[n2];
            image.dispose();
            ++n2;
        }
        super.dispose();
    }
}

