/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.predicates.provider;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.oomph.base.provider.ModelElementItemProvider;
import org.eclipse.oomph.predicates.NamePredicate;
import org.eclipse.oomph.predicates.PredicatesPackage;
import org.eclipse.oomph.predicates.provider.Messages;
import org.eclipse.oomph.predicates.provider.PredicateItemProvider;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamePredicateItemProvider
extends PredicateItemProvider {
    public NamePredicateItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addPatternPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addPatternPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_NamePredicate_pattern_feature"), this.getString("_UI_NamePredicate_pattern_description"), (EStructuralFeature)PredicatesPackage.Literals.NAME_PREDICATE__PATTERN, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/NamePredicate"));
    }

    @Override
    protected boolean shouldComposeCreationImage() {
        return true;
    }

    @Override
    public String getText(Object object) {
        String label = ((NamePredicate)object).getPattern();
        return label == null || label.length() == 0 ? this.getString("_UI_NamePredicate_type") : NLS.bind((String)Messages.NamePredicateItemProvider_NameMatches_label, (Object)label);
    }

    @Override
    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(NamePredicate.class)) {
            case 1: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected Command createPrimaryDragAndDropCommand(EditingDomain domain, Object owner, float location, int operations, int operation, Collection<?> collection) {
        return new ModelElementItemProvider.BaseDragAndDropCommand(domain, owner, location, operations, operation, collection){

            protected boolean analyzeForNonContainment(Command command) {
                return true;
            }
        };
    }

    protected Command createSetCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Object value) {
        if (feature == null && value instanceof Collection) {
            NamePredicate namePredicate = (NamePredicate)owner;
            String pattern = namePredicate.getPattern();
            StringBuilder projectPattern = new StringBuilder();
            if (pattern != null) {
                projectPattern.append(pattern);
            }
            boolean hasNonProject = false;
            for (Object item : (Collection)value) {
                if (item instanceof IProject) {
                    IProject project = (IProject)item;
                    String name = project.getName();
                    if (projectPattern.length() != 0) {
                        projectPattern.append('|');
                    }
                    projectPattern.append(name.replaceAll("\\.", "\\\\."));
                    continue;
                }
                hasNonProject = true;
                break;
            }
            if (!hasNonProject) {
                return new SetCommand(domain, owner, (EStructuralFeature)PredicatesPackage.Literals.NAME_PREDICATE__PATTERN, (Object)projectPattern.toString());
            }
        }
        return super.createSetCommand(domain, owner, feature, value);
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }
}

