/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.targlets.internal.ui.wizards;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.oomph.targlets.internal.ui.TargletsUIPlugin;
import org.eclipse.oomph.targlets.internal.ui.wizards.Messages;
import org.eclipse.oomph.targlets.internal.ui.wizards.TargetDefinitionExportWizard;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.pde.TargetPlatformUtil;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetHandle;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class TargetDefinitionExportWizardPage
extends WizardPage {
    private TableViewer targetDefinitionViewer;
    private ITargetDefinition targetDefinition;
    private ITargetHandle activeTargetHandle;
    private Text exportFolderText;
    private File exportFolder;

    public TargetDefinitionExportWizardPage() {
        super("page");
    }

    public ITargetDefinition getTargetDefinition() {
        return this.targetDefinition;
    }

    public File getExportFolder() {
        return this.exportFolder;
    }

    public void createControl(Composite parent) {
        this.setTitle(TargetDefinitionExportWizard.TITLE);
        this.setMessage(Messages.TargetDefinitionExportWizardPage_defaultMessage);
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(1, false));
        Label targetPlatformLabel = new Label(container, 0);
        targetPlatformLabel.setText(Messages.TargetDefinitionExportWizardPage_targetPlatform);
        this.targetDefinitionViewer = new TableViewer(container, 2560);
        this.targetDefinitionViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        this.targetDefinitionViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.targetDefinitionViewer.setLabelProvider((IBaseLabelProvider)new TargetLabelProvider());
        this.targetDefinitionViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TargetDefinitionExportWizardPage.this.validatePage();
            }
        });
        Label exportFolderLabel = new Label(container, 0);
        exportFolderLabel.setText(Messages.TargetDefinitionExportWizardPage_exportFolder);
        GridLayout compositeGridLayout = new GridLayout(2, false);
        compositeGridLayout.marginHeight = 0;
        compositeGridLayout.marginWidth = 0;
        Composite composite = new Composite(container, 0);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        composite.setLayout((Layout)compositeGridLayout);
        this.exportFolderText = new Text(composite, 2048);
        this.exportFolderText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.exportFolderText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TargetDefinitionExportWizardPage.this.validatePage();
            }
        });
        Button browseButton = new Button(composite, 0);
        browseButton.setText(Messages.TargetDefinitionExportWizardPage_browseButton_text);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String dir;
                DirectoryDialog dialog = new DirectoryDialog(TargetDefinitionExportWizardPage.this.getShell());
                dialog.setText(Messages.TargetDefinitionExportWizardPage_exportFolderDialog_text);
                dialog.setMessage(Messages.TargetDefinitionExportWizardPage_exportFolderDialog_message);
                String value = TargetDefinitionExportWizardPage.this.exportFolderText.getText();
                if (value.length() != 0) {
                    try {
                        File existingFolder = IOUtil.getExistingFolder((File)new File(value));
                        if (existingFolder != null) {
                            dialog.setFilterPath(existingFolder.getAbsolutePath());
                        }
                    }
                    catch (Exception ex) {
                        TargletsUIPlugin.INSTANCE.log(ex, 2);
                    }
                }
                if ((dir = dialog.open()) != null) {
                    TargetDefinitionExportWizardPage.this.exportFolderText.setText(dir);
                    TargetDefinitionExportWizardPage.this.validatePage();
                }
            }
        });
        this.setPageComplete(false);
        new Job(Messages.TargetDefinitionExportWizardPage_determineTargetsJob_name){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    final ITargetDefinition[] targetDefinitions = TargetPlatformUtil.getTargetDefinitions((IProgressMonitor)monitor);
                    if (targetDefinitions.length != 0) {
                        ITargetDefinition defaultTargetDefinition;
                        ITargetDefinition activeTargetDefinition = TargetPlatformUtil.getActiveTargetDefinition();
                        if (activeTargetDefinition != null) {
                            TargetDefinitionExportWizardPage.this.activeTargetHandle = activeTargetDefinition.getHandle();
                            boolean found = false;
                            ITargetDefinition[] iTargetDefinitionArray = targetDefinitions;
                            int n = targetDefinitions.length;
                            int n2 = 0;
                            while (n2 < n) {
                                ITargetDefinition targetDefinition = iTargetDefinitionArray[n2];
                                if (targetDefinition.getHandle().equals(TargetDefinitionExportWizardPage.this.activeTargetHandle)) {
                                    activeTargetDefinition = targetDefinition;
                                    found = true;
                                    break;
                                }
                                ++n2;
                            }
                            if (!found) {
                                activeTargetDefinition = null;
                            }
                        }
                        UIUtil.syncExec((Control)TargetDefinitionExportWizardPage.this.getShell(), (Runnable)new Runnable(){

                            public void run() {
                                TargetDefinitionExportWizardPage.this.targetDefinitionViewer.setInput((Object)targetDefinitions);
                            }
                        });
                        ITargetDefinition iTargetDefinition = defaultTargetDefinition = activeTargetDefinition != null ? activeTargetDefinition : targetDefinitions[0];
                        if (defaultTargetDefinition != null) {
                            UIUtil.syncExec((Control)TargetDefinitionExportWizardPage.this.getShell(), (Runnable)new Runnable(){

                                public void run() {
                                    TargetDefinitionExportWizardPage.this.targetDefinitionViewer.setSelection((ISelection)new StructuredSelection((Object)defaultTargetDefinition));
                                }
                            });
                        }
                    }
                }
                catch (Exception ex) {
                    UIUtil.syncExec((Control)TargetDefinitionExportWizardPage.this.getShell(), (Runnable)new Runnable(){

                        public void run() {
                            TargetDefinitionExportWizardPage.this.setErrorMessage(ex.getMessage());
                        }
                    });
                    return TargletsUIPlugin.INSTANCE.getStatus(ex);
                }
                UIUtil.syncExec((Control)TargetDefinitionExportWizardPage.this.getShell(), (Runnable)new Runnable(){

                    public void run() {
                        TargetDefinitionExportWizardPage.this.validatePage();
                    }
                });
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    protected void validatePage() {
        IStructuredSelection selection = (IStructuredSelection)this.targetDefinitionViewer.getSelection();
        this.targetDefinition = (ITargetDefinition)selection.getFirstElement();
        if (this.targetDefinition == null) {
            this.setMessage(Messages.TargetDefinitionExportWizardPage_selectTargetToExport);
            this.setPageComplete(false);
            return;
        }
        String path = this.exportFolderText.getText();
        if (path.length() == 0) {
            this.setMessage(Messages.TargetDefinitionExportWizardPage_enterFolderToExportTo);
            this.setPageComplete(false);
            return;
        }
        try {
            this.exportFolder = new File(path);
        }
        catch (Exception ex) {
            this.setErrorMessage(ex.getMessage());
            this.setPageComplete(false);
            return;
        }
        this.setMessage(Messages.TargetDefinitionExportWizardPage_defaultMessage);
        this.setPageComplete(true);
    }

    private final class TargetLabelProvider
    extends LabelProvider
    implements IFontProvider {
        private final Font baseFont;

        private TargetLabelProvider() {
            this.baseFont = TargetDefinitionExportWizardPage.this.targetDefinitionViewer.getControl().getFont();
        }

        public Image getImage(Object element) {
            if (element instanceof ITargetDefinition) {
                return TargletsUIPlugin.INSTANCE.getSWTImage("target_obj");
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof ITargetDefinition) {
                ITargetDefinition targetDefinition = (ITargetDefinition)element;
                String text = targetDefinition.getName();
                if (targetDefinition.getHandle().equals(TargetDefinitionExportWizardPage.this.activeTargetHandle)) {
                    text = String.valueOf(text) + ' ' + Messages.TargetDefinitionExportWizardPage_active;
                }
                return text;
            }
            return "";
        }

        public Font getFont(Object element) {
            ITargetDefinition targetDefinition;
            if (element instanceof ITargetDefinition && (targetDefinition = (ITargetDefinition)element).getHandle().equals(TargetDefinitionExportWizardPage.this.activeTargetHandle)) {
                return TargletsUIPlugin.getBoldFont((Font)this.baseFont);
            }
            return null;
        }
    }
}

