/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.p2.internal.ui;

import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.dialogs.TrustCertificateDialog;
import org.eclipse.equinox.internal.p2.ui.dialogs.UserValidationDialog;
import org.eclipse.equinox.internal.p2.ui.viewers.CertificateLabelProvider;
import org.eclipse.equinox.p2.core.UIServices;
import org.eclipse.equinox.p2.ui.LoadMetadataRepositoryJob;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.jface.viewers.TreeNodeContentProvider;
import org.eclipse.oomph.p2.core.CertificateConfirmer;
import org.eclipse.oomph.p2.core.DelegatingUIServices;
import org.eclipse.oomph.p2.internal.ui.Messages;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class P2ServiceUI
extends DelegatingUIServices {
    public UIServices.AuthenticationInfo getUsernamePassword(final String location) {
        UIServices delegate = this.getDelegate();
        if (delegate != null) {
            return delegate.getUsernamePassword(location);
        }
        final UIServices.AuthenticationInfo[] result = new UIServices.AuthenticationInfo[1];
        if (!this.suppressAuthentication()) {
            UIUtil.getDisplay().syncExec(new Runnable(){

                public void run() {
                    String message = NLS.bind((String)ProvUIMessages.ServiceUI_LoginDetails, (Object)location);
                    UserValidationDialog dialog = new UserValidationDialog(P2ServiceUI.this.getShell(), ProvUIMessages.ServiceUI_LoginRequired, null, message);
                    int dialogCode = dialog.open();
                    if (dialogCode == 0) {
                        result[0] = dialog.getResult();
                    } else if (dialogCode == 1) {
                        result[0] = AUTHENTICATION_PROMPT_CANCELED;
                    }
                }
            });
        }
        return result[0];
    }

    public UIServices.AuthenticationInfo getUsernamePassword(final String location, final UIServices.AuthenticationInfo previousInfo) {
        Shell shell;
        UIServices delegate = this.getDelegate();
        if (delegate != null) {
            delegate.getUsernamePassword(location);
        }
        final UIServices.AuthenticationInfo[] result = new UIServices.AuthenticationInfo[1];
        if (!this.suppressAuthentication() && (shell = this.getShell()) != null) {
            UIUtil.getDisplay().syncExec(new Runnable(){

                public void run() {
                    String message = null;
                    message = previousInfo.saveResult() ? NLS.bind((String)ProvUIMessages.ProvUIMessages_SavedNotAccepted_EnterFor_0, (Object)location) : NLS.bind((String)ProvUIMessages.ProvUIMessages_NotAccepted_EnterFor_0, (Object)location);
                    UserValidationDialog dialog = new UserValidationDialog(previousInfo, shell, ProvUIMessages.ServiceUI_LoginRequired, null, message);
                    int dialogCode = dialog.open();
                    if (dialogCode == 0) {
                        result[0] = dialog.getResult();
                    } else if (dialogCode == 1) {
                        result[0] = AUTHENTICATION_PROMPT_CANCELED;
                    }
                }
            });
        }
        return result[0];
    }

    private boolean suppressAuthentication() {
        Job job = Job.getJobManager().currentJob();
        if (job != null) {
            return job.getProperty(LoadMetadataRepositoryJob.SUPPRESS_AUTHENTICATION_JOB_MARKER) != null;
        }
        return false;
    }

    public UIServices.TrustInfo getTrustInfo(Certificate[][] untrustedChains, final String[] unsignedDetail) {
        boolean trustUnsigned = true;
        boolean persistTrust = false;
        Certificate[] trusted = new Certificate[]{};
        final Shell shell = this.getShell();
        if (shell != null && unsignedDetail != null && unsignedDetail.length > 0) {
            final boolean[] result = new boolean[1];
            shell.getDisplay().syncExec(new Runnable(){

                public void run() {
                    OkCancelErrorDialog dialog = new OkCancelErrorDialog(shell, ProvUIMessages.ServiceUI_warning_title, null, this.createStatus(), 2);
                    result[0] = dialog.open() == 0;
                }

                private IStatus createStatus() {
                    MultiStatus parent = new MultiStatus("org.eclipse.equinox.p2.ui", 0, ProvUIMessages.ServiceUI_unsigned_message, null);
                    int i = 0;
                    while (i < unsignedDetail.length) {
                        parent.add((IStatus)new Status(2, "org.eclipse.equinox.p2.ui", unsignedDetail[i]));
                        ++i;
                    }
                    return parent;
                }
            });
            trustUnsigned = result[0];
        }
        if (!trustUnsigned) {
            return new UIServices.TrustInfo(trusted, persistTrust, trustUnsigned);
        }
        final AtomicBoolean remember = new AtomicBoolean();
        final AtomicBoolean always = new AtomicBoolean();
        if (shell != null && untrustedChains != null && untrustedChains.length > 0) {
            final Object[] result = new Object[1];
            final TreeNode[] input = this.createTreeNodes(untrustedChains);
            UIUtil.getDisplay().syncExec(new Runnable(){

                public void run() {
                    CertificateLabelProvider labelProvider = new CertificateLabelProvider();
                    TreeNodeContentProvider contentProvider = new TreeNodeContentProvider();
                    TrustCertificateDialog trustCertificateDialog = new TrustCertificateDialog(shell, input, (ILabelProvider)labelProvider, (ITreeContentProvider)contentProvider){

                        protected void configureShell(Shell shell) {
                            Layout layout;
                            Image[] defaultImages = 1.getDefaultImages();
                            if (defaultImages.length > 0) {
                                ArrayList<Image> nonDisposedImages = new ArrayList<Image>(defaultImages.length);
                                Image[] imageArray = defaultImages;
                                int n = defaultImages.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    Image defaultImage = imageArray[n2];
                                    if (defaultImage != null && !defaultImage.isDisposed()) {
                                        nonDisposedImages.add(defaultImage);
                                    }
                                    ++n2;
                                }
                                if (!nonDisposedImages.isEmpty()) {
                                    Image[] array = new Image[nonDisposedImages.size()];
                                    nonDisposedImages.toArray(array);
                                    shell.setImages(array);
                                }
                            }
                            if ((layout = this.getLayout()) != null) {
                                shell.setLayout(layout);
                            }
                            shell.setText(ProvUIMessages.TrustCertificateDialog_Title);
                        }

                        protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
                            if (18 == id) {
                                ((GridData)parent.getLayoutData()).horizontalAlignment = 4;
                                ++((GridLayout)parent.getLayout()).numColumns;
                                final Button rememberButton = new Button(parent, 32);
                                rememberButton.setText(Messages.P2ServiceUI_certs_rememberAccepted);
                                rememberButton.setFont(JFaceResources.getDialogFont());
                                GridData data = new GridData(768);
                                rememberButton.setLayoutData((Object)data);
                                rememberButton.addSelectionListener(new SelectionListener(){

                                    public void widgetSelected(SelectionEvent e) {
                                        remember.set(rememberButton.getSelection());
                                    }

                                    public void widgetDefaultSelected(SelectionEvent e) {
                                        remember.set(rememberButton.getSelection());
                                    }
                                });
                            } else if (id == 0) {
                                ((GridData)parent.getLayoutData()).horizontalAlignment = 4;
                                ++((GridLayout)parent.getLayout()).numColumns;
                                final Button alwaysButton = new Button(parent, 32);
                                alwaysButton.setText(Messages.P2ServiceUI_certs_alwaysAccept);
                                alwaysButton.setFont(JFaceResources.getDialogFont());
                                GridData data = new GridData(768);
                                alwaysButton.setLayoutData((Object)data);
                                alwaysButton.addSelectionListener(new SelectionListener(){

                                    public void widgetSelected(SelectionEvent e) {
                                        always.set(alwaysButton.getSelection());
                                    }

                                    public void widgetDefaultSelected(SelectionEvent e) {
                                        always.set(alwaysButton.getSelection());
                                    }
                                });
                            }
                            return super.createButton(parent, id, label, defaultButton);
                        }
                    };
                    trustCertificateDialog.open();
                    Object[] dialogResult = trustCertificateDialog.getResult();
                    Certificate[] values = new Certificate[dialogResult == null ? 0 : dialogResult.length];
                    int i = 0;
                    while (i < values.length) {
                        values[i] = (Certificate)((TreeNode)dialogResult[i]).getValue();
                        ++i;
                    }
                    result[0] = values;
                }
            });
            trusted = (Certificate[])result[0];
        }
        return new CertificateConfirmer.TrustInfoWithPolicy(trusted, remember.get(), trustUnsigned, always.get());
    }

    private TreeNode[] createTreeNodes(Certificate[][] certificates) {
        TreeNode[] children = new TreeNode[certificates.length];
        int i = 0;
        while (i < certificates.length) {
            TreeNode head;
            TreeNode parent = head = new TreeNode((Object)certificates[i][0]);
            children[i] = head;
            int j = 0;
            while (j < certificates[i].length) {
                TreeNode node = new TreeNode((Object)certificates[i][j]);
                node.setParent(parent);
                parent.setChildren(new TreeNode[]{node});
                parent = node;
                ++j;
            }
            ++i;
        }
        return children;
    }

    protected Shell getShell() {
        try {
            final Shell shell = UIUtil.getShell();
            final Shell[] result = new Shell[]{shell};
            if (shell != null) {
                UIUtil.syncExec((Control)shell, (Runnable)new Runnable(){

                    public void run() {
                        Composite parent = shell.getParent();
                        while (parent != null) {
                            if (parent instanceof Shell) {
                                result[0] = (Shell)parent;
                            }
                            parent = parent.getParent();
                        }
                        Shell[] shellArray = result[0].getShells();
                        int n = shellArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Shell child = shellArray[n2];
                            if (child.isVisible() && child.getData() instanceof Dialog) {
                                result[0] = child;
                                break;
                            }
                            ++n2;
                        }
                    }
                });
            }
            return result[0];
        }
        catch (Throwable ex) {
            return null;
        }
    }

    static class OkCancelErrorDialog
    extends ErrorDialog {
        public OkCancelErrorDialog(Shell parentShell, String dialogTitle, String message, IStatus status, int displayMask) {
            super(parentShell, dialogTitle, message, status, displayMask);
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, true);
            this.createDetailsButton(parent);
        }
    }
}

