/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.gitbash;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.oomph.gitbash.Activator;
import org.eclipse.swt.widgets.Shell;

public class GitBash {
    private static final String DEFAULT_EXECUTABLE = "C:\\Program Files (x86)\\Git\\bin\\sh.exe";
    public static boolean quiet;
    private static String executable;

    public static synchronized String getExecutable(Shell shell) {
        if (executable == null) {
            File stateFile = Activator.getDefault().getStateLocation().append("git-bash.txt").toFile();
            if (stateFile.isFile()) {
                executable = GitBash.loadFile(stateFile);
            }
            if (executable == null && (executable = GitBash.openInputDialog(DEFAULT_EXECUTABLE, shell)) == null) {
                return null;
            }
            if (!new File(executable).isFile()) {
                executable = GitBash.openInputDialog(executable, shell);
            }
            GitBash.saveFile(stateFile, executable);
        }
        return executable;
    }

    public static void executeCommand(Shell shell, File workTree, String command) {
        try {
            String gitBash = GitBash.getExecutable(shell);
            if (gitBash != null) {
                String line;
                ProcessBuilder builder = new ProcessBuilder(gitBash, "--login", "-c", command);
                builder.directory(workTree);
                builder.redirectErrorStream(true);
                Process process = builder.start();
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                StringBuilder output = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    output.append(line);
                    output.append("\n");
                }
                int exitValue = process.waitFor();
                if (exitValue == 0) {
                    String message = "Command '" + command + "' executed successfully";
                    if (!quiet) {
                        Activator.log(String.valueOf(message) + "\n" + output, 1);
                        MessageDialog.openInformation((Shell)shell, (String)"Git Bash", (String)message);
                    }
                } else {
                    String message = "Command '" + command + "' failed: " + exitValue;
                    if (!quiet) {
                        Activator.log(String.valueOf(message) + "\n" + output, 4);
                        MessageDialog.openError((Shell)shell, (String)"Git Bash", (String)message);
                    }
                }
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static String openInputDialog(String initial, Shell shell) {
        InputDialog dialog = new InputDialog(shell, "Git Bash", "Location:", initial, new IInputValidator(){

            public String isValid(String newText) {
                return new File(newText).isFile() ? null : "Not a file!";
            }
        });
        if (dialog.open() != 0) {
            return null;
        }
        return dialog.getValue();
    }

    /*
     * Loose catch block
     */
    private static String loadFile(File file) {
        String string;
        FileReader in;
        block11: {
            in = null;
            in = new FileReader(file);
            string = new BufferedReader(in).readLine();
            if (in == null) break block11;
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        return string;
        catch (IOException iOException) {
            block12: {
                try {
                    if (in == null) break block12;
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    throw throwable;
                }
                try {
                    in.close();
                }
                catch (IOException iOException3) {}
            }
            return null;
        }
    }

    private static void saveFile(File file, String content) {
        FileWriter out = null;
        try {
            try {
                out = new FileWriter(file);
                out.write(content);
            }
            catch (IOException ex) {
                throw new IllegalStateException("Could not write to " + file, ex);
            }
        }
        catch (Throwable throwable) {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }
}

