/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.dialogs;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.dialogs.IUPropertyPage;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;

public class IUGeneralInfoPropertyPage
extends IUPropertyPage {
    @Override
    protected Control createIUPage(Composite parent, IInstallableUnit iu) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        this.createGeneralSection(composite, iu);
        this.createDescriptionSection(composite, iu);
        this.createDocumentationSection(composite, iu);
        return composite;
    }

    private void createGeneralSection(Composite parent, IInstallableUnit iu) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        this.addField(composite, ProvUIMessages.IUGeneralInfoPropertyPage_NameLabel, iu.getProperty("org.eclipse.equinox.p2.name", null));
        this.addField(composite, ProvUIMessages.IUGeneralInfoPropertyPage_IdentifierLabel, iu.getId());
        this.addField(composite, ProvUIMessages.IUGeneralInfoPropertyPage_VersionLabel, iu.getVersion().toString());
        this.addField(composite, ProvUIMessages.IUGeneralInfoPropertyPage_ProviderLabel, iu.getProperty("org.eclipse.equinox.p2.provider", null));
        this.addField(composite, ProvUIMessages.IUGeneralInfoPropertyPage_ContactLabel, iu.getProperty("org.eclipse.equinox.p2.contact", null));
    }

    private void createDescriptionSection(Composite parent, IInstallableUnit iu) {
        String description = iu.getProperty("org.eclipse.equinox.p2.description", null);
        if (description != null && description.length() > 0) {
            Group group = new Group(parent, 0);
            group.setText(ProvUIMessages.IUGeneralInfoPropertyPage_DescriptionLabel);
            group.setLayout((Layout)new GridLayout());
            group.setLayoutData((Object)new GridData(1808));
            Text text = new Text((Composite)group, 586);
            GridData gd = new GridData(4, 4, true, true);
            gd.widthHint = this.computeWidthLimit((Control)text, 80);
            gd.heightHint = 200;
            text.setEditable(false);
            text.setText(description);
            text.setLayoutData((Object)gd);
        }
    }

    private void createDocumentationSection(Composite parent, IInstallableUnit iu) {
        String docURL = iu.getProperty("org.eclipse.equinox.p2.doc.url");
        if (docURL != null && docURL.length() > 0) {
            String filename;
            URL url;
            try {
                url = new URL(docURL);
            }
            catch (MalformedURLException malformedURLException) {
                return;
            }
            String string = filename = url != null ? url.getFile() : null;
            if (filename != null && (filename.endsWith(".htm") || filename.endsWith(".html"))) {
                new Label(parent, 0);
                Label label = new Label(parent, 0);
                label.setText(ProvUIMessages.IUGeneralInfoPropertyPage_DocumentationLink);
                Link link = new Link(parent, 16448);
                link.setText(NLS.bind((String)"<a>{0}</a>", (Object)url.toExternalForm()));
                GridData gd = new GridData(770);
                gd.widthHint = this.computeWidthLimit((Control)link, 80);
                link.setLayoutData((Object)gd);
                link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        IUGeneralInfoPropertyPage.this.showURL(url);
                    }
                });
            }
        }
    }

    private void addField(Composite parent, String property, String value) {
        if (value != null && value.length() > 0) {
            Label label = new Label(parent, 0);
            label.setText(property);
            Text text = new Text(parent, 72);
            text.setText(this.getEscapedString(value));
            text.setBackground(text.getDisplay().getSystemColor(22));
            GridData gd = new GridData(4, 4, true, true);
            text.setLayoutData((Object)gd);
        }
    }

    private String getEscapedString(String value) {
        StringBuffer result = new StringBuffer(value.length() + 10);
        int i = 0;
        while (i < value.length()) {
            char c = value.charAt(i);
            if ('&' == c) {
                result.append("&&");
            } else {
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }
}

