/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.menus;

import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MTrimContribution;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuFactoryImpl;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.menus.ContributionFactoryGenerator;
import org.eclipse.ui.internal.menus.MenuAdditionCacheEntry;
import org.eclipse.ui.internal.menus.MenuHelper;
import org.eclipse.ui.internal.menus.MenuLocationURI;

public class MenuFactoryGenerator {
    private MApplication application;
    private IConfigurationElement configElement;
    private MenuLocationURI location;

    public MenuFactoryGenerator(MApplication application, IEclipseContext appContext, IConfigurationElement configElement, String attribute) {
        this.application = application;
        assert (appContext.equals(this.application.getContext()));
        this.configElement = configElement;
        this.location = new MenuLocationURI(attribute);
    }

    private boolean inToolbar() {
        return this.location.getScheme().startsWith("toolbar");
    }

    public void mergeIntoModel(ArrayList<MMenuContribution> menuContributions, ArrayList<MToolBarContribution> toolBarContributions, ArrayList<MTrimContribution> trimContributions) {
        if (this.location.getPath() == null || this.location.getPath().length() == 0) {
            WorkbenchPlugin.log("MenuFactoryGenerator.mergeIntoModel: Invalid menu URI: " + this.location);
            return;
        }
        if (this.inToolbar()) {
            if (!MenuAdditionCacheEntry.isInWorkbenchTrim(this.location)) {
                String query = this.location.getQuery();
                if (query == null || query.length() == 0) {
                    query = "after=additions";
                }
                this.processToolbarChildren(toolBarContributions, this.configElement, this.location.getPath(), query);
            }
            return;
        }
        MMenuContribution menuContribution = MenuFactoryImpl.eINSTANCE.createMenuContribution();
        String idContrib = MenuHelper.getId(this.configElement);
        if (idContrib != null && idContrib.length() > 0) {
            menuContribution.setElementId(idContrib);
        }
        if ("org.eclipse.ui.popup.any".equals(this.location.getPath())) {
            menuContribution.setParentId("popup");
        } else {
            menuContribution.setParentId(this.location.getPath());
        }
        String query = this.location.getQuery();
        if (query == null || query.length() == 0) {
            query = "after=additions";
        }
        menuContribution.setPositionInParent(query);
        menuContribution.getTags().add("scheme:" + this.location.getScheme());
        String filter = "menuContribution:menu";
        if ("popup".equals(this.location.getScheme())) {
            filter = "menuContribution:popup";
        }
        menuContribution.getTags().add(filter);
        menuContribution.setVisibleWhen(MenuHelper.getVisibleWhen(this.configElement));
        ContributionFactoryGenerator generator = new ContributionFactoryGenerator(this.configElement, 0);
        menuContribution.getTransientData().put("ContributionFactory", generator);
        menuContributions.add(menuContribution);
    }

    private void processToolbarChildren(ArrayList<MToolBarContribution> contributions, IConfigurationElement toolbar, String parentId, String position) {
        MToolBarContribution toolBarContribution = MenuFactoryImpl.eINSTANCE.createToolBarContribution();
        String idContrib = MenuHelper.getId(toolbar);
        if (idContrib != null && idContrib.length() > 0) {
            toolBarContribution.setElementId(idContrib);
        }
        toolBarContribution.setParentId(parentId);
        toolBarContribution.setPositionInParent(position);
        toolBarContribution.getTags().add("scheme:" + this.location.getScheme());
        ContributionFactoryGenerator generator = new ContributionFactoryGenerator(this.configElement, 1);
        toolBarContribution.getTransientData().put("ToolBarContributionFactory", generator);
        contributions.add(toolBarContribution);
    }
}

