/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.targlets.internal.core.listeners;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.URIHandler;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.emf.ecore.resource.impl.PlatformContentHandlerImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLContentHandlerImpl;
import org.eclipse.oomph.util.IOUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FileUpdater {
    private static final URIConverter URI_CONVERTER = new ExtensibleURIConverterImpl((Collection)URIHandler.DEFAULT_HANDLERS, Arrays.asList(new PlatformContentHandlerImpl(), new XMLContentHandlerImpl()));

    private URI getURI(File file) {
        IFile[] iFileArray = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(file.toURI());
        int n = iFileArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFile iFile = iFileArray[n2];
            IProject project = iFile.getProject();
            if (project.isOpen()) {
                return URI.createPlatformResourceURI((String)iFile.getFullPath().toString(), (boolean)true);
            }
            ++n2;
        }
        return URI.createFileURI((String)file.toString());
    }

    protected Map<String, ?> getDescription(URI uri) throws IOException {
        return URI_CONVERTER.contentDescription(uri, null);
    }

    public boolean update(File file) throws Exception {
        String oldContents;
        String newContents;
        URI uri = this.getURI(file);
        Map<String, ?> description = this.getDescription(uri);
        String nl = (String)description.get("org.eclipse.emf.ecore:lineDelimiter");
        String encoding = (String)description.get("org.eclipse.core.runtime:charset");
        if (encoding == null) {
            encoding = "UTF-8";
        }
        if ((newContents = this.createNewContents(oldContents = URI_CONVERTER.exists(uri, null) ? this.getContents(uri, encoding) : null, encoding, nl)) != null && !newContents.equals(oldContents)) {
            this.setContents(uri, encoding, newContents);
            return true;
        }
        return false;
    }

    protected abstract String createNewContents(String var1, String var2, String var3);

    protected String getContents(URI uri, String encoding) throws IOException {
        InputStream inputStream = URI_CONVERTER.createInputStream(uri);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            IOUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        finally {
            IOUtil.close((Closeable)inputStream);
        }
        return new String(outputStream.toByteArray(), encoding);
    }

    protected void setContents(URI uri, String encoding, String contents) throws IOException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(contents.getBytes(encoding));
        OutputStream outputStream = URI_CONVERTER.createOutputStream(uri);
        try {
            IOUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        finally {
            IOUtil.close((Closeable)outputStream);
        }
    }
}

