/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.configmanager.internal.handlers;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.configmanager.IConfigurationFileHandler;

public final class PropertiesFileConfigurationHandler
implements IConfigurationFileHandler {
    private static final String PROPERTIES_EXTENSION_FILE_NAME = ".properties";
    private static final Log LOGGER = LogFactory.getLog(PropertiesFileConfigurationHandler.class);

    public final String getServicePID(String fileName) {
        NullArgumentException.validateNotEmpty(fileName, "fileName");
        if (fileName.endsWith(PROPERTIES_EXTENSION_FILE_NAME)) {
            int index = fileName.lastIndexOf(PROPERTIES_EXTENSION_FILE_NAME);
            return fileName.substring(0, index);
        }
        return null;
    }

    public final Properties handle(File file) throws IllegalArgumentException {
        NullArgumentException.validateNotNull(file, "file");
        try {
            Properties prop = new Properties();
            FileInputStream fis = new FileInputStream(file);
            prop.load(fis);
            return prop;
        }
        catch (IOException e) {
            LOGGER.error("Fail to handle file [" + file.getAbsolutePath() + "] configuration property.", e);
            return null;
        }
    }

    public final boolean canHandle(File file) throws IllegalArgumentException {
        NullArgumentException.validateNotNull(file, "file");
        String fileName = file.getName();
        return fileName.endsWith(PROPERTIES_EXTENSION_FILE_NAME);
    }
}

