/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.monitoring.servlet;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.sdt.home.monitoring.util.HttpSessionHelper;
import org.json.simple.JSONObject;

public class CredentialsServlet
extends HttpServlet {
    private static Log LOGGER = LogFactory.getLog(CredentialsServlet.class);
    private static final long serialVersionUID = 1L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpSession session = request.getSession();
        if (session == null) {
            response.sendError(403);
            return;
        }
        if (session.isNew()) {
            LOGGER.info((Object)"session is new");
        }
        HttpSessionHelper sessionHelper = new HttpSessionHelper(session);
        String name = sessionHelper.getName();
        String password = sessionHelper.getPassword();
        LOGGER.info((Object)("session: " + name + " / " + password + " / " + session.getId()));
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"name", (Object)name);
        if (sessionHelper.getBearer() != null) {
            jsonObject.put((Object)"bearer", (Object)sessionHelper.getBearer());
            jsonObject.put((Object)"clientId", (Object)sessionHelper.getClientId());
        }
        if (name != null && !name.isEmpty() && password != null && !password.isEmpty()) {
            jsonObject.put((Object)"credentials", (Object)(String.valueOf(name) + ':' + password));
        }
        response.setContentType("application/json");
        response.getWriter().write(jsonObject.toJSONString());
    }
}

