/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.ipe.sdt.testsuite.module;

import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.resource.AbstractFlexContainer;
import org.eclipse.om2m.commons.resource.CustomAttribute;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.commons.resource.flexcontainerspec.ColourSaturationFlexContainer;
import org.eclipse.om2m.core.service.CseService;
import org.eclipse.om2m.ipe.sdt.testsuite.CSEUtil;
import org.eclipse.om2m.ipe.sdt.testsuite.TestReport;
import org.eclipse.om2m.ipe.sdt.testsuite.module.AbstractModuleTest;
import org.eclipse.om2m.ipe.sdt.testsuite.module.exception.FlexContainerNotFound;
import org.eclipse.om2m.sdt.Device;
import org.eclipse.om2m.sdt.Module;
import org.eclipse.om2m.sdt.datapoints.BooleanDataPoint;
import org.eclipse.om2m.sdt.datapoints.IntegerDataPoint;
import org.eclipse.om2m.sdt.exceptions.AccessException;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.home.types.DatapointType;
import org.eclipse.om2m.sdt.home.types.ModuleType;

public class ColourSaturationModuleTest
extends AbstractModuleTest {
    public ColourSaturationModuleTest(CseService pCseService, Module pModule) {
        super(pCseService, pModule);
        Device device = this.getModule().getOwner();
        String binarySwitchModuleName = null;
        for (String moduleName : device.getModuleNames()) {
            if (!moduleName.toLowerCase().contains(ModuleType.binarySwitch.getShortName())) continue;
            binarySwitchModuleName = moduleName;
            break;
        }
        if (binarySwitchModuleName != null) {
            BooleanDataPoint powerStateDP = (BooleanDataPoint)this.getModule().getOwner().getModule(binarySwitchModuleName).getDataPoint(DatapointType.powerState.getShortName());
            try {
                powerStateDP.setValue((Object)Boolean.TRUE);
            }
            catch (AccessException | DataPointException throwable) {}
        }
    }

    public TestReport test() {
        TestReport report = new TestReport("Test for module " + this.getModule().getName());
        String moduleUrl = null;
        try {
            moduleUrl = this.getModuleFlexContainerUrl();
        }
        catch (FlexContainerNotFound flexContainerNotFound) {
            report.setErrorMessage("unable to find out FlexContainer for module " + this.getModule().getName());
            report.setState(TestReport.State.KO);
            return report;
        }
        ResponsePrimitive response = CSEUtil.retrieveEntity(this.getCseService(), moduleUrl);
        if (!ResponseStatusCode.OK.equals(response.getResponseStatusCode())) {
            report.setErrorMessage("unable to retrieve FlexContainer of module " + this.getModule().getName() + " : " + response.getContent());
            report.setState(TestReport.State.KO);
            return report;
        }
        ColourSaturationFlexContainer retrievedFlexContainer = (ColourSaturationFlexContainer)response.getContent();
        CustomAttribute colourSaturationCA = retrievedFlexContainer.getCustomAttribute(DatapointType.colourSaturation.getShortName());
        Integer colourSaturationFromFlexContainer = Integer.valueOf(colourSaturationCA.getValue());
        IntegerDataPoint colourSaturationDP = (IntegerDataPoint)this.getModule().getDataPoint(DatapointType.colourSaturation.getShortName());
        Integer colourSaturationFromDP = null;
        try {
            colourSaturationFromDP = (Integer)colourSaturationDP.getValue();
        }
        catch (AccessException | DataPointException e) {
            report.setErrorMessage("unable to retrieve value from colourSaturation Datapoint:" + e.getMessage());
            report.setState(TestReport.State.KO);
            return report;
        }
        if (Math.abs(colourSaturationFromFlexContainer - colourSaturationFromDP) > 2) {
            report.setErrorMessage("value from flexContainer (" + colourSaturationFromFlexContainer + ") is different of the value from Datapoint(" + colourSaturationFromDP + ")");
            report.setState(TestReport.State.KO);
            return report;
        }
        ColourSaturationFlexContainer toBeUpdated = new ColourSaturationFlexContainer();
        Integer newColourSaturation = new Integer((int)(Math.random() * 100.0));
        colourSaturationCA.setValue(newColourSaturation.toString());
        toBeUpdated.getCustomAttributes().add(colourSaturationCA);
        response = CSEUtil.updateFlexContainerEntity(this.getCseService(), moduleUrl, (AbstractFlexContainer)toBeUpdated);
        if (!ResponseStatusCode.UPDATED.equals(response.getResponseStatusCode())) {
            report.setErrorMessage("unable to update value of colourSaturation customAttribute:" + response.getContent());
            report.setState(TestReport.State.KO);
            return report;
        }
        try {
            colourSaturationFromDP = (Integer)colourSaturationDP.getValue();
        }
        catch (AccessException | DataPointException e) {
            report.setErrorMessage("unable to retrieve value from colourSaturation Datapoint:" + e.getMessage());
            report.setState(TestReport.State.KO);
            return report;
        }
        if (Math.abs(newColourSaturation - colourSaturationFromDP) > 2) {
            report.setErrorMessage("new value of flexContainer (" + newColourSaturation + ") is different of the value from Datapoint(" + colourSaturationFromDP + ")");
            report.setState(TestReport.State.KO);
            return report;
        }
        response = CSEUtil.retrieveEntity(this.getCseService(), moduleUrl);
        if (!ResponseStatusCode.OK.equals(response.getResponseStatusCode())) {
            report.setErrorMessage("unable to retrieve FlexContainer of module " + this.getModule().getName() + " : " + response.getContent());
            report.setState(TestReport.State.KO);
            return report;
        }
        retrievedFlexContainer = (ColourSaturationFlexContainer)response.getContent();
        colourSaturationCA = retrievedFlexContainer.getCustomAttribute(DatapointType.colourSaturation.getShortName());
        colourSaturationFromFlexContainer = Integer.valueOf(colourSaturationCA.getValue());
        if (Math.abs(colourSaturationFromFlexContainer - newColourSaturation) > 2) {
            report.setErrorMessage("value from flexContainer (" + colourSaturationFromFlexContainer + ") is different of the value set(" + newColourSaturation + ")");
            report.setState(TestReport.State.KO);
            return report;
        }
        report.setState(TestReport.State.OK);
        return report;
    }
}

