/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.types;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.om2m.commons.resource.AbstractFlexContainer;
import org.eclipse.om2m.commons.resource.CustomAttribute;
import org.eclipse.om2m.commons.resource.flexcontainerspec.ObjectFactory;

public class FlexContainers {
    private static final String PREFIX = "create";
    private static final String SUFFIX = "Annc";
    private static ObjectFactory factory = ObjectFactory.getInstance();
    private static Map<String, String[]> flexNames = new HashMap<String, String[]>();
    private static Map<String, String[]> dpNames = new HashMap<String, String[]>();

    static {
        Method[] methodArray = ObjectFactory.class.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            String method = m.getName();
            if (!method.endsWith(SUFFIX) && method.startsWith(PREFIX)) {
                try {
                    AbstractFlexContainer flex = (AbstractFlexContainer)m.invoke((Object)factory, new Object[0]);
                    flexNames.put(flex.getLongName(), new String[]{flex.getShortName(), flex.getContainerDefinition()});
                    for (CustomAttribute ca : flex.getCustomAttributes()) {
                        dpNames.put(ca.getLongName(), new String[]{ca.getShortName(), ca.getType()});
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
    }

    public static String getFlexShortName(String longName) {
        String[] ret = flexNames.get(longName);
        if (ret == null) {
            throw new UnknownError("No valid flexContainer for " + longName);
        }
        return ret[0];
    }

    public static String getContainerDefinition(String longName) {
        String[] ret = flexNames.get(longName);
        if (ret == null) {
            throw new UnknownError("No valid flexContainer for " + longName);
        }
        return ret[1];
    }

    public static String[] getDataPoint(String longName) {
        String[] ret = dpNames.get(longName);
        if (ret == null) {
            throw new UnknownError("No valid flexContainer for " + longName);
        }
        return ret;
    }
}

