/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.modules;

import java.util.Map;
import org.eclipse.om2m.sdt.DataPoint;
import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.Identifiers;
import org.eclipse.om2m.sdt.Module;
import org.eclipse.om2m.sdt.datapoints.FloatDataPoint;
import org.eclipse.om2m.sdt.datapoints.IntegerDataPoint;
import org.eclipse.om2m.sdt.exceptions.AccessException;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.home.types.DatapointType;
import org.eclipse.om2m.sdt.home.types.ModuleType;

public class RelativeHumidity
extends Module {
    private FloatDataPoint relativeHumidity;
    private IntegerDataPoint desiredHumidity;

    public RelativeHumidity(String name, Domain domain, FloatDataPoint relativeHumidity) {
        super(name, domain, (Identifiers)ModuleType.relativeHumidity);
        if (relativeHumidity == null || !relativeHumidity.getShortName().equals(DatapointType.relativeHumidity.getShortName())) {
            domain.removeModule(this.getName());
            throw new IllegalArgumentException("Wrong relativeHumidity datapoint: " + relativeHumidity);
        }
        this.relativeHumidity = relativeHumidity;
        this.relativeHumidity.setWritable(false);
        this.relativeHumidity.setDoc("The measurement of the relative humidity value; the common unit is percentage.");
        this.addDataPoint((DataPoint)relativeHumidity);
    }

    public RelativeHumidity(String name, Domain domain, Map<String, DataPoint> dps) {
        this(name, domain, (FloatDataPoint)dps.get(DatapointType.relativeHumidity.getShortName()));
        IntegerDataPoint desiredHumidity = (IntegerDataPoint)dps.get(DatapointType.desiredHumidity.getShortName());
        if (desiredHumidity != null) {
            this.setDesiredHumidity(desiredHumidity);
        }
    }

    public float getRelativeHumidity() throws DataPointException, AccessException {
        return ((Float)this.relativeHumidity.getValue()).floatValue();
    }

    public void setDesiredHumidity(IntegerDataPoint dp) {
        this.desiredHumidity = dp;
        this.desiredHumidity.setOptional(true);
        this.desiredHumidity.setDoc("Desired value for Humidity.");
        this.addDataPoint((DataPoint)this.desiredHumidity);
    }

    public int getDesiredHumidity() throws DataPointException, AccessException {
        if (this.desiredHumidity == null) {
            throw new DataPointException("Not implemented");
        }
        return (Integer)this.desiredHumidity.getValue();
    }

    public void setDesiredHumidity(int b) throws DataPointException, AccessException {
        if (this.desiredHumidity == null) {
            throw new DataPointException("Not implemented");
        }
        this.desiredHumidity.setValue((Object)b);
    }
}

