/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.modules;

import java.util.Map;
import javax.xml.bind.PropertyException;
import org.eclipse.om2m.sdt.DataPoint;
import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.Identifiers;
import org.eclipse.om2m.sdt.Module;
import org.eclipse.om2m.sdt.Property;
import org.eclipse.om2m.sdt.datapoints.BooleanDataPoint;
import org.eclipse.om2m.sdt.exceptions.AccessException;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.home.types.DatapointType;
import org.eclipse.om2m.sdt.home.types.ModuleType;
import org.eclipse.om2m.sdt.home.types.PropertyType;
import org.eclipse.om2m.sdt.types.SimpleType;

public class Lock
extends Module {
    private BooleanDataPoint doorLock;
    private Property openOnly;

    public Lock(String name, Domain domain, BooleanDataPoint doorLock) {
        super(name, domain, (Identifiers)ModuleType.lock);
        if (doorLock == null || !doorLock.getShortName().equals(DatapointType.lock.getShortName())) {
            domain.removeModule(this.getName());
            throw new IllegalArgumentException("Wrong doorLock datapoint: " + doorLock);
        }
        this.doorLock = doorLock;
        this.doorLock.setDoc("\"True\" indicates the door is locked, while \"False\" indicates the door is not locked");
        this.addDataPoint((DataPoint)this.doorLock);
        this.openOnly = new Property((Identifiers)PropertyType.openOnly);
        this.openOnly.setType(SimpleType.Boolean);
        this.openOnly.setOptional(true);
        this.addProperty(this.openOnly);
    }

    public Lock(String name, Domain domain, Map<String, DataPoint> dps) {
        this(name, domain, (BooleanDataPoint)dps.get(DatapointType.lock.getShortName()));
    }

    public void setDoorLock(boolean c) throws DataPointException, AccessException {
        this.doorLock.setValue((Object)c);
    }

    public boolean getDoorLock() throws DataPointException, AccessException {
        return (Boolean)this.doorLock.getValue();
    }

    public void setOpenOnly(boolean v) {
        this.openOnly.setValue(Boolean.toString(v));
    }

    public boolean getOpenOnly() throws PropertyException {
        if (this.openOnly.getValue() == null) {
            throw new PropertyException("Not implemented");
        }
        return Boolean.parseBoolean(this.openOnly.getValue());
    }
}

