/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.devices;

import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.Module;
import org.eclipse.om2m.sdt.exceptions.ModuleException;
import org.eclipse.om2m.sdt.home.devices.GenericDevice;
import org.eclipse.om2m.sdt.home.modules.BinarySwitch;
import org.eclipse.om2m.sdt.home.modules.Colour;
import org.eclipse.om2m.sdt.home.modules.ColourSaturation;
import org.eclipse.om2m.sdt.home.modules.FaultDetection;
import org.eclipse.om2m.sdt.home.modules.RunState;
import org.eclipse.om2m.sdt.home.types.DeviceType;

public class Light
extends GenericDevice {
    private FaultDetection faultDetection;
    private BinarySwitch binarySwitch;
    private RunState runState;
    private Colour colour;
    private ColourSaturation colourSaturation;

    public Light(String id, String serial, Domain domain) {
        super(id, serial, DeviceType.deviceLight, domain);
    }

    public void addModule(Module module) {
        if (module instanceof FaultDetection) {
            this.addModule((FaultDetection)module);
        } else if (module instanceof BinarySwitch) {
            this.addModule((BinarySwitch)module);
        } else if (module instanceof RunState) {
            this.addModule((RunState)module);
        } else if (module instanceof Colour) {
            this.addModule((Colour)module);
        } else if (module instanceof ColourSaturation) {
            this.addModule((ColourSaturation)module);
        } else {
            super.addModule(module);
        }
    }

    public void addModule(Colour mod) {
        this.colour = mod;
        super.addModule((Module)this.colour);
    }

    public void addModule(ColourSaturation mod) {
        this.colourSaturation = mod;
        super.addModule((Module)this.colourSaturation);
    }

    public void addModule(FaultDetection mod) {
        this.faultDetection = mod;
        super.addModule((Module)this.faultDetection);
    }

    public void addModule(BinarySwitch mod) {
        this.binarySwitch = mod;
        super.addModule((Module)this.binarySwitch);
    }

    public void addModule(RunState mod) {
        this.runState = mod;
        super.addModule((Module)this.runState);
    }

    public FaultDetection getFaultDetection() {
        return this.faultDetection;
    }

    public BinarySwitch getBinarySwitch() throws ModuleException {
        if (this.binarySwitch == null) {
            throw new ModuleException("Not implemented");
        }
        return this.binarySwitch;
    }

    public RunState getRunState() {
        return this.runState;
    }

    public Colour getColour() {
        return this.colour;
    }

    public ColourSaturation getColourSaturation() {
        return this.colourSaturation;
    }
}

