/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.hue.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.hue.api.HueBridgeDevice;
import org.eclipse.om2m.hue.api.HueLightDevice;
import org.eclipse.om2m.hue.api.types.HueException;
import org.eclipse.om2m.hue.api.types.LightState;
import org.eclipse.om2m.hue.api.types.UnknownHueGatewayException;
import org.eclipse.om2m.hue.impl.HueDeviceImpl;
import org.eclipse.om2m.hue.impl.HueLightDeviceImpl;
import org.eclipse.om2m.hue.impl.controller.Light;

public class FakeBridge
extends HueDeviceImpl
implements HueBridgeDevice {
    private static Log Logger = LogFactory.getLog(FakeBridge.class);
    private List<HueLightDevice> lights;

    public FakeBridge(String xml_description) {
        super(xml_description);
        String id = "" + System.currentTimeMillis();
        this.properties.put("service.pid", "fake_bridge_pid_" + id);
        this.properties.put("DEVICE_SERIAL", "fake_serial_" + id);
        this.properties.put("DEVICE_DESCRIPTION", "Fake Hue bridge");
        this.properties.put("DEVICE_MANUFACTURER", "Orange");
        this.properties.put("DEVICE_FRIENDLY_NAME", "Fake Hue bridge");
        this.lights = new ArrayList<HueLightDevice>();
        this.lights.add(this.createFakeLight(1));
        this.lights.add(this.createFakeLight(2));
        this.lights.add(this.createFakeLight(3));
        this.lights.add(this.createFakeLight(4));
    }

    public String getUDN() {
        return "_udn_";
    }

    public List<HueLightDevice> getLights() throws HueException, UnknownHueGatewayException {
        return this.lights;
    }

    public void setWakeUp(int group) throws HueException {
    }

    public void setMeal(int group) throws HueException {
    }

    public void setNight(int group) throws HueException {
    }

    public void setHomeCinema(int group) throws HueException {
    }

    public void setParty(int group) throws HueException {
    }

    public void setOn(int group) throws HueException {
    }

    public void setOff(int group) throws HueException {
    }

    public void setOnOff(int group, boolean on) throws HueException {
        if (on) {
            this.setOn(group);
        } else {
            this.setOff(group);
        }
    }

    private HueLightDevice createFakeLight(int i) {
        return new HueLightDeviceImpl(this, new FakeLight("" + i));
    }

    private class FakeLight
    extends Light {
        private LightState state;

        FakeLight(String id) {
            super("", "foo", id);
        }

        @Override
        public String getName() {
            return this.getId();
        }

        @Override
        public String getType() {
            return "type";
        }

        @Override
        public boolean isReachable() {
            return true;
        }

        @Override
        public LightState getState() throws HueException, UnknownHueGatewayException {
            Logger.info((Object)("get " + this.state + " on " + this.getName()));
            return this.state;
        }

        @Override
        public void setState(LightState ls) throws HueException, UnknownHueGatewayException {
            Logger.info((Object)("set " + ls + " on " + this.getName()));
            this.state = ls;
        }
    }
}

