/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.persistence.mongodb.resource;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.commons.entities.AccessControlPolicyEntity;
import org.eclipse.om2m.commons.entities.AeAnncEntity;
import org.eclipse.om2m.commons.entities.AeEntity;
import org.eclipse.om2m.commons.entities.CSEBaseEntity;
import org.eclipse.om2m.commons.entities.ContainerEntity;
import org.eclipse.om2m.commons.entities.ContentInstanceEntity;
import org.eclipse.om2m.commons.entities.DynamicAuthorizationConsultationEntity;
import org.eclipse.om2m.commons.entities.FlexContainerAnncEntity;
import org.eclipse.om2m.commons.entities.FlexContainerEntity;
import org.eclipse.om2m.commons.entities.MgmtObjAnncEntity;
import org.eclipse.om2m.commons.entities.MgmtObjEntity;
import org.eclipse.om2m.commons.entities.NodeAnncEntity;
import org.eclipse.om2m.commons.entities.NodeEntity;
import org.eclipse.om2m.commons.entities.RemoteCSEEntity;
import org.eclipse.om2m.commons.entities.ResourceEntity;
import org.eclipse.om2m.persistence.mongodb.Constants;
import org.eclipse.om2m.persistence.mongodb.resource.MongoChildLoader;

public class ResourceSerializerDeserializer<T extends ResourceEntity>
implements Constants,
JsonSerializer<T>,
JsonDeserializer<T> {
    private static final Log LOGGER = LogFactory.getLog(ResourceSerializerDeserializer.class);
    private static final String GET = "get";
    private static final String IS = "is";
    private static final String SET = "set";

    public JsonElement serialize(T entity, Type xxx, JsonSerializationContext ctxt) {
        LOGGER.debug((Object)(" * IN * serialize " + entity));
        JsonObject json = new JsonObject();
        Method[] methodArray = entity.getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if ((method.getName().startsWith(GET) || method.getName().startsWith(IS)) && !method.getName().equals("getClass")) {
                Object result;
                String propertyName = method.getName().startsWith(GET) ? method.getName().substring(3) : method.getName().substring(2);
                boolean isPrimitive = ResourceSerializerDeserializer.isSuperPrimitive(method.getReturnType());
                LOGGER.debug((Object)("serialize (method=" + method.getName() + ") - returnType=" + method.getReturnType() + " - isPrimitive=" + isPrimitive));
                if (isPrimitive) {
                    try {
                        result = method.invoke(entity, new Object[0]);
                        LOGGER.debug((Object)("serialize (method=" + method.getName() + ") - invoke result=" + result));
                        json.add(propertyName, ctxt.serialize(result));
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                        LOGGER.warn((Object)"", (Throwable)e);
                    }
                } else if (ResourceEntity.class.isAssignableFrom(method.getReturnType())) {
                    LOGGER.debug((Object)("Directly assignable to ResourceEntity " + method.getName()));
                } else if (List.class.equals(method.getReturnType())) {
                    try {
                        ParameterizedType pt;
                        result = (List)method.invoke(entity, new Object[0]);
                        JsonArray jsonArray = new JsonArray();
                        LOGGER.debug((Object)("List serialize (method=" + method.getName() + ") - invoke result=" + result));
                        Type type = method.getGenericReturnType();
                        if (ParameterizedType.class.isAssignableFrom(type.getClass()) && (pt = (ParameterizedType)type).getActualTypeArguments().length != 0) {
                            if (ResourceEntity.class.isAssignableFrom((Class)pt.getActualTypeArguments()[0])) {
                                LOGGER.debug((Object)("ComponentType =" + pt.getActualTypeArguments()[0]));
                                if (result != null) {
                                    Iterator iterator = result.iterator();
                                    while (iterator.hasNext()) {
                                        Object obj = iterator.next();
                                        if (obj == null) continue;
                                        ResourceEntity resourceEntity = (ResourceEntity)obj;
                                        JsonObject jsonObject = new JsonObject();
                                        jsonObject.add("ResourceID", (JsonElement)new JsonPrimitive(resourceEntity.getResourceID()));
                                        jsonObject.add("ResourceType", (JsonElement)new JsonPrimitive((Number)resourceEntity.getResourceType()));
                                        if (obj instanceof MgmtObjEntity) {
                                            jsonObject.add("MgmtDefinition", (JsonElement)new JsonPrimitive((Number)((MgmtObjEntity)obj).getMgmtDefinition()));
                                        } else if (obj instanceof MgmtObjAnncEntity) {
                                            jsonObject.add("MgmtDefinition", (JsonElement)new JsonPrimitive((Number)((MgmtObjAnncEntity)obj).getMgmtDefinition()));
                                        }
                                        jsonArray.add((JsonElement)jsonObject);
                                    }
                                }
                                propertyName = "#" + propertyName;
                            } else {
                                jsonArray = (JsonArray)ctxt.serialize(result);
                            }
                            json.add(propertyName, (JsonElement)jsonArray);
                        }
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                        LOGGER.warn((Object)"", (Throwable)e);
                    }
                }
            }
            ++n2;
        }
        LOGGER.debug((Object)(" * OUT * serialize " + json));
        return json;
    }

    private static boolean isSuperPrimitive(Class<?> clazz) {
        return clazz.isPrimitive() || clazz.getName().startsWith("java.lang.") || clazz.getName().startsWith("java.math.");
    }

    public T deserialize(JsonElement obj, Type xxx, JsonDeserializationContext ctxt) throws JsonParseException {
        LOGGER.debug((Object)(" * IN * deserialize " + obj));
        JsonObject jsonObject = (JsonObject)obj;
        T entity = this.create(jsonObject);
        if (entity == null) {
            return null;
        }
        entity.setResourceType(jsonObject.get("ResourceType").getAsBigInteger());
        for (Map.Entry entry : jsonObject.entrySet()) {
            Method setterMethod;
            String propertyName = (String)entry.getKey();
            JsonElement value = (JsonElement)entry.getValue();
            if (propertyName.equals("ResourceType")) continue;
            if (value.isJsonPrimitive()) {
                JsonPrimitive jsonPrimitive = (JsonPrimitive)value;
                Object param = null;
                Method setterMethod2 = ResourceSerializerDeserializer.getSetter(propertyName, entity.getClass());
                if (setterMethod2 == null) {
                    LOGGER.debug((Object)("Setter not found for " + propertyName));
                    continue;
                }
                if (jsonPrimitive.isBoolean()) {
                    param = jsonPrimitive.getAsBoolean();
                } else if (jsonPrimitive.isString()) {
                    param = jsonPrimitive.getAsString();
                } else if (jsonPrimitive.isNumber()) {
                    param = ctxt.deserialize((JsonElement)jsonPrimitive, setterMethod2.getGenericParameterTypes()[0]);
                }
                try {
                    setterMethod2.invoke(entity, param);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    LOGGER.info((Object)("Exception setter=" + setterMethod2.getName() + " - " + setterMethod2.getParameterTypes()[0] + "- valueObject.getClass:" + param.getClass()), (Throwable)e);
                }
                continue;
            }
            if (!value.isJsonArray()) continue;
            JsonArray jsonArray = (JsonArray)value;
            List<Object> params = new ArrayList();
            String initialPropertyName = propertyName;
            if (initialPropertyName.startsWith("#")) {
                initialPropertyName = initialPropertyName.substring(1);
            }
            if ((setterMethod = ResourceSerializerDeserializer.getSetter(initialPropertyName, entity.getClass())) == null) {
                LOGGER.debug((Object)("Setter not found for " + propertyName));
                continue;
            }
            if (jsonArray.size() > 0) {
                if (propertyName.startsWith("#")) {
                    MongoChildLoader<T> m = new MongoChildLoader<T>();
                    params = m.loadChildren(entity, jsonArray);
                } else {
                    params = (List)ctxt.deserialize((JsonElement)jsonArray, setterMethod.getGenericParameterTypes()[0]);
                    LOGGER.debug((Object)("jsonArray=" + jsonArray.toString() + " -> subObject=" + params));
                }
            }
            try {
                setterMethod.invoke(entity, params);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                LOGGER.warn((Object)"", (Throwable)e);
            }
        }
        LOGGER.debug((Object)(" * OUT * deserialize " + entity));
        return entity;
    }

    private static Method getSetter(String propertyName, Class<?> clazz) {
        String setterName = SET + propertyName;
        Method[] methodArray = clazz.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (setterName.equals(method.getName())) {
                return method;
            }
            ++n2;
        }
        return null;
    }

    private final T create(JsonObject jsonObject) {
        BigInteger type = jsonObject.get("ResourceType").getAsBigInteger();
        switch (type.intValue()) {
            case 2: {
                return (T)new AeEntity();
            }
            case 5: {
                return (T)new CSEBaseEntity();
            }
            case 1: {
                return (T)new AccessControlPolicyEntity();
            }
            case 28: {
                return (T)new FlexContainerEntity();
            }
            case 3: {
                return (T)new ContainerEntity();
            }
            case 4: {
                return (T)new ContentInstanceEntity();
            }
            case 16: {
                return (T)new RemoteCSEEntity();
            }
            case 10002: {
                return (T)new AeAnncEntity();
            }
            case 10028: {
                return (T)new FlexContainerAnncEntity();
            }
            case 34: {
                return (T)new DynamicAuthorizationConsultationEntity();
            }
            case 14: {
                return (T)new NodeEntity();
            }
            case 10014: {
                return (T)new NodeAnncEntity();
            }
            case 13: {
                return (T)MgmtObjEntity.create((BigInteger)jsonObject.get("MgmtDefinition").getAsBigInteger());
            }
            case 10013: {
                return (T)MgmtObjAnncEntity.create((BigInteger)jsonObject.get("MgmtDefinition").getAsBigInteger());
            }
        }
        LOGGER.warn((Object)("Cannot create entity for " + type));
        return null;
    }
}

