/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.testsuite.flexcontainer;

import org.eclipse.om2m.commons.constants.Constants;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.resource.AbstractFlexContainer;
import org.eclipse.om2m.commons.resource.CustomAttribute;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.commons.resource.flexcontainerspec.FaultDetectionFlexContainer;
import org.eclipse.om2m.core.service.CseService;
import org.eclipse.om2m.testsuite.flexcontainer.FlexContainerTestSuite;
import org.eclipse.om2m.testsuite.flexcontainer.TestReport;

public class FaultDetectionFlexContainerTest
extends FlexContainerTestSuite {
    public FaultDetectionFlexContainerTest(CseService pCseService) {
        super(pCseService);
    }

    @Override
    protected String getTestSuiteName() {
        return "FaultDetectionFlexContainerTest";
    }

    public void testCreateFaultDetectionFlexContainer() {
        String baseLocation = "/" + Constants.CSE_ID + "/" + Constants.CSE_NAME;
        String flexContainerName = "FaultDetectionFlexContainer_" + System.currentTimeMillis();
        String flexContainerLocation = String.valueOf(baseLocation) + "/" + flexContainerName;
        FaultDetectionFlexContainer flexContainer = new FaultDetectionFlexContainer();
        flexContainer.setName(flexContainerName);
        flexContainer.setOntologyRef("OrangeOntology");
        flexContainer.setCreator("Greg");
        CustomAttribute statusCustomAttribute = new CustomAttribute();
        statusCustomAttribute.setShortName("stats");
        statusCustomAttribute.setValue("false");
        flexContainer.getCustomAttributes().add(statusCustomAttribute);
        CustomAttribute codeCustomAttribute = new CustomAttribute();
        codeCustomAttribute.setShortName("code");
        codeCustomAttribute.setValue("123");
        flexContainer.getCustomAttributes().add(codeCustomAttribute);
        CustomAttribute descriptionCustomAttribute = new CustomAttribute();
        descriptionCustomAttribute.setShortName("descn");
        descriptionCustomAttribute.setValue("My description");
        flexContainer.getCustomAttributes().add(descriptionCustomAttribute);
        ResponsePrimitive response = this.sendCreateFlexContainerRequest((AbstractFlexContainer)flexContainer, baseLocation, Constants.ADMIN_REQUESTING_ENTITY);
        FaultDetectionFlexContainer createdFlexContainer = null;
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.CREATED)) {
            this.createTestReport("testCreateFaultDetectionFlexContainer", TestReport.Status.KO, "unable to create FaultDetectionFlexContainer", null);
            return;
        }
        createdFlexContainer = (FaultDetectionFlexContainer)response.getContent();
        if (!flexContainerName.equals(createdFlexContainer.getName())) {
            this.createTestReport("testCreateFaultDetectionFlexContainer", TestReport.Status.KO, "resource name are differents(expected:" + flexContainerName + ", found:" + createdFlexContainer.getName() + ")", null);
            return;
        }
        try {
            this.checkFlexContainerCustomAttribute((AbstractFlexContainer)flexContainer, (AbstractFlexContainer)createdFlexContainer);
        }
        catch (Exception e) {
            this.createTestReport("testCreateFaultDetectionFlexContainer", TestReport.Status.KO, "custom attributes are differents(expected:" + flexContainer.getCustomAttributes() + ", found:" + createdFlexContainer.getCustomAttributes() + ")", e);
            return;
        }
        try {
            this.checkFlexContainerCreator((AbstractFlexContainer)flexContainer, (AbstractFlexContainer)createdFlexContainer);
        }
        catch (Exception e) {
            this.createTestReport("testCreateFaultDetectionFlexContainer", TestReport.Status.KO, "creator are differents(expected:" + flexContainer.getCreator() + ", found:" + createdFlexContainer.getCreator() + ")", e);
            return;
        }
        try {
            this.checkFlexContainerDefinition((AbstractFlexContainer)flexContainer, (AbstractFlexContainer)createdFlexContainer);
        }
        catch (Exception e) {
            this.createTestReport("testCreateFaultDetectionFlexContainer", TestReport.Status.KO, "containerDefinition are differents(expected:" + flexContainer.getContainerDefinition() + ", found:" + createdFlexContainer.getContainerDefinition() + ")", e);
            return;
        }
        try {
            this.checkFlexContainerOntologyRef((AbstractFlexContainer)flexContainer, (AbstractFlexContainer)createdFlexContainer);
        }
        catch (Exception e) {
            this.createTestReport("testCreateFaultDetectionFlexContainer", TestReport.Status.KO, "ontologyRef are differents(expected:" + flexContainer.getOntologyRef() + ", found:" + createdFlexContainer.getOntologyRef() + ")", e);
            return;
        }
        response = this.sendRetrieveRequest(flexContainerLocation);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.OK)) {
            this.createTestReport("testCreateFaultDetectionFlexContainer", TestReport.Status.KO, "unable to retrieve the FlexContainer", null);
            return;
        }
        FaultDetectionFlexContainer retrievedFlexContainer = (FaultDetectionFlexContainer)response.getContent();
        try {
            this.checkFlexContainer((AbstractFlexContainer)createdFlexContainer, (AbstractFlexContainer)retrievedFlexContainer);
        }
        catch (Exception e) {
            this.createTestReport("testCreateFaultDetectionFlexContainer", TestReport.Status.KO, "flexContainers are differents: " + e.getMessage(), e);
            return;
        }
        this.createTestReport("testCreateFaultDetectionFlexContainer", TestReport.Status.OK, null, null);
    }

    public void testUpdateFaultDetectionFlexContainer() {
        String baseLocation = "/" + Constants.CSE_ID + "/" + Constants.CSE_NAME;
        String flexContainerName = "FaultDetectionFlexContainer_" + System.currentTimeMillis();
        String flexContainerLocation = String.valueOf(baseLocation) + "/" + flexContainerName;
        FaultDetectionFlexContainer flexContainer = new FaultDetectionFlexContainer();
        flexContainer.setName(flexContainerName);
        flexContainer.setOntologyRef("OrangeOntology");
        flexContainer.setCreator("Greg");
        CustomAttribute statusCustomAttribute = new CustomAttribute();
        statusCustomAttribute.setShortName("stats");
        statusCustomAttribute.setValue("false");
        flexContainer.getCustomAttributes().add(statusCustomAttribute);
        CustomAttribute codeCustomAttribute = new CustomAttribute();
        codeCustomAttribute.setShortName("code");
        codeCustomAttribute.setValue("123");
        flexContainer.getCustomAttributes().add(codeCustomAttribute);
        CustomAttribute descriptionCustomAttribute = new CustomAttribute();
        descriptionCustomAttribute.setShortName("descn");
        descriptionCustomAttribute.setValue("My description");
        flexContainer.getCustomAttributes().add(descriptionCustomAttribute);
        ResponsePrimitive response = this.sendCreateFlexContainerRequest((AbstractFlexContainer)flexContainer, baseLocation, Constants.ADMIN_REQUESTING_ENTITY);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.CREATED)) {
            this.createTestReport("testUpdateFaultDetectionFlexContainer", TestReport.Status.KO, "unable to create FaultDetectionFlexContainer", null);
            return;
        }
        FaultDetectionFlexContainer flexContainerToBeUpdated = new FaultDetectionFlexContainer();
        CustomAttribute statusCustomAttributeToBeUpdated = new CustomAttribute();
        statusCustomAttributeToBeUpdated.setShortName("stats");
        statusCustomAttributeToBeUpdated.setValue("true");
        flexContainerToBeUpdated.getCustomAttributes().add(statusCustomAttributeToBeUpdated);
        response = this.sendUpdateFlexContainerRequest(flexContainerLocation, (AbstractFlexContainer)flexContainerToBeUpdated);
        FaultDetectionFlexContainer updatedFlexContainer = null;
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.UPDATED)) {
            this.createTestReport("testUpdateFaultDetectionFlexContainer", TestReport.Status.KO, "unable to update FaultDetectionFlexContainer", null);
            return;
        }
        updatedFlexContainer = (FaultDetectionFlexContainer)response.getContent();
        if (!updatedFlexContainer.getCustomAttribute("stats").getValue().equals("true")) {
            this.createTestReport("testUpdateFaultDetectionFlexContainer", TestReport.Status.KO, "expected \"true\" value for status custom attribute", null);
            return;
        }
        this.createTestReport("testUpdateFaultDetectionFlexContainer", TestReport.Status.OK, null, null);
    }

    public void testDeleteFaultDetectionFlexContainer() {
        String baseLocation = "/" + Constants.CSE_ID + "/" + Constants.CSE_NAME;
        String flexContainerName = "FaultDetectionFlexContainer_" + System.currentTimeMillis();
        String flexContainerLocation = String.valueOf(baseLocation) + "/" + flexContainerName;
        FaultDetectionFlexContainer flexContainer = new FaultDetectionFlexContainer();
        flexContainer.setName(flexContainerName);
        flexContainer.setOntologyRef("OrangeOntology");
        flexContainer.setCreator("Greg");
        CustomAttribute statusCustomAttribute = new CustomAttribute();
        statusCustomAttribute.setShortName("stats");
        statusCustomAttribute.setValue("false");
        flexContainer.getCustomAttributes().add(statusCustomAttribute);
        CustomAttribute codeCustomAttribute = new CustomAttribute();
        codeCustomAttribute.setShortName("code");
        codeCustomAttribute.setValue("123");
        flexContainer.getCustomAttributes().add(codeCustomAttribute);
        CustomAttribute descriptionCustomAttribute = new CustomAttribute();
        descriptionCustomAttribute.setShortName("descn");
        descriptionCustomAttribute.setValue("My description");
        flexContainer.getCustomAttributes().add(descriptionCustomAttribute);
        ResponsePrimitive response = this.sendCreateFlexContainerRequest((AbstractFlexContainer)flexContainer, baseLocation, Constants.ADMIN_REQUESTING_ENTITY);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.CREATED)) {
            this.createTestReport("testDeleteFaultDetectionFlexContainer", TestReport.Status.KO, "unable to create FaultDetectionFlexContainer", null);
            return;
        }
        response = this.sendRetrieveRequest(flexContainerLocation);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.OK)) {
            this.createTestReport("testDeleteFaultDetectionFlexContainer", TestReport.Status.KO, "unable to retrieve FaultDetectionFlexContainer", null);
            return;
        }
        response = this.sendDeleteRequest(flexContainerLocation);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.DELETED)) {
            this.createTestReport("testDeleteFaultDetectionFlexContainer", TestReport.Status.KO, "unable to delete FaultDetectionFlexContainer", null);
            return;
        }
        response = this.sendRetrieveRequest(flexContainerLocation);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.NOT_FOUND)) {
            this.createTestReport("testDeleteFaultDetectionFlexContainer", TestReport.Status.KO, "expected " + ResponseStatusCode.NOT_FOUND + ", found: " + response.getResponseStatusCode(), null);
            return;
        }
        this.createTestReport("testDeleteFaultDetectionFlexContainer", TestReport.Status.OK, null, null);
    }
}

