/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.ipe.sample.controller;

import java.math.BigInteger;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.resource.AE;
import org.eclipse.om2m.commons.resource.Container;
import org.eclipse.om2m.commons.resource.ContentInstance;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.ipe.sample.RequestSender;
import org.eclipse.om2m.ipe.sample.constants.SampleConstants;
import org.eclipse.om2m.ipe.sample.gui.GUI;
import org.eclipse.om2m.ipe.sample.model.Lamp;
import org.eclipse.om2m.ipe.sample.model.SampleModel;
import org.eclipse.om2m.ipe.sample.util.ObixUtil;

public class LifeCycleManager {
    private static Log LOGGER = LogFactory.getLog(LifeCycleManager.class);

    public static void start() {
        String lampId;
        HashMap<String, Lamp> lamps = new HashMap<String, Lamp>();
        int i = 0;
        while (i < 2) {
            lampId = "LAMP_" + i;
            lamps.put(lampId, new Lamp(lampId, false));
            ++i;
        }
        SampleModel.setModel(lamps);
        i = 0;
        while (i < 2) {
            lampId = "LAMP_" + i;
            LifeCycleManager.createLampResources(lampId, false, "sample");
            ++i;
        }
        LifeCycleManager.createLampAll("sample");
        if (SampleConstants.GUI) {
            GUI.init();
        }
    }

    public static void stop() {
        if (SampleConstants.GUI) {
            GUI.stop();
        }
    }

    private static void createLampResources(String appId, boolean initValue, String poa) {
        Container container = new Container();
        container.getLabels().add("lamp");
        container.setMaxNrOfInstances(BigInteger.valueOf(0L));
        AE ae = new AE();
        ae.setRequestReachability(Boolean.valueOf(true));
        ae.getPointOfAccess().add(poa);
        ae.setAppID(appId);
        ae.setName(appId);
        ResponsePrimitive response = RequestSender.createAE(ae);
        if (response.getResponseStatusCode().equals(ResponseStatusCode.CREATED)) {
            container = new Container();
            container.setMaxNrOfInstances(BigInteger.valueOf(10L));
            container.setName("DESCRIPTOR");
            LOGGER.info((Object)RequestSender.createContainer(response.getLocation(), container));
            container.setName("DATA");
            LOGGER.info((Object)RequestSender.createContainer(response.getLocation(), container));
            String content = ObixUtil.getDescriptorRep(SampleConstants.CSE_ID, appId, "DATA");
            ContentInstance contentInstance = new ContentInstance();
            contentInstance.setContent(content);
            contentInstance.setContentInfo("application/obix");
            RequestSender.createContentInstance(String.valueOf(SampleConstants.CSE_PREFIX) + "/" + appId + "/" + "DESCRIPTOR", contentInstance);
            content = ObixUtil.getStateRep(appId, initValue);
            contentInstance.setContent(content);
            RequestSender.createContentInstance(String.valueOf(SampleConstants.CSE_PREFIX) + "/" + appId + "/" + "DATA", contentInstance);
        }
    }

    private static void createLampAll(String poa) {
        AE ae = new AE();
        ae.setRequestReachability(Boolean.valueOf(true));
        ae.getPointOfAccess().add(poa);
        ae.setAppID("LAMP_ALL");
        ae.setName("LAMP_ALL");
        ResponsePrimitive response = RequestSender.createAE(ae);
        if (response.getResponseStatusCode().equals(ResponseStatusCode.CREATED)) {
            Container cnt = new Container();
            cnt.setMaxNrOfInstances(BigInteger.valueOf(10L));
            cnt.setName("DESCRIPTOR");
            RequestSender.createContainer(String.valueOf(SampleConstants.CSE_PREFIX) + "/" + "LAMP_ALL", cnt);
            ContentInstance cin = new ContentInstance();
            cin.setContent(ObixUtil.createLampAllDescriptor());
            cin.setContentInfo("application/obix");
            RequestSender.createContentInstance(String.valueOf(SampleConstants.CSE_PREFIX) + "/" + "LAMP_ALL" + "/" + "DESCRIPTOR", cin);
        }
    }
}

