/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.ipe.sample.sdt.model;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.sdt.exceptions.AccessException;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.exceptions.ModuleException;
import org.eclipse.om2m.sdt.home.devices.Light;
import org.eclipse.om2m.sdt.home.modules.Colour;

public class SampleModel {
    private static Log logger = LogFactory.getLog(SampleModel.class);
    private static Map<String, Light> LAMPS = new HashMap<String, Light>();

    private SampleModel() {
    }

    public static void setLampState(String lampId, boolean value) throws DataPointException, AccessException {
        Light light = SampleModel.getLamp(lampId);
        try {
            light.getBinarySwitch().setPowerState(value);
        }
        catch (ModuleException e) {
            throw new DataPointException((Throwable)e);
        }
    }

    public static boolean getLampValue(String lampId) throws DataPointException, AccessException {
        try {
            return SampleModel.getLamp(lampId).getBinarySwitch().getPowerState();
        }
        catch (ModuleException e) {
            throw new DataPointException((Throwable)e);
        }
    }

    public static void setColor(int red, int green, int blue) throws DataPointException, AccessException {
        logger.info((Object)("Set RGB " + red + " " + green + " " + blue));
        for (Light light : LAMPS.values()) {
            Colour color = light.getColour();
            color.setRed(red);
            color.setGreen(green);
            color.setBlue(blue);
        }
    }

    public static void setColor(String id, int red, int green, int blue) throws DataPointException, AccessException {
        logger.info((Object)("Set RGB " + red + " " + green + " " + blue));
        Light light = SampleModel.getLamp(id);
        Colour color = light.getColour();
        color.setRed(red);
        color.setGreen(green);
        color.setBlue(blue);
    }

    public static Light getLamp(String lampId) {
        Light ret = LAMPS.get(lampId);
        if (ret == null) {
            throw new IllegalAccessError("Unknow lamp id");
        }
        return ret;
    }

    public static void setModel(Map<String, Light> lamps) {
        LAMPS = lamps;
    }
}

