/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.driver;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Logger {
    private static Log LOG = LogFactory.getLog(Logger.class);
    private static final String PREFIX = "[ONEM2M.";
    private String protocol;

    public Logger(String protocol) {
        this.protocol = protocol;
    }

    public final void debug(String message) {
        LOG.debug((Object)this.createLogMsg(null, message));
    }

    public final void debug(String message, Class<?> clazz) {
        LOG.debug((Object)this.createLogMsg(clazz, message));
    }

    public final void info(String message) {
        LOG.info((Object)this.createLogMsg(null, message));
    }

    public final void info(String message, Class<?> clazz) {
        LOG.info((Object)this.createLogMsg(clazz, message));
    }

    public final void warning(String message) {
        LOG.warn((Object)this.createLogMsg(null, message));
    }

    public final void warning(String message, Throwable e) {
        LOG.warn((Object)this.createLogMsg(null, message), e);
    }

    public final void warning(String message, Class<?> clazz) {
        LOG.warn((Object)this.createLogMsg(clazz, message));
    }

    public final void warning(String message, Class<?> clazz, Throwable e) {
        LOG.warn((Object)this.createLogMsg(clazz, message), e);
    }

    public final void error(String message) {
        LOG.error((Object)this.createLogMsg(null, message));
    }

    public final void error(String message, Throwable e) {
        LOG.error((Object)this.createLogMsg(null, message), e);
    }

    public final void error(String message, Class<?> clazz) {
        LOG.error((Object)this.createLogMsg(clazz, message));
    }

    public final void error(String message, Class<?> clazz, Throwable e) {
        LOG.error((Object)this.createLogMsg(clazz, message), e);
    }

    private final String createLogMsg(Class<?> clazz, String message) {
        return PREFIX + this.protocol + (clazz == null ? "] " : "." + clazz.getSimpleName() + "] ") + message;
    }

    public <LogService> void setLogService(LogService log) {
    }

    public void unsetLogService() {
    }
}

