/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.modules;

import java.util.Map;
import org.eclipse.om2m.sdt.DataPoint;
import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.Identifiers;
import org.eclipse.om2m.sdt.Module;
import org.eclipse.om2m.sdt.datapoints.IntegerDataPoint;
import org.eclipse.om2m.sdt.exceptions.AccessException;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.home.types.DatapointType;
import org.eclipse.om2m.sdt.home.types.ModuleType;

public class Brightness
extends Module {
    private IntegerDataPoint brightness;

    public Brightness(String name, Domain domain, IntegerDataPoint brightness) {
        super(name, domain, (Identifiers)ModuleType.brightness);
        if (brightness == null || !brightness.getShortName().equals(DatapointType.brightness.getShortName())) {
            domain.removeModule(this.getName());
            throw new IllegalArgumentException("Wrong brightness datapoint: " + brightness);
        }
        this.brightness = brightness;
        this.brightness.setDoc("Current sensed or set value for Brightness");
        this.addDataPoint((DataPoint)this.brightness);
    }

    public Brightness(String name, Domain domain, Map<String, DataPoint> dps) {
        this(name, domain, (IntegerDataPoint)dps.get(DatapointType.brightness.getShortName()));
    }

    public int getBrightness() throws DataPointException, AccessException {
        return (Integer)this.brightness.getValue();
    }

    public void setBrightness(int v) throws DataPointException, AccessException {
        this.brightness.setValue((Object)v);
    }
}

