/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.hue.impl.controller;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.om2m.hue.api.types.HueException;
import org.eclipse.om2m.hue.api.types.LightState;
import org.eclipse.om2m.hue.api.types.UnknownHueGatewayException;
import org.eclipse.om2m.hue.impl.controller.Light;
import org.eclipse.om2m.hue.impl.controller.PHDevice;
import org.json.simple.JSONObject;

public class LightGroup
extends PHDevice {
    private List<Light> lights = new ArrayList<Light>();

    public LightGroup(String IP, String usr, String id, String name) {
        super(IP, usr, id, name);
    }

    public void addLight(Light l) {
        this.lights.add(l);
    }

    public void setLightList(List<Light> l) {
        this.lights = l;
    }

    public void removeLight(Light l) {
        this.lights.remove(l);
    }

    public void removeLightById(String id) {
        Iterator<Light> it = this.lights.iterator();
        while (it.hasNext()) {
            Light l = it.next();
            if (!l.getId().equals(id)) continue;
            it.remove();
            return;
        }
    }

    public void removeLightByName(String name) {
        Iterator<Light> it = this.lights.iterator();
        while (it.hasNext()) {
            Light l = it.next();
            if (!l.getName().equals(name)) continue;
            it.remove();
            return;
        }
    }

    public List<Light> getLights() {
        return this.lights;
    }

    public Light getLightById(String id) throws HueException {
        for (Light l : this.lights) {
            if (!l.getId().equals(id)) continue;
            return l;
        }
        throw new HueException("Not found Light element for id : " + id);
    }

    public Light getLightByName(String name) throws HueException {
        for (Light l : this.lights) {
            if (!l.getName().equals(name)) continue;
            return l;
        }
        throw new HueException("Not found Light element for name : " + name);
    }

    public void setState(LightState ls) throws HueException, UnknownHueGatewayException {
        JSONObject state = this.setStateObject(ls);
        String resp = this.sendPutRequest("groups/" + this.id + "/" + "action", state.toString());
        if (resp.substring(3, 8).equals("error")) {
            throw new HueException("ERROR while setting group light state for group : " + this.name + ", id : " + this.id + "\n\t" + resp);
        }
    }

    public LightState getLastStateAction() throws HueException, UnknownHueGatewayException {
        String resp = this.sendGetRequest("groups/" + this.id);
        if (resp.substring(3, 8).equals("error")) {
            throw new HueException("ERROR while geting last group state action for group : " + this.name + ", id : " + this.id + "\n\t" + resp);
        }
        return this.getState(resp, "action");
    }

    public String toString() {
        String s = "<LightGroup id=" + this.id + " name=" + this.name + " gateway_IP=" + this.IP + " user_name=" + this.userName + ">";
        for (Light l : this.lights) {
            s = String.valueOf(s) + "\n\t" + l;
        }
        return String.valueOf(s) + "</LightGroup>";
    }
}

