/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.testsuite.flexcontainer;

import org.eclipse.om2m.commons.constants.Constants;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.resource.AbstractFlexContainer;
import org.eclipse.om2m.commons.resource.CustomAttribute;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.commons.resource.flexcontainerspec.WaterSensorFlexContainer;
import org.eclipse.om2m.core.service.CseService;
import org.eclipse.om2m.testsuite.flexcontainer.FlexContainerTestSuite;
import org.eclipse.om2m.testsuite.flexcontainer.TestReport;

public class WaterSensorFlexContainerTest
extends FlexContainerTestSuite {
    public WaterSensorFlexContainerTest(CseService pCseService) {
        super(pCseService);
    }

    @Override
    protected String getTestSuiteName() {
        return "WaterSensorFlexContainerTest";
    }

    public void testCreateAndRetrieveWaterSensorFlexContainer() {
        String baseLocation = "/" + Constants.CSE_ID + "/" + Constants.CSE_NAME;
        String flexContainerName = "WaterSensorFlexContainer_" + System.currentTimeMillis();
        String flexContainerLocation = String.valueOf(baseLocation) + "/" + flexContainerName;
        WaterSensorFlexContainer flexContainer = new WaterSensorFlexContainer();
        flexContainer.setName(flexContainerName);
        flexContainer.setCreator("Greg");
        flexContainer.setOntologyRef("OntologyOrange");
        CustomAttribute alarmCustomAttribute = new CustomAttribute();
        alarmCustomAttribute.setCustomAttributeName("alarm");
        alarmCustomAttribute.setCustomAttributeValue("true");
        flexContainer.getCustomAttributes().add(alarmCustomAttribute);
        ResponsePrimitive response = this.sendCreateFlexContainerRequest((AbstractFlexContainer)flexContainer, baseLocation, Constants.ADMIN_REQUESTING_ENTITY);
        WaterSensorFlexContainer createdFlexContainer = null;
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.CREATED)) {
            this.createTestReport("testCreateAndRetrieveWaterSensorFlexContainer", TestReport.Status.KO, "unable to create WaterSensor flexContainer:" + response.getContent(), null);
            return;
        }
        createdFlexContainer = (WaterSensorFlexContainer)response.getContent();
        if (!flexContainerName.equals(createdFlexContainer.getName())) {
            this.createTestReport("testCreateAndRetrieveWaterSensorFlexContainer", TestReport.Status.KO, "invalid name. Expecting" + flexContainerName + ", found:" + createdFlexContainer.getName(), null);
            return;
        }
        try {
            this.checkFlexContainerCreator((AbstractFlexContainer)flexContainer, (AbstractFlexContainer)createdFlexContainer);
            this.checkFlexContainerCustomAttribute((AbstractFlexContainer)flexContainer, (AbstractFlexContainer)createdFlexContainer);
            this.checkFlexContainerDefinition((AbstractFlexContainer)flexContainer, (AbstractFlexContainer)createdFlexContainer);
            this.checkFlexContainerOntologyRef((AbstractFlexContainer)flexContainer, (AbstractFlexContainer)createdFlexContainer);
        }
        catch (Exception e) {
            this.createTestReport("testCreateAndRetrieveWaterSensorFlexContainer", TestReport.Status.KO, e.getMessage(), e);
            return;
        }
        response = this.sendRetrieveRequest(flexContainerLocation);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.OK)) {
            this.createTestReport("testCreateAndRetrieveWaterSensorFlexContainer", TestReport.Status.KO, "unable to retrieve WaterSensor flexContainer:" + response.getContent(), null);
            return;
        }
        WaterSensorFlexContainer retrievedFlexContainer = (WaterSensorFlexContainer)response.getContent();
        try {
            this.checkFlexContainer((AbstractFlexContainer)createdFlexContainer, (AbstractFlexContainer)retrievedFlexContainer);
        }
        catch (Exception e) {
            this.createTestReport("testCreateAndRetrieveWaterSensorFlexContainer", TestReport.Status.KO, e.getMessage(), e);
            return;
        }
        this.createTestReport("testCreateAndRetrieveWaterSensorFlexContainer", TestReport.Status.OK, null, null);
    }

    public void testDeleteWaterSensorFlexContainer() {
        String baseLocation = "/" + Constants.CSE_ID + "/" + Constants.CSE_NAME;
        String flexContainerName = "WaterSensorFlexContainer_" + System.currentTimeMillis();
        String flexContainerLocation = String.valueOf(baseLocation) + "/" + flexContainerName;
        WaterSensorFlexContainer flexContainer = new WaterSensorFlexContainer();
        flexContainer.setName(flexContainerName);
        flexContainer.setCreator("Greg");
        flexContainer.setOntologyRef("OntologyOrange");
        CustomAttribute alarmCustomAttribute = new CustomAttribute();
        alarmCustomAttribute.setCustomAttributeName("alarm");
        alarmCustomAttribute.setCustomAttributeValue("true");
        flexContainer.getCustomAttributes().add(alarmCustomAttribute);
        ResponsePrimitive response = this.sendCreateFlexContainerRequest((AbstractFlexContainer)flexContainer, baseLocation, Constants.ADMIN_REQUESTING_ENTITY);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.CREATED)) {
            this.createTestReport("testDeleteWaterSensorFlexContainer", TestReport.Status.KO, "unable to create WaterSensor flexContainer:" + response.getContent(), null);
            return;
        }
        response = this.sendDeleteRequest(flexContainerLocation);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.DELETED)) {
            this.createTestReport("testDeleteWaterSensorFlexContainer", TestReport.Status.KO, "unable to delete WaterSensor flexContainer:" + response.getContent(), null);
            return;
        }
        response = this.sendRetrieveRequest(flexContainerLocation);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.NOT_FOUND)) {
            this.createTestReport("testDeleteWaterSensorFlexContainer", TestReport.Status.KO, "Expecting :" + ResponseStatusCode.NOT_FOUND + ", found: " + response.getResponseStatusCode(), null);
            return;
        }
        this.createTestReport("testDeleteWaterSensorFlexContainer", TestReport.Status.OK, null, null);
    }

    public void testUpdateWaterSensorFlexContainer() {
        String baseLocation = "/" + Constants.CSE_ID + "/" + Constants.CSE_NAME;
        String flexContainerName = "WaterSensorFlexContainer_" + System.currentTimeMillis();
        String flexContainerLocation = String.valueOf(baseLocation) + "/" + flexContainerName;
        WaterSensorFlexContainer flexContainer = new WaterSensorFlexContainer();
        flexContainer.setName(flexContainerName);
        flexContainer.setCreator("Greg");
        flexContainer.setOntologyRef("OntologyOrange");
        CustomAttribute alarmCustomAttribute = new CustomAttribute();
        alarmCustomAttribute.setCustomAttributeName("alarm");
        alarmCustomAttribute.setCustomAttributeValue("true");
        flexContainer.getCustomAttributes().add(alarmCustomAttribute);
        ResponsePrimitive response = this.sendCreateFlexContainerRequest((AbstractFlexContainer)flexContainer, baseLocation, Constants.ADMIN_REQUESTING_ENTITY);
        WaterSensorFlexContainer createdFlexContainer = null;
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.CREATED)) {
            this.createTestReport("testUpdateWaterSensorFlexContainer", TestReport.Status.KO, "unable to create WaterSensor flexContainer:" + response.getContent(), null);
            return;
        }
        createdFlexContainer = (WaterSensorFlexContainer)response.getContent();
        WaterSensorFlexContainer toBeUpdated = new WaterSensorFlexContainer();
        CustomAttribute alarmToBeUpdated = new CustomAttribute();
        alarmToBeUpdated.setCustomAttributeName("alarm");
        alarmToBeUpdated.setCustomAttributeValue("false");
        toBeUpdated.getCustomAttributes().add(alarmToBeUpdated);
        response = this.sendUpdateFlexContainerRequest(flexContainerLocation, (AbstractFlexContainer)toBeUpdated);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.UPDATED)) {
            this.createTestReport("testUpdateWaterSensorFlexContainer", TestReport.Status.KO, "unable to update WaterSensor flexContainer:" + response.getContent(), null);
            return;
        }
        WaterSensorFlexContainer updatedFlexContainer = (WaterSensorFlexContainer)response.getContent();
        if (updatedFlexContainer.getCustomAttributes().size() != 1) {
            this.createTestReport("testUpdateWaterSensorFlexContainer", TestReport.Status.KO, "Expecting 1 customAttribute, found " + updatedFlexContainer.getCustomAttributes().size() + " customAttributes", null);
            return;
        }
        if (!alarmToBeUpdated.getCustomAttributeValue().equals(updatedFlexContainer.getCustomAttribute("alarm").getCustomAttributeValue())) {
            this.createTestReport("testUpdateWaterSensorFlexContainer", TestReport.Status.KO, "Wrong alarm customAttribute value. Expecting:" + alarmToBeUpdated.getCustomAttributeValue() + ", found:" + updatedFlexContainer.getCustomAttribute("alarm").getCustomAttributeValue(), null);
            return;
        }
        response = this.sendRetrieveRequest(flexContainerLocation);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.OK)) {
            this.createTestReport("testUpdateWaterSensorFlexContainer", TestReport.Status.KO, "unable to retrieve WaterSensor flexContainer:" + response.getContent(), null);
            return;
        }
        WaterSensorFlexContainer retrievedFlexContainer = (WaterSensorFlexContainer)response.getContent();
        createdFlexContainer.getCustomAttribute("alarm").setCustomAttributeValue("false");
        try {
            this.checkFlexContainer((AbstractFlexContainer)createdFlexContainer, (AbstractFlexContainer)retrievedFlexContainer);
        }
        catch (Exception e) {
            this.createTestReport("testUpdateWaterSensorFlexContainer", TestReport.Status.KO, e.getMessage(), e);
            return;
        }
        this.createTestReport("testUpdateWaterSensorFlexContainer", TestReport.Status.OK, null, null);
    }
}

