/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.comm.http;

import javax.servlet.Servlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.comm.http.RestHttpClient;
import org.eclipse.om2m.comm.http.RestHttpServlet;
import org.eclipse.om2m.comm.service.RestClientService;
import org.eclipse.om2m.core.service.SclService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpService;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    private static Log LOGGER = LogFactory.getLog(Activator.class);
    private ServiceTracker<Object, Object> httpServiceTracker;
    private ServiceTracker<Object, Object> sclServiceTracker;
    private static final String SCL_BASE_CONTEXT = System.getProperty("org.eclipse.om2m.sclBaseContext", "/om2m");

    public void start(BundleContext bundleContext) throws Exception {
        LOGGER.info((Object)"Register HTTP RestClientService..");
        bundleContext.registerService(RestClientService.class.getName(), (Object)new RestHttpClient(), null);
        LOGGER.info((Object)"HTTP RestClientService is registered.");
        this.httpServiceTracker = new ServiceTracker<Object, Object>(bundleContext, HttpService.class.getName(), null){

            public void removedService(ServiceReference<Object> reference, Object service) {
                LOGGER.info((Object)"HttpService removed");
                try {
                    LOGGER.info((Object)("Unregister " + SCL_BASE_CONTEXT + " http context"));
                    ((HttpService)service).unregister(SCL_BASE_CONTEXT);
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error((Object)"Error unregistring SclServlet", (Throwable)e);
                }
            }

            public Object addingService(ServiceReference<Object> reference) {
                LOGGER.info((Object)"HttpService discovered");
                HttpService httpService = (HttpService)this.context.getService(reference);
                try {
                    LOGGER.info((Object)("Register " + SCL_BASE_CONTEXT + " context"));
                    httpService.registerServlet(SCL_BASE_CONTEXT, (Servlet)new RestHttpServlet(), null, null);
                }
                catch (Exception e) {
                    LOGGER.error((Object)"Error registering SclServlet", (Throwable)e);
                }
                return httpService;
            }
        };
        this.httpServiceTracker.open();
        this.sclServiceTracker = new ServiceTracker<Object, Object>(bundleContext, SclService.class.getName(), null){

            public void removedService(ServiceReference<Object> reference, Object service) {
                LOGGER.info((Object)"SclService removed");
                try {
                    RestHttpServlet.setScl((SclService)service);
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error((Object)"Error removing SclService", (Throwable)e);
                }
            }

            public Object addingService(ServiceReference<Object> reference) {
                LOGGER.info((Object)"SclService discovered");
                SclService scl = (SclService)this.context.getService(reference);
                try {
                    RestHttpServlet.setScl(scl);
                }
                catch (Exception e) {
                    LOGGER.error((Object)"Error adding SclService", (Throwable)e);
                }
                return scl;
            }
        };
        this.sclServiceTracker.open();
    }

    public void stop(BundleContext bundleContext) throws Exception {
    }
}

