/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.dao;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.eclipse.om2m.commons.resource.ContentInstance;
import org.eclipse.om2m.commons.resource.ContentInstances;
import org.eclipse.om2m.commons.resource.Subscriptions;
import org.eclipse.om2m.core.dao.DAO;
import org.eclipse.om2m.core.dao.DAOFactory;
import org.eclipse.om2m.core.dao.DBUtil;

public class ContentInstancesDAO
extends DAO<ContentInstances> {
    @Override
    public ContentInstances find(String uri, EntityManager em) {
        ContentInstances contentInstances = (ContentInstances)em.find(ContentInstances.class, (Object)uri);
        if (contentInstances != null) {
            contentInstances.getContentInstanceCollection().getContentInstance().clear();
            String q = DBUtil.generateLikeRequestOrderByCreationTime("CONTENTINSTANCE", uri);
            Query query = em.createQuery(q);
            List result = query.getResultList();
            for (ContentInstance contentInstance : result) {
                contentInstances.getContentInstanceCollection().getContentInstance().add(contentInstance);
            }
        }
        return contentInstances;
    }

    @Override
    public void delete(ContentInstances resource, EntityManager em) {
        Subscriptions subscriptions = new Subscriptions();
        subscriptions.setUri(resource.getSubscriptionsReference());
        DAOFactory.getSubscriptionsDAO().delete(subscriptions, em);
        String q = DBUtil.generateLikeRequest("CONTENTINSTANCE", resource.getUri());
        Query query = em.createQuery(q);
        List result = query.getResultList();
        for (ContentInstance contentInstance : result) {
            DAOFactory.getContentInstanceDAO().delete(contentInstance, em);
        }
        em.remove((Object)resource);
    }
}

