/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.controller;

import java.util.Date;
import javax.persistence.EntityManager;
import org.eclipse.om2m.commons.resource.ErrorInfo;
import org.eclipse.om2m.commons.resource.OnlineStatus;
import org.eclipse.om2m.commons.resource.Resource;
import org.eclipse.om2m.commons.resource.Scl;
import org.eclipse.om2m.commons.resource.StatusCode;
import org.eclipse.om2m.commons.rest.RequestIndication;
import org.eclipse.om2m.commons.rest.ResponseConfirm;
import org.eclipse.om2m.commons.utils.DateConverter;
import org.eclipse.om2m.commons.utils.XmlMapper;
import org.eclipse.om2m.core.controller.Controller;
import org.eclipse.om2m.core.dao.DAOFactory;
import org.eclipse.om2m.core.dao.DBAccess;
import org.eclipse.om2m.core.notifier.Notifier;

public class SclController
extends Controller {
    @Override
    public ResponseConfirm doCreate(RequestIndication requestIndication) {
        ResponseConfirm errorResponse = new ResponseConfirm();
        EntityManager em = DBAccess.createEntityManager();
        em.getTransaction().begin();
        String accessRightID = this.getAccessRightId(requestIndication.getTargetID(), em);
        if (accessRightID == null) {
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_FOUND, String.valueOf(requestIndication.getTargetID()) + " does not exist"));
        }
        errorResponse = this.checkAccessRight(accessRightID, requestIndication.getRequestingEntity(), "CREATE");
        if (errorResponse != null) {
            em.close();
            return errorResponse;
        }
        if (requestIndication.getRepresentation() == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Resource Representation is EMPTY"));
        }
        Scl scl = null;
        try {
            scl = (Scl)XmlMapper.getInstance().xmlToObject(requestIndication.getRepresentation());
        }
        catch (ClassCastException e) {
            em.close();
            LOGGER.debug((Object)"ClassCastException : Incorrect resource type in JAXB unmarshalling.", (Throwable)e);
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Incorrect resource type"));
        }
        if (scl == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Incorrect resource representation syntax"));
        }
        if (scl.getSclId() == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, " sclId is Mandatory"));
        }
        if (!scl.getSclId().matches("^[A-Za-z0-9_-]*$")) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "sclId should match the following regexpr: ^[A-Za-z0-9_-]*$"));
        }
        if (DAOFactory.getSclDAO().find(String.valueOf(requestIndication.getTargetID()) + "/" + scl.getSclId(), em) != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_CONFLICT, "SclId Conflit"));
        }
        if (scl.getExpirationTime() != null && !this.checkExpirationTime(scl.getExpirationTime())) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Expiration Time CREATE is Out of Date"));
        }
        if (scl.getCreationTime() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Creation Time CREATE is Not Permitted"));
        }
        if (scl.getLastModifiedTime() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Last Modified Time CREATE is Not Permitted"));
        }
        if (scl.getContainersReference() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Containers Reference is not permitted"));
        }
        if (scl.getGroupsReference() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Groups Reference is not permitted"));
        }
        if (scl.getApplicationsReference() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Applications Reference is not permitted"));
        }
        if (scl.getAccessRightsReference() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "AccessRights Reference is not permitted"));
        }
        if (scl.getSubscriptionsReference() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Subscriptions Reference is not permitted"));
        }
        if (scl.getMgmtObjsReference() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "MgmtObjs Reference is not permitted"));
        }
        if (scl.getNotificationChannelsReference() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "NotificationChannels Reference is not permitted"));
        }
        if (scl.getM2MPocsReference() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "M2MPocs Reference is not permitted"));
        }
        if (scl.getAttachedDevicesReference() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "AttachedDevices Reference is not permitted"));
        }
        if (scl.getOnlineStatus() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "OnLineStatus is not permitted"));
        }
        if (scl.isServerCapability() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "ServerCapability is not permitted"));
        }
        if (scl.getLink() == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Link attribute is mandatory"));
        }
        if (scl.getMgmtProtocolType() == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "MgmtProtocol attribute is mandatory"));
        }
        if (scl.getAPocHandling() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "aPocHandling is not permitted"));
        }
        scl.setUri(String.valueOf(requestIndication.getTargetID()) + "/" + scl.getSclId());
        if (scl.getExpirationTime() == null) {
            scl.setExpirationTime(this.getNewExpirationTime(999999999L));
        }
        if (DAOFactory.getAccessRightDAO().find(scl.getAccessRightID(), em) == null) {
            scl.setAccessRightID(accessRightID);
        }
        if (scl.getSearchStrings() == null) {
            scl.setSearchStrings(SclController.generateSearchStrings(scl.getClass().getSimpleName(), scl.getSclId()));
        }
        scl.setOnlineStatus(OnlineStatus.ONLINE);
        scl.setServerCapability(Boolean.valueOf(true));
        scl.setContainersReference(String.valueOf(scl.getUri()) + "/containers");
        scl.setGroupsReference(String.valueOf(scl.getUri()) + "/groups");
        scl.setApplicationsReference(String.valueOf(scl.getUri()) + "/applications");
        scl.setAccessRightsReference(String.valueOf(scl.getUri()) + "/accessRights");
        scl.setSubscriptionsReference(String.valueOf(scl.getUri()) + "/subscriptions");
        scl.setMgmtObjsReference(String.valueOf(scl.getUri()) + "/mgmtObjs");
        scl.setNotificationChannelsReference(String.valueOf(scl.getUri()) + "/notificationChannels");
        scl.setM2MPocsReference(String.valueOf(scl.getUri()) + "/m2mPocs");
        scl.setAttachedDevicesReference(String.valueOf(scl.getUri()) + "/attachedDevices");
        scl.setCreationTime(DateConverter.toXMLGregorianCalendar((Date)new Date()).toString());
        scl.setLastModifiedTime(DateConverter.toXMLGregorianCalendar((Date)new Date()).toString());
        Notifier.notify(StatusCode.STATUS_CREATED, (Resource)scl);
        DAOFactory.getSclDAO().create(scl, em);
        em.getTransaction().commit();
        em.close();
        return new ResponseConfirm(StatusCode.STATUS_CREATED, (Resource)scl);
    }

    @Override
    public ResponseConfirm doRetrieve(RequestIndication requestIndication) {
        ResponseConfirm errorResponse = new ResponseConfirm();
        EntityManager em = DBAccess.createEntityManager();
        em.getTransaction().begin();
        Scl scl = DAOFactory.getSclDAO().find(requestIndication.getTargetID(), em);
        em.close();
        if (scl == null) {
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_FOUND, String.valueOf(requestIndication.getTargetID()) + " does not exist in DataBase"));
        }
        errorResponse = this.checkAccessRight(scl.getAccessRightID(), requestIndication.getRequestingEntity(), "READ");
        if (errorResponse != null) {
            return errorResponse;
        }
        scl.setContainersReference(String.valueOf(scl.getUri()) + "/containers");
        scl.setGroupsReference(String.valueOf(scl.getUri()) + "/groups");
        scl.setApplicationsReference(String.valueOf(scl.getUri()) + "/applications");
        scl.setAccessRightsReference(String.valueOf(scl.getUri()) + "/accessRights");
        scl.setSubscriptionsReference(String.valueOf(scl.getUri()) + "/subscriptions");
        scl.setMgmtObjsReference(String.valueOf(scl.getUri()) + "/mgmtObjs");
        scl.setNotificationChannelsReference(String.valueOf(scl.getUri()) + "/notificationChannels");
        scl.setM2MPocsReference(String.valueOf(scl.getUri()) + "/m2mPocs");
        scl.setAttachedDevicesReference(String.valueOf(scl.getUri()) + "/attachedDevices");
        return new ResponseConfirm(StatusCode.STATUS_OK, (Resource)scl);
    }

    @Override
    public ResponseConfirm doUpdate(RequestIndication requestIndication) {
        ResponseConfirm errorResponse = new ResponseConfirm();
        EntityManager em = DBAccess.createEntityManager();
        em.getTransaction().begin();
        Scl scl = DAOFactory.getSclDAO().find(requestIndication.getTargetID(), em);
        if (scl == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_FOUND, String.valueOf(requestIndication.getTargetID()) + " does not exist in DataBase"));
        }
        errorResponse = this.checkAccessRight(scl.getAccessRightID(), requestIndication.getRequestingEntity(), "WRITE");
        if (errorResponse != null) {
            em.close();
            return errorResponse;
        }
        if (requestIndication.getRepresentation() == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Resource Representation is EMPTY"));
        }
        Scl sclNew = null;
        try {
            sclNew = (Scl)XmlMapper.getInstance().xmlToObject(requestIndication.getRepresentation());
        }
        catch (ClassCastException e) {
            em.close();
            LOGGER.debug((Object)"ClassCastException : Incorrect resource type in JAXB unmarshalling.", (Throwable)e);
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Incorrect resource type"));
        }
        if (sclNew == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Incorrect resource representation syntax"));
        }
        if (sclNew.getSclId() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "SclId UPDATE is Not Permitted"));
        }
        if (sclNew.getExpirationTime() != null && !this.checkExpirationTime(sclNew.getExpirationTime())) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Expiration Time UPDATE is Out of Date"));
        }
        if (sclNew.getContainersReference() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Containers Reference UPDATE is Not Permitted"));
        }
        if (sclNew.getGroupsReference() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Groups Reference UPDATE is Not Permitted"));
        }
        if (sclNew.getApplicationsReference() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Applications Reference UPDATE is Not Permitted"));
        }
        if (sclNew.getAccessRightsReference() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "AccessRights Reference UPDATE is Not Permitted"));
        }
        if (sclNew.getSubscriptionsReference() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Subscriptions Reference UPDATE is Not Permitted"));
        }
        if (sclNew.getMgmtObjsReference() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "MgmtObjs Reference UPDATE is Not Permitted"));
        }
        if (sclNew.getNotificationChannelsReference() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "NotificationChannels Reference UPDATE is Not Permitted"));
        }
        if (sclNew.getM2MPocsReference() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "M2MPocs Reference UPDATE is Not Permitted"));
        }
        if (sclNew.getAttachedDevicesReference() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "AttachedDevices Reference UPDATE is Not Permitted"));
        }
        if (sclNew.getOnlineStatus() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "OnLineStatus attribute UPDATE is Not Permitted"));
        }
        if (sclNew.isServerCapability() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "ServerCapability attrivute UPDATE is Not Permitted"));
        }
        if (sclNew.getLink() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Link attribute UPDATE is Not Permitted"));
        }
        if (sclNew.getMgmtProtocolType() == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "MgmtProtocolType attrivute UPDATE is Mandatory"));
        }
        if (sclNew.getCreationTime() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "CreationTime UPDATE is Not Permitted"));
        }
        if (sclNew.getLastModifiedTime() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "LatModifiedTime UPDATE is Not Permitted"));
        }
        if (sclNew.getAPocHandling() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "aPocHandling attribute UPDATE is Not Permitted"));
        }
        if (sclNew.getExpirationTime() != null) {
            scl.setExpirationTime(sclNew.getExpirationTime());
        }
        if (DAOFactory.getAccessRightDAO().find(sclNew.getAccessRightID(), em) != null) {
            scl.setAccessRightID(sclNew.getAccessRightID());
        }
        if (sclNew.getSearchStrings() != null) {
            scl.setSearchStrings(sclNew.getSearchStrings());
        }
        if (sclNew.getPocs() != null) {
            scl.setPocs(sclNew.getPocs());
        }
        if (sclNew.getRemTriggerAddr() != null) {
            scl.setRemTriggerAddr(sclNew.getRemTriggerAddr());
        }
        if (sclNew.getSchedule() != null) {
            scl.setSchedule(sclNew.getSchedule());
        }
        if (sclNew.getLocTargetDevice() != null) {
            scl.setLocTargetDevice(sclNew.getLocTargetDevice());
        }
        scl.setMgmtProtocolType(sclNew.getMgmtProtocolType());
        if (sclNew.getIntegrityValResults() != null) {
            scl.setIntegrityValResults(sclNew.getIntegrityValResults());
        }
        scl.setLastModifiedTime(DateConverter.toXMLGregorianCalendar((Date)new Date()).toString());
        Notifier.notify(StatusCode.STATUS_OK, (Resource)scl);
        DAOFactory.getSclDAO().update(scl, em);
        em.getTransaction().commit();
        em.close();
        scl.setContainersReference(String.valueOf(scl.getUri()) + "/containers");
        scl.setGroupsReference(String.valueOf(scl.getUri()) + "/groups");
        scl.setApplicationsReference(String.valueOf(scl.getUri()) + "/applications");
        scl.setAccessRightsReference(String.valueOf(scl.getUri()) + "/accessRights");
        scl.setSubscriptionsReference(String.valueOf(scl.getUri()) + "/subscriptions");
        scl.setMgmtObjsReference(String.valueOf(scl.getUri()) + "/mgmtObjs");
        scl.setNotificationChannelsReference(String.valueOf(scl.getUri()) + "/notificationChannels");
        scl.setM2MPocsReference(String.valueOf(scl.getUri()) + "/m2mPocs");
        scl.setAttachedDevicesReference(String.valueOf(scl.getUri()) + "/attachedDevices");
        return new ResponseConfirm(StatusCode.STATUS_OK, (Resource)scl);
    }

    @Override
    public ResponseConfirm doDelete(RequestIndication requestIndication) {
        ResponseConfirm errorResponse = new ResponseConfirm();
        EntityManager em = DBAccess.createEntityManager();
        em.getTransaction().begin();
        Scl scl = DAOFactory.getSclDAO().find(requestIndication.getTargetID(), em);
        if (scl == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_FOUND, String.valueOf(requestIndication.getTargetID()) + " does not exist"));
        }
        errorResponse = this.checkAccessRight(scl.getAccessRightID(), requestIndication.getRequestingEntity(), "DELETE");
        if (errorResponse != null) {
            em.close();
            return errorResponse;
        }
        Notifier.notify(StatusCode.STATUS_DELETED, (Resource)scl);
        DAOFactory.getSclDAO().delete(scl, em);
        em.getTransaction().commit();
        em.close();
        return new ResponseConfirm(StatusCode.STATUS_OK);
    }

    @Override
    public ResponseConfirm doExecute(RequestIndication requestIndication) {
        return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_IMPLEMENTED, String.valueOf(requestIndication.getMethod()) + " Method is not implemented"));
    }
}

