/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.controller;

import javax.persistence.EntityManager;
import org.eclipse.om2m.commons.resource.ErrorInfo;
import org.eclipse.om2m.commons.resource.GroupAnnc;
import org.eclipse.om2m.commons.resource.Resource;
import org.eclipse.om2m.commons.resource.StatusCode;
import org.eclipse.om2m.commons.rest.RequestIndication;
import org.eclipse.om2m.commons.rest.ResponseConfirm;
import org.eclipse.om2m.commons.utils.XmlMapper;
import org.eclipse.om2m.core.controller.Controller;
import org.eclipse.om2m.core.dao.DAOFactory;
import org.eclipse.om2m.core.dao.DBAccess;
import org.eclipse.om2m.core.notifier.Notifier;

public class GroupAnncController
extends Controller {
    @Override
    public ResponseConfirm doCreate(RequestIndication requestIndication) {
        ResponseConfirm errorResponse = new ResponseConfirm();
        EntityManager em = DBAccess.createEntityManager();
        em.getTransaction().begin();
        String accessRightID = this.getAccessRightId(requestIndication.getTargetID(), em);
        if (accessRightID == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_FOUND, String.valueOf(requestIndication.getTargetID()) + " does not exist"));
        }
        errorResponse = this.checkAccessRight(accessRightID, requestIndication.getRequestingEntity(), "CREATE");
        if (errorResponse != null) {
            em.close();
            return errorResponse;
        }
        if (requestIndication.getRepresentation() == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Resource Representation is EMPTY"));
        }
        GroupAnnc groupAnnc = null;
        try {
            groupAnnc = (GroupAnnc)XmlMapper.getInstance().xmlToObject(requestIndication.getRepresentation());
        }
        catch (ClassCastException e) {
            em.close();
            LOGGER.debug((Object)"ClassCastException : Incorrect resource type in JAXB unmarshalling.", (Throwable)e);
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Incorrect resource type"));
        }
        if (groupAnnc == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Incorrect resource representation syntax"));
        }
        if (groupAnnc.getId() != null && DAOFactory.getApplicationAnncDAO().find(String.valueOf(requestIndication.getTargetID()) + "/" + groupAnnc.getId(), em) != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_CONFLICT, "ApplicationAnncId Conflit"));
        }
        if (groupAnnc.getId() == null || groupAnnc.getId().isEmpty()) {
            groupAnnc.setId(GroupAnncController.generateId("GRP_", "Annc"));
        }
        if (groupAnnc.getSearchStrings() == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "searchStrings attribute CREATE is Mandatory"));
        }
        if (groupAnnc.getLink() == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Link attribute is Mandatory"));
        }
        if (groupAnnc.getExpirationTime() != null && !this.checkExpirationTime(groupAnnc.getExpirationTime())) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Expiration Time is Out of Date"));
        }
        groupAnnc.setUri(String.valueOf(requestIndication.getTargetID()) + "/" + groupAnnc.getId());
        if (groupAnnc.getExpirationTime() == null) {
            groupAnnc.setExpirationTime(this.getNewExpirationTime(999999999L));
        }
        if (DAOFactory.getAccessRightDAO().find(groupAnnc.getAccessRightID(), em) == null) {
            groupAnnc.setAccessRightID(accessRightID);
        }
        Notifier.notify(StatusCode.STATUS_CREATED, (Resource)groupAnnc);
        DAOFactory.getGroupAnncDAO().create(groupAnnc, em);
        em.getTransaction().commit();
        em.close();
        return new ResponseConfirm(StatusCode.STATUS_CREATED, (Resource)groupAnnc);
    }

    @Override
    public ResponseConfirm doRetrieve(RequestIndication requestIndication) {
        ResponseConfirm errorResponse = new ResponseConfirm();
        EntityManager em = DBAccess.createEntityManager();
        em.getTransaction().begin();
        GroupAnnc groupAnnc = DAOFactory.getGroupAnncDAO().find(requestIndication.getTargetID(), em);
        em.close();
        if (groupAnnc == null) {
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_FOUND, String.valueOf(requestIndication.getTargetID()) + " does not exist in DataBase"));
        }
        errorResponse = this.checkAccessRight(groupAnnc.getAccessRightID(), requestIndication.getRequestingEntity(), "READ");
        if (errorResponse != null) {
            return errorResponse;
        }
        return new ResponseConfirm(StatusCode.STATUS_OK, (Resource)groupAnnc);
    }

    @Override
    public ResponseConfirm doUpdate(RequestIndication requestIndication) {
        ResponseConfirm errorResponse = new ResponseConfirm();
        EntityManager em = DBAccess.createEntityManager();
        em.getTransaction().begin();
        GroupAnnc groupAnnc = DAOFactory.getGroupAnncDAO().find(requestIndication.getTargetID(), em);
        if (groupAnnc == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_FOUND, String.valueOf(requestIndication.getTargetID()) + " does not exist in DataBase"));
        }
        errorResponse = this.checkAccessRight(groupAnnc.getAccessRightID(), requestIndication.getRequestingEntity(), "WRITE");
        if (errorResponse != null) {
            em.close();
            return errorResponse;
        }
        if (requestIndication.getRepresentation() == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Resource Representation is EMPTY"));
        }
        GroupAnnc groupAnncNew = null;
        try {
            groupAnncNew = (GroupAnnc)XmlMapper.getInstance().xmlToObject(requestIndication.getRepresentation());
        }
        catch (ClassCastException e) {
            em.close();
            LOGGER.debug((Object)"ClassCastException : Incorrect resource type in JAXB unmarshalling.", (Throwable)e);
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Incorrect resource type"));
        }
        if (groupAnncNew == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Incorrect resource representation syntax"));
        }
        if (groupAnncNew.getId() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "GroupAnncId UPDATE is Not Permitted"));
        }
        if (groupAnncNew.getExpirationTime() != null && !this.checkExpirationTime(groupAnncNew.getExpirationTime())) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Expiration Time UPDATE is Out of Date"));
        }
        if (groupAnncNew.getLink() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Link attribute UPDATE is Mandatory"));
        }
        if (groupAnncNew.getSearchStrings() == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "searchStrings attribute UPDATE is Mandatory"));
        }
        if (groupAnncNew.getExpirationTime() != null) {
            groupAnnc.setExpirationTime(groupAnncNew.getExpirationTime());
        }
        if (DAOFactory.getAccessRightDAO().find(groupAnncNew.getAccessRightID(), em) != null) {
            groupAnnc.setAccessRightID(groupAnncNew.getAccessRightID());
        }
        groupAnnc.setSearchStrings(groupAnncNew.getSearchStrings());
        Notifier.notify(StatusCode.STATUS_OK, (Resource)groupAnnc);
        DAOFactory.getGroupAnncDAO().update(groupAnnc, em);
        em.getTransaction().commit();
        em.close();
        return new ResponseConfirm(StatusCode.STATUS_OK, (Resource)groupAnnc);
    }

    @Override
    public ResponseConfirm doDelete(RequestIndication requestIndication) {
        ResponseConfirm errorResponse = new ResponseConfirm();
        EntityManager em = DBAccess.createEntityManager();
        em.getTransaction().begin();
        GroupAnnc groupAnnc = DAOFactory.getGroupAnncDAO().find(requestIndication.getTargetID(), em);
        if (groupAnnc == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_FOUND, String.valueOf(requestIndication.getTargetID()) + " does not exist"));
        }
        errorResponse = this.checkAccessRight(groupAnnc.getAccessRightID(), requestIndication.getRequestingEntity(), "DELETE");
        if (errorResponse != null) {
            em.close();
            return errorResponse;
        }
        Notifier.notify(StatusCode.STATUS_DELETED, (Resource)groupAnnc);
        DAOFactory.getGroupAnncDAO().delete(groupAnnc, em);
        em.getTransaction().commit();
        em.close();
        return new ResponseConfirm(StatusCode.STATUS_OK);
    }

    @Override
    public ResponseConfirm doExecute(RequestIndication requestIndication) {
        return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_IMPLEMENTED, String.valueOf(requestIndication.getMethod()) + " Method is not yet Implemented"));
    }
}

