/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.controller;

import java.security.SecureRandom;
import java.util.Date;
import javax.persistence.EntityManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.commons.resource.AccessRight;
import org.eclipse.om2m.commons.resource.ErrorInfo;
import org.eclipse.om2m.commons.resource.PermissionFlagType;
import org.eclipse.om2m.commons.resource.PermissionListType;
import org.eclipse.om2m.commons.resource.PermissionType;
import org.eclipse.om2m.commons.resource.Resource;
import org.eclipse.om2m.commons.resource.SearchStrings;
import org.eclipse.om2m.commons.resource.StatusCode;
import org.eclipse.om2m.commons.rest.RequestIndication;
import org.eclipse.om2m.commons.rest.ResponseConfirm;
import org.eclipse.om2m.commons.utils.DateConverter;
import org.eclipse.om2m.core.dao.DAO;
import org.eclipse.om2m.core.dao.DAOFactory;
import org.eclipse.om2m.core.dao.DBAccess;
import org.eclipse.om2m.core.router.Patterns;

public abstract class Controller {
    protected static Log LOGGER = LogFactory.getLog(Controller.class);

    public abstract ResponseConfirm doCreate(RequestIndication var1);

    public abstract ResponseConfirm doRetrieve(RequestIndication var1);

    public abstract ResponseConfirm doUpdate(RequestIndication var1);

    public abstract ResponseConfirm doDelete(RequestIndication var1);

    public abstract ResponseConfirm doExecute(RequestIndication var1);

    public String getAccessRightId(String targetId, EntityManager em) {
        Resource parent = DAOFactory.getResourceDAO().find(targetId, em);
        String[] tabID = targetId.split("/");
        boolean stop = parent != null;
        while (!stop && tabID.length > 1) {
            String toRemove = tabID[tabID.length - 1];
            DAO dao = Patterns.getDAO(targetId = targetId.split("/" + toRemove)[0]);
            if (dao == null) {
                tabID = targetId.split("/");
                continue;
            }
            parent = DAOFactory.getResourceDAO().find(targetId, em);
            stop = true;
        }
        return parent.getAccessRightID();
    }

    public ResponseConfirm checkAccessRight(String accessRightID, String requestingEntity, String method) {
        boolean holderFound = false;
        boolean flagFound = false;
        EntityManager em = DBAccess.createEntityManager();
        em.getTransaction().begin();
        AccessRight accessRightFound = DAOFactory.getAccessRightDAO().find(accessRightID, em);
        em.close();
        if (accessRightFound == null) {
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_FOUND, "AccessRight for this resource is not found"));
        }
        if (accessRightFound != null) {
            PermissionListType permissions = accessRightFound.getPermissions();
            int j = 0;
            block0: while (j < permissions.getPermission().size()) {
                holderFound = false;
                PermissionType permission = (PermissionType)permissions.getPermission().get(j);
                int i = 0;
                while (i < permission.getPermissionHolders().getHolderRefs().getHolderRef().size()) {
                    String holder = (String)permission.getPermissionHolders().getHolderRefs().getHolderRef().get(i);
                    if (holder.equalsIgnoreCase(requestingEntity)) {
                        holderFound = true;
                        break;
                    }
                    ++i;
                }
                if (holderFound) {
                    int k = 0;
                    while (k < permission.getPermissionFlags().getFlag().size()) {
                        String flag = ((PermissionFlagType)permission.getPermissionFlags().getFlag().get(k)).toString();
                        if (flag.equalsIgnoreCase(method)) {
                            flagFound = true;
                            break block0;
                        }
                        ++k;
                    }
                    break;
                }
                ++j;
            }
        }
        if (!holderFound) {
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_FOUND, "Requesting Entity [" + requestingEntity + "] does not exist in permissions"));
        }
        if (!flagFound) {
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_PERMISSION_DENIED, String.valueOf(method) + " Method does not exist in permissions"));
        }
        return null;
    }

    public ResponseConfirm checkSelfPermissions(PermissionListType selfPermissions, String requestingEntity, String method) {
        boolean holderFound = false;
        boolean flagFound = false;
        int j = 0;
        block0: while (j < selfPermissions.getPermission().size()) {
            holderFound = false;
            PermissionType selfPermission = (PermissionType)selfPermissions.getPermission().get(j);
            int i = 0;
            while (i < selfPermission.getPermissionHolders().getHolderRefs().getHolderRef().size()) {
                String holder = (String)selfPermission.getPermissionHolders().getHolderRefs().getHolderRef().get(i);
                if (holder.equalsIgnoreCase(requestingEntity)) {
                    holderFound = true;
                    break;
                }
                ++i;
            }
            if (holderFound) {
                int k = 0;
                while (k < selfPermission.getPermissionFlags().getFlag().size()) {
                    String flag = ((PermissionFlagType)selfPermission.getPermissionFlags().getFlag().get(k)).toString();
                    if (flag.equalsIgnoreCase(method)) {
                        flagFound = true;
                        break block0;
                    }
                    ++k;
                }
                break;
            }
            ++j;
        }
        if (!holderFound) {
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_FOUND, "Requesting Entity [" + requestingEntity + "] does not exist in permissions"));
        }
        if (!flagFound) {
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_PERMISSION_DENIED, String.valueOf(method) + " Method does not exist in permissions"));
        }
        return null;
    }

    public boolean checkExpirationTime(String expirationTime) {
        return true;
    }

    public String getNewExpirationTime(long addedSeconds) {
        long addedMilSeconds = addedSeconds * 1000L;
        Date newDate = new Date(new Date().getTime() + addedMilSeconds);
        return DateConverter.toXMLGregorianCalendar((Date)newDate).toString();
    }

    public String getNewDelayTolerance(long addedSeconds) {
        long addedMilSeconds = addedSeconds * 1000L;
        Date newDate = new Date(new Date().getTime() + addedMilSeconds);
        return DateConverter.toXMLGregorianCalendar((Date)newDate).toString();
    }

    public static String generateId(String prefix, String postfix) {
        SecureRandom secureRandom = new SecureRandom();
        return String.valueOf(prefix) + String.valueOf(secureRandom.nextInt(999999999)) + postfix;
    }

    public static SearchStrings generateSearchStrings(String Resourcetype, String resourceId) {
        SearchStrings searchStrings = new SearchStrings();
        searchStrings.getSearchString().add("ResourceType/" + Resourcetype);
        searchStrings.getSearchString().add("ResourceID/" + resourceId);
        return searchStrings;
    }
}

