/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.comm.coap;

import ch.ethz.inf.vs.californium.coap.CoAP;
import ch.ethz.inf.vs.californium.coap.OptionSet;
import ch.ethz.inf.vs.californium.coap.Request;
import ch.ethz.inf.vs.californium.coap.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.comm.service.RestClientService;
import org.eclipse.om2m.commons.resource.StatusCode;
import org.eclipse.om2m.commons.rest.RequestIndication;
import org.eclipse.om2m.commons.rest.ResponseConfirm;

public class CoapClient
implements RestClientService {
    private static Log LOGGER = LogFactory.getLog(CoapClient.class);
    private static String protocol = "coap";

    public String getProtocol() {
        return protocol;
    }

    public ResponseConfirm sendRequest(RequestIndication requestIndication) {
        String method;
        LOGGER.debug((Object)("CoAP Client > " + requestIndication));
        ResponseConfirm responseConfirm = new ResponseConfirm();
        String representation = requestIndication.getRepresentation();
        String authorization = requestIndication.getRequestingEntity();
        CoAP.Code code = null;
        switch (method = requestIndication.getMethod()) {
            case "RETRIEVE": {
                code = CoAP.Code.GET;
                break;
            }
            case "CREATE": {
                code = CoAP.Code.POST;
                break;
            }
            case "UPDATE": {
                code = CoAP.Code.PUT;
                break;
            }
            case "DELETE": {
                code = CoAP.Code.DELETE;
                break;
            }
            case "EXECUTE": {
                code = CoAP.Code.POST;
                break;
            }
            default: {
                return new ResponseConfirm();
            }
        }
        Request request = new Request(code);
        OptionSet options = request.getOptions();
        int MId = (int)(1000.0 + Math.random() * 9001.0);
        request.setMID(MId);
        CoAP.Type coapType = CoAP.Type.CON;
        request.setType(coapType);
        switch (code) {
            case GET: {
                Request.newGet();
                break;
            }
            case POST: {
                Request.newPost();
                break;
            }
            case PUT: {
                Request.newPut();
                break;
            }
            case DELETE: {
                Request.newDelete();
                break;
            }
            default: {
                return new ResponseConfirm();
            }
        }
        String url = requestIndication.getUrl();
        request.setURI(url);
        request.setPayload(representation);
        options.setURIQuery(authorization);
        request.setScheme(url);
        request.send();
        Response response = null;
        try {
            response = request.waitForResponse();
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)("CoAP Client > Failed to receive response: " + e.getMessage()), (Throwable)e);
        }
        if (response != null) {
            if (response.getOptions().hasContentFormat(40)) {
                String linkFormat = response.getPayloadString();
                responseConfirm.setRepresentation(linkFormat);
            } else {
                responseConfirm.setRepresentation(response.getPayloadString());
            }
        }
        CoAP.ResponseCode returncode = response.getCode();
        responseConfirm.setStatusCode(CoapClient.getRestStatusCode(returncode));
        LOGGER.debug((Object)("CoAP Client > " + responseConfirm));
        return responseConfirm;
    }

    public static StatusCode getRestStatusCode(CoAP.ResponseCode CoAPstatusCode) {
        StatusCode standardCode = null;
        if (CoAPstatusCode == CoAP.ResponseCode.DELETED || CoAPstatusCode == CoAP.ResponseCode.VALID || CoAPstatusCode == CoAP.ResponseCode.CHANGED || CoAPstatusCode == CoAP.ResponseCode.CONTENT) {
            return StatusCode.STATUS_OK;
        }
        if (CoAPstatusCode == CoAP.ResponseCode.CREATED) {
            standardCode = StatusCode.STATUS_CREATED;
        } else if (CoAPstatusCode == CoAP.ResponseCode.BAD_REQUEST) {
            standardCode = StatusCode.STATUS_BAD_REQUEST;
        } else if (CoAPstatusCode == CoAP.ResponseCode.UNAUTHORIZED) {
            standardCode = StatusCode.STATUS_PERMISSION_DENIED;
        } else if (CoAPstatusCode == CoAP.ResponseCode.UNSUPPORTED_CONTENT_FORMAT) {
            standardCode = StatusCode.STATUS_UNSUPPORTED_MEDIA_TYPE;
        } else if (CoAPstatusCode == CoAP.ResponseCode.FORBIDDEN) {
            standardCode = StatusCode.STATUS_FORBIDDEN;
        } else if (CoAPstatusCode == CoAP.ResponseCode.NOT_FOUND) {
            standardCode = StatusCode.STATUS_NOT_FOUND;
        } else if (CoAPstatusCode == CoAP.ResponseCode.METHOD_NOT_ALLOWED) {
            standardCode = StatusCode.STATUS_METHOD_NOT_ALLOWED;
        } else if (CoAPstatusCode == CoAP.ResponseCode.INTERNAL_SERVER_ERROR) {
            standardCode = StatusCode.STATUS_INTERNAL_SERVER_ERROR;
        } else if (CoAPstatusCode == CoAP.ResponseCode.NOT_IMPLEMENTED) {
            standardCode = StatusCode.STATUS_NOT_IMPLEMENTED;
        } else if (CoAPstatusCode == CoAP.ResponseCode.BAD_GATEWAY) {
            standardCode = StatusCode.STATUS_BAD_GATEWAY;
        } else if (CoAPstatusCode == CoAP.ResponseCode.SERVICE_UNAVAILABLE) {
            standardCode = StatusCode.STATUS_SERVICE_UNAVAILABLE;
        } else if (CoAPstatusCode == CoAP.ResponseCode.GATEWAY_TIMEOUT) {
            standardCode = StatusCode.STATUS_GATEWAY_TIMEOUT;
        }
        return standardCode;
    }
}

