/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.internal.osgi.weaving;

import org.eclipse.objectteams.internal.osgi.weaving.Util;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;

public class Logger {
    private FrameworkLog fwLog;

    public Logger(FrameworkLog fwLog) {
        this.fwLog = fwLog;
    }

    public void log(Throwable t, String msg) {
        this.log("org.eclipse.objectteams.otequinox", t, msg);
    }

    public void log(String pluginID, Throwable t, String msg) {
        if (this.fwLog != null) {
            this.fwLog.log(new FrameworkLogEntry(pluginID, 4, 0, msg, 0, t, null));
            return;
        }
        System.err.println("OT/Equinox: " + msg);
        t.printStackTrace();
    }

    public void log(int status, String msg) {
        if (status >= Util.WARN_LEVEL) {
            this.doLog("org.eclipse.objectteams.otequinox", status, msg);
        }
    }

    public void log(String pluginID, int status, String msg) {
        if (status >= Util.WARN_LEVEL) {
            this.doLog(pluginID, status, msg);
        }
    }

    public void doLog(int status, String msg) {
        this.doLog("org.eclipse.objectteams.otequinox", status, msg);
    }

    public void doLog(String pluginID, int status, String msg) {
        if (this.fwLog != null) {
            this.fwLog.log(new FrameworkLogEntry(pluginID, status, 0, (String)msg, 0, null, null));
        } else {
            msg = "OT/Equinox: " + (String)msg;
            if ((status & 4) != 0) {
                System.err.println((String)msg);
            } else {
                System.out.println((String)msg);
            }
        }
    }
}

