/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.internal.osgi.weaving;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.objectteams.internal.osgi.weaving.OTWeavingHook;
import org.objectweb.asm.ClassReader;

public class ASMByteCodeAnalyzer {
    private Map<String, ClassInformation> classInformationMap = new ConcurrentHashMap<String, ClassInformation>(512, 0.75f, 4);

    public ClassInformation getClassInformation(InputStream classStream, String className) {
        try {
            return this.getClassInformation(null, classStream, className);
        }
        catch (IOException e) {
            return null;
        }
    }

    public ClassInformation getClassInformation(byte[] classBytes, String className) {
        try {
            return this.getClassInformation(classBytes, null, className);
        }
        catch (IOException e) {
            return null;
        }
    }

    private ClassInformation getClassInformation(byte[] classBytes, InputStream classStream, String className) throws IOException {
        ClassInformation classInformation = this.classInformationMap.get(className);
        if (classInformation != null) {
            return classInformation;
        }
        ClassAndAttributesReader classReader = classBytes != null ? new ClassAndAttributesReader(classBytes) : new ClassAndAttributesReader(classStream);
        classInformation = new ClassInformation(classReader);
        this.classInformationMap.put(className, classInformation);
        return classInformation;
    }

    public  @NonNull OTWeavingHook.WeavingScheme determineWeavingScheme(byte[] classBytes, String className) {
        try {
            ClassInformation classInformation = this.getClassInformation(classBytes, null, className);
            return classInformation.getWeavingScheme();
        }
        catch (IOException iOException) {
            return OTWeavingHook.WeavingScheme.Unknown;
        }
    }

    public  @NonNull OTWeavingHook.WeavingScheme determineWeavingScheme(InputStream classStream, String className) {
        try {
            ClassInformation classInformation = this.getClassInformation(null, classStream, className);
            return classInformation.getWeavingScheme();
        }
        catch (IOException iOException) {
            return OTWeavingHook.WeavingScheme.Unknown;
        }
    }

    protected static class ClassAndAttributesReader
    extends ClassReader {
        private static final int MAX_ATTR_NAME_LEN = 100;
        OTWeavingHook.WeavingScheme weavingScheme;
        int otClassFlags;
        boolean attributesRead;

        public ClassAndAttributesReader(byte[] classFile) {
            super(classFile);
        }

        public ClassAndAttributesReader(InputStream classStream) throws IOException {
            super(classStream);
        }

        void readOTAttributes() {
            if (this.attributesRead) {
                return;
            }
            this.attributesRead = true;
            char[] charBuffer = new char[100];
            int currentAttributeOffset = this.myGetFirstAttributeOffset();
            int found = 0;
            int i = this.readUnsignedShort(currentAttributeOffset - 2);
            while (i > 0) {
                String attributeName = this.myReadUTF8(currentAttributeOffset, charBuffer);
                int attributeLength = this.readInt(currentAttributeOffset + 2);
                currentAttributeOffset += 6;
                if ("OTClassFlags".equals(attributeName)) {
                    this.otClassFlags = this.readUnsignedShort(currentAttributeOffset);
                    ++found;
                } else if ("OTCompilerVersion".equals(attributeName)) {
                    int encodedVersion = this.readUnsignedShort(currentAttributeOffset);
                    this.weavingScheme = (encodedVersion & 0x8000) != 0 ? OTWeavingHook.WeavingScheme.OTDRE : OTWeavingHook.WeavingScheme.OTRE;
                    ++found;
                }
                if (found == 2) break;
                currentAttributeOffset += attributeLength;
                --i;
            }
        }

        String myReadUTF8(int offset, char[] charBuffer) {
            try {
                return this.readUTF8(offset, charBuffer);
            }
            catch (ArrayIndexOutOfBoundsException aioobe) {
                return "<name is too long>";
            }
        }

        int myGetFirstAttributeOffset() {
            int currentOffset = this.header + 8 + this.readUnsignedShort(this.header + 6) * 2;
            int fieldsCount = this.readUnsignedShort(currentOffset);
            currentOffset += 2;
            while (fieldsCount-- > 0) {
                int attributesCount = this.readUnsignedShort(currentOffset + 6);
                currentOffset += 8;
                while (attributesCount-- > 0) {
                    currentOffset += 6 + this.readInt(currentOffset + 2);
                }
            }
            int methodsCount = this.readUnsignedShort(currentOffset);
            currentOffset += 2;
            while (methodsCount-- > 0) {
                int attributesCount = this.readUnsignedShort(currentOffset + 6);
                currentOffset += 8;
                while (attributesCount-- > 0) {
                    currentOffset += 6 + this.readInt(currentOffset + 2);
                }
            }
            return currentOffset + 2;
        }
    }

    public static class ClassInformation {
        private int modifiers;
        private String name;
        private String superClassName;
        private String[] superInterfaceNames;
        private ClassAndAttributesReader reader;
        private Boolean isOTClass;
        private  @NonNull OTWeavingHook.WeavingScheme weavingScheme = OTWeavingHook.WeavingScheme.Unknown;

        ClassInformation(ClassAndAttributesReader classReader) {
            this.modifiers = classReader.getAccess();
            this.name = classReader.getClassName();
            this.superClassName = classReader.getSuperName();
            this.superInterfaceNames = classReader.getInterfaces();
            this.reader = classReader;
        }

        public boolean isOTClass() {
            if (this.isOTClass == null) {
                this.reader.readOTAttributes();
                this.isOTClass = (this.reader.otClassFlags & 3) != 0;
            }
            return this.isOTClass;
        }

        public  @NonNull OTWeavingHook.WeavingScheme getWeavingScheme() {
            if (this.weavingScheme == OTWeavingHook.WeavingScheme.Unknown) {
                this.evaluateAttributes();
            }
            return this.weavingScheme;
        }

        private void evaluateAttributes() {
            if (this.reader != null) {
                this.reader.readOTAttributes();
                OTWeavingHook.WeavingScheme scheme = this.reader.weavingScheme;
                if (scheme != null) {
                    this.weavingScheme = scheme;
                }
                this.isOTClass = (this.reader.otClassFlags & 3) != 0;
                this.reader = null;
            }
        }

        public boolean isInterface() {
            return (this.modifiers & 0x200) != 0;
        }

        public String getSuperClassName() {
            if (this.superClassName != null) {
                return this.superClassName.replace('/', '.');
            }
            return null;
        }

        public String[] getSuperInterfaceNames() {
            if (this.superInterfaceNames != null) {
                int i = 0;
                while (i < this.superInterfaceNames.length) {
                    this.superInterfaceNames[i] = this.superInterfaceNames[i].replace('/', '.');
                    ++i;
                }
            }
            return this.superInterfaceNames;
        }

        public String getName() {
            if (this.name != null) {
                return this.name.replace('/', '.');
            }
            return "<no name>";
        }
    }
}

