/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.builder;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.CompilationParticipant;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.ClasspathValidation;
import org.eclipse.jdt.internal.core.CompilationGroup;
import org.eclipse.jdt.internal.core.ExternalFoldersManager;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.builder.BatchImageBuilder;
import org.eclipse.jdt.internal.core.builder.BuildNotifier;
import org.eclipse.jdt.internal.core.builder.ClasspathLocation;
import org.eclipse.jdt.internal.core.builder.ClasspathMultiDirectory;
import org.eclipse.jdt.internal.core.builder.IncrementalImageBuilder;
import org.eclipse.jdt.internal.core.builder.NameEnvironment;
import org.eclipse.jdt.internal.core.builder.SourceFile;
import org.eclipse.jdt.internal.core.builder.State;
import org.eclipse.jdt.internal.core.util.Messages;
import org.eclipse.jdt.internal.core.util.Util;

public class JavaBuilder
extends IncrementalProjectBuilder {
    IProject currentProject;
    JavaProject javaProject;
    IWorkspaceRoot workspaceRoot;
    CompilationParticipant[] participants;
    NameEnvironment nameEnvironment;
    NameEnvironment testNameEnvironment;
    Map<IProject, ClasspathLocation[]> binaryLocationsPerProject;
    public State lastState;
    BuildNotifier notifier;
    char[][] extraResourceFileFilters;
    String[] extraResourceFolderFilters;
    public static final String SOURCE_ID = "JDT";
    public static boolean DEBUG = false;
    public static boolean SHOW_STATS = false;
    private static final boolean DISABLE_AUTO_BUILDING_ON_SETTINGS_CHANGE = Boolean.getBoolean("org.eclipse.disableAutoBuildOnSettingsChange");
    private static final IPath JDT_CORE_SETTINGS_PATH = Path.fromPortableString((String)".settings/org.eclipse.jdt.core.prefs");
    static LinkedHashSet<String> builtProjects;
    private Map<Integer, INameEnvironment> releaseSpecificEnvironments;

    public static IMarker[] getProblemsFor(IResource resource) {
        try {
            if (resource != null && resource.exists()) {
                IMarker[] markers = resource.findMarkers("org.eclipse.jdt.core.problem", false, 2);
                HashSet<String> markerTypes = JavaModelManager.getJavaModelManager().compilationParticipants.managedMarkerTypes();
                if (markerTypes.isEmpty()) {
                    return markers;
                }
                ArrayList<IMarker> markerList = new ArrayList<IMarker>(5);
                IMarker[] iMarkerArray = markers;
                int n = markers.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker marker = iMarkerArray[n2];
                    markerList.add(marker);
                    ++n2;
                }
                for (String markerType : markerTypes) {
                    IMarker[] iMarkerArray2 = markers = resource.findMarkers(markerType, false, 2);
                    int n3 = markers.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IMarker marker = iMarkerArray2[n4];
                        markerList.add(marker);
                        ++n4;
                    }
                }
                IMarker[] result = new IMarker[markerList.size()];
                markerList.toArray(result);
                return result;
            }
        }
        catch (CoreException coreException) {}
        return new IMarker[0];
    }

    public static IMarker[] getTasksFor(IResource resource) {
        try {
            if (resource != null && resource.exists()) {
                return resource.findMarkers("org.eclipse.jdt.core.task", false, 2);
            }
        }
        catch (CoreException coreException) {}
        return new IMarker[0];
    }

    public static void buildStarting() {
    }

    public static void buildFinished() {
        BuildNotifier.resetProblemCounters();
    }

    public static void removeProblemsFor(IResource resource) {
        try {
            if (resource != null && resource.exists()) {
                resource.deleteMarkers("org.eclipse.jdt.core.problem", false, 2);
                HashSet<String> markerTypes = JavaModelManager.getJavaModelManager().compilationParticipants.managedMarkerTypes();
                if (markerTypes.size() == 0) {
                    return;
                }
                for (String markerType : markerTypes) {
                    resource.deleteMarkers(markerType, false, 2);
                }
            }
        }
        catch (CoreException coreException) {}
    }

    public static void removeTasksFor(IResource resource) {
        try {
            if (resource != null && resource.exists()) {
                resource.deleteMarkers("org.eclipse.jdt.core.task", false, 2);
            }
        }
        catch (CoreException coreException) {}
    }

    public static void removeProblemsAndTasksFor(IResource resource) {
        try {
            if (resource != null && resource.exists()) {
                resource.deleteMarkers("org.eclipse.jdt.core.problem", false, 2);
                resource.deleteMarkers("org.eclipse.jdt.core.task", false, 2);
                HashSet<String> markerTypes = JavaModelManager.getJavaModelManager().compilationParticipants.managedMarkerTypes();
                if (markerTypes.size() == 0) {
                    return;
                }
                for (String markerType : markerTypes) {
                    resource.deleteMarkers(markerType, false, 2);
                }
            }
        }
        catch (CoreException coreException) {}
    }

    public static State readState(IProject project, DataInputStream in) throws IOException, CoreException {
        return State.read(project, in);
    }

    public static void writeState(Object state, DataOutputStream out) throws IOException {
        ((State)state).write(out);
    }

    /*
     * Exception decompiling
     */
    protected IProject[] build(int kind, Map<String, String> ignoredArgs, IProgressMonitor monitor) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void buildAll() {
        this.notifier.checkCancel();
        this.notifier.subTask(Messages.bind(Messages.build_preparingBuild, this.currentProject.getName()));
        if (DEBUG && this.lastState != null) {
            JavaModelManager.trace("JavaBuilder: Clearing last state : " + String.valueOf(this.lastState));
        }
        this.clearLastState();
        BatchImageBuilder imageBuilder = new BatchImageBuilder(this, true, CompilationGroup.MAIN);
        BatchImageBuilder testImageBuilder = new BatchImageBuilder(imageBuilder, true, CompilationGroup.TEST);
        imageBuilder.build();
        if (testImageBuilder.sourceLocations.length > 0) {
            testImageBuilder.build();
        } else {
            testImageBuilder.cleanUp();
        }
        this.recordNewState(imageBuilder.newState);
    }

    private void buildDeltas(Map<IProject, IResourceDelta> deltas) {
        this.notifier.checkCancel();
        this.notifier.subTask(Messages.bind(Messages.build_preparingBuild, this.currentProject.getName()));
        if (DEBUG && this.lastState != null) {
            JavaModelManager.trace("JavaBuilder: Clearing last state : " + String.valueOf(this.lastState));
        }
        this.clearLastState();
        IncrementalImageBuilder imageBuilder = this.makeImageBuilder(deltas);
        if (imageBuilder.build(deltas)) {
            this.recordNewState(imageBuilder.newState);
        } else {
            if (DEBUG) {
                JavaModelManager.trace("JavaBuilder: Performing full build since incremental build failed");
            }
            this.buildAll();
        }
    }

    protected IncrementalImageBuilder makeImageBuilder(Map<IProject, IResourceDelta> deltas) {
        return new IncrementalImageBuilder(this);
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        block9: {
            this.currentProject = this.getProject();
            if (this.currentProject == null || !this.currentProject.isAccessible()) {
                return;
            }
            if (DEBUG) {
                JavaModelManager.trace("\nJavaBuilder: Cleaning " + this.currentProject.getName() + " @ " + String.valueOf(new Date(System.currentTimeMillis())));
            }
            this.notifier = new BuildNotifier(monitor, 15, () -> false);
            this.notifier.begin();
            try {
                try {
                    this.notifier.checkCancel();
                    this.initializeBuilder(15, true);
                    if (DEBUG) {
                        JavaModelManager.trace("JavaBuilder: Clearing last state as part of clean : " + String.valueOf(this.lastState));
                    }
                    this.clearLastState();
                    JavaBuilder.removeProblemsAndTasksFor((IResource)this.currentProject);
                    new BatchImageBuilder(this, false, CompilationGroup.MAIN).cleanOutputFolders(false);
                    new BatchImageBuilder(this, false, CompilationGroup.TEST).cleanOutputFolders(false);
                }
                catch (CoreException e) {
                    Util.log(e, "JavaBuilder handling CoreException while cleaning: " + this.currentProject.getName());
                    this.createInconsistentBuildMarker(e);
                    this.notifier.done();
                    this.cleanup();
                    break block9;
                }
            }
            catch (Throwable throwable) {
                this.notifier.done();
                this.cleanup();
                throw throwable;
            }
            this.notifier.done();
            this.cleanup();
        }
        if (DEBUG) {
            JavaModelManager.trace("JavaBuilder: Finished cleaning " + this.currentProject.getName() + " @ " + String.valueOf(new Date(System.currentTimeMillis())));
        }
    }

    void createInconsistentBuildMarker(CoreException coreException) throws CoreException {
        IStatus[] children;
        String message = null;
        IStatus status = coreException.getStatus();
        if (status.isMultiStatus() && (children = status.getChildren()) != null && children.length > 0) {
            message = children[0].getMessage();
        }
        if (message == null) {
            message = coreException.getMessage();
        }
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("message", Messages.bind(Messages.build_inconsistentProject, message));
        attributes.put("severity", 2);
        attributes.put("categoryId", 10);
        attributes.put("sourceId", SOURCE_ID);
        this.currentProject.createMarker("org.eclipse.jdt.core.problem", attributes);
    }

    private void cleanup() {
        this.participants = null;
        if (this.nameEnvironment != null) {
            this.nameEnvironment.cleanup();
            this.nameEnvironment = null;
        }
        if (this.testNameEnvironment != null) {
            this.testNameEnvironment.cleanup();
            this.testNameEnvironment = null;
        }
        this.binaryLocationsPerProject = null;
        this.lastState = null;
        this.notifier = null;
        this.extraResourceFileFilters = null;
        this.extraResourceFolderFilters = null;
        if (this.releaseSpecificEnvironments != null) {
            this.releaseSpecificEnvironments.values().forEach(INameEnvironment::cleanup);
            this.releaseSpecificEnvironments = null;
        }
    }

    private void clearLastState() {
        JavaModelManager.getJavaModelManager().setLastBuiltState(this.currentProject, null);
    }

    boolean filterExtraResource(IResource resource) {
        if (this.extraResourceFileFilters != null) {
            char[] name = resource.getName().toCharArray();
            char[][] cArray = this.extraResourceFileFilters;
            int n = this.extraResourceFileFilters.length;
            int n2 = 0;
            while (n2 < n) {
                char[] extraResourceFileFilter = cArray[n2];
                if (CharOperation.match((char[])extraResourceFileFilter, (char[])name, (boolean)true)) {
                    return true;
                }
                ++n2;
            }
        }
        if (this.extraResourceFolderFilters != null) {
            IPath path = resource.getProjectRelativePath();
            String pathName = path.toString();
            int count = path.segmentCount();
            if (resource.getType() == 1) {
                --count;
            }
            String[] stringArray = this.extraResourceFolderFilters;
            int n = this.extraResourceFolderFilters.length;
            int n3 = 0;
            while (n3 < n) {
                String extraResourceFolderFilter = stringArray[n3];
                if (pathName.indexOf(extraResourceFolderFilter) != -1) {
                    int j = 0;
                    while (j < count) {
                        if (extraResourceFolderFilter.equals(path.segment(j))) {
                            return true;
                        }
                        ++j;
                    }
                }
                ++n3;
            }
        }
        return false;
    }

    private Map<IProject, IResourceDelta> findDeltas() {
        this.notifier.subTask(Messages.bind(Messages.build_readingDelta, this.currentProject.getName()));
        IResourceDelta delta = this.getDelta(this.currentProject);
        HashMap<IProject, IResourceDelta> deltas = new HashMap<IProject, IResourceDelta>();
        if (delta != null) {
            if (delta.getKind() != 0) {
                if (DEBUG) {
                    JavaModelManager.trace("JavaBuilder: Found source delta for: " + this.currentProject.getName());
                }
                deltas.put(this.currentProject, delta);
            }
        } else {
            if (DEBUG) {
                JavaModelManager.trace("JavaBuilder: Missing delta for: " + this.currentProject.getName());
            }
            this.notifier.subTask("");
            return null;
        }
        for (Map.Entry<IProject, ClasspathLocation[]> entry : this.binaryLocationsPerProject.entrySet()) {
            IProject p = entry.getKey();
            if (p == null || p == this.currentProject) continue;
            State s = this.getLastState(p);
            if (!this.lastState.wasStructurallyChanged(p, s)) {
                if (s.wasNoopBuild()) continue;
                ClasspathLocation[] classFoldersAndJars = entry.getValue();
                boolean canSkip = true;
                int j = 0;
                int m = classFoldersAndJars.length;
                while (j < m) {
                    if (classFoldersAndJars[j].isOutputFolder()) {
                        classFoldersAndJars[j] = null;
                    } else {
                        canSkip = false;
                    }
                    ++j;
                }
                if (canSkip) continue;
            }
            this.notifier.subTask(Messages.bind(Messages.build_readingDelta, p.getName()));
            delta = this.getDelta(p);
            if (delta != null) {
                if (delta.getKind() == 0) continue;
                if (DEBUG) {
                    JavaModelManager.trace("JavaBuilder: Found binary delta for: " + p.getName());
                }
                deltas.put(p, delta);
                continue;
            }
            if (DEBUG) {
                JavaModelManager.trace("JavaBuilder: Missing delta for: " + p.getName());
            }
            this.notifier.subTask("");
            return null;
        }
        this.notifier.subTask("");
        return deltas;
    }

    public State getLastState(IProject project) {
        return (State)JavaModelManager.getJavaModelManager().getLastBuiltState(project, this.notifier.monitor);
    }

    private IProject[] getRequiredProjects(boolean includeBinaryPrerequisites) {
        if (this.javaProject == null || this.workspaceRoot == null) {
            return new IProject[0];
        }
        LinkedHashSet<IProject> projects = new LinkedHashSet<IProject>();
        ExternalFoldersManager externalFoldersManager = JavaModelManager.getExternalManager();
        try {
            IClasspathEntry[] entries;
            IClasspathEntry[] iClasspathEntryArray = entries = this.javaProject.getExpandedClasspath();
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                IPath path = entry.getPath();
                IProject p = null;
                switch (entry.getEntryKind()) {
                    case 2: {
                        p = this.workspaceRoot.getProject(path.lastSegment());
                        if (!((ClasspathEntry)entry).isOptional() || JavaProject.hasJavaNature(p)) break;
                        p = null;
                        break;
                    }
                    case 1: {
                        if (!includeBinaryPrerequisites || path.segmentCount() <= 0) break;
                        IResource resource = this.workspaceRoot.findMember(path.segment(0));
                        if (resource instanceof IProject) {
                            p = (IProject)resource;
                            break;
                        }
                        resource = externalFoldersManager.getFolder(path);
                        if (resource == null) break;
                        p = resource.getProject();
                    }
                }
                if (p != null && !projects.contains(p)) {
                    projects.add(p);
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {
            return new IProject[0];
        }
        IProject[] result = new IProject[projects.size()];
        projects.toArray(result);
        return result;
    }

    boolean hasBuildpathErrors() throws CoreException {
        IMarker[] markers;
        IMarker[] iMarkerArray = markers = this.currentProject.findMarkers("org.eclipse.jdt.core.problem", false, 0);
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            if (marker.getAttribute("categoryId", -1) == 10) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean hasJdtCoreSettingsChange(Map<IProject, IResourceDelta> deltas) {
        IResourceDelta resourceDelta = deltas.get(this.currentProject);
        if (resourceDelta == null) {
            return false;
        }
        return resourceDelta.findMember(JDT_CORE_SETTINGS_PATH) != null;
    }

    private boolean hasClasspathChanged() {
        return this.hasClasspathChanged(CompilationGroup.MAIN) || this.hasClasspathChanged(CompilationGroup.TEST);
    }

    private boolean hasClasspathChanged(CompilationGroup compilationGroup) {
        ClasspathLocation[] newSourceLocations = (compilationGroup == CompilationGroup.MAIN ? this.nameEnvironment : this.testNameEnvironment).sourceLocations;
        ClasspathLocation[] oldSourceLocations = compilationGroup == CompilationGroup.MAIN ? this.lastState.sourceLocations : this.lastState.testSourceLocations;
        int newLength = newSourceLocations.length;
        int oldLength = oldSourceLocations.length;
        int o = 0;
        int n = 0;
        while (n < newLength && o < oldLength) {
            block19: {
                if (!newSourceLocations[n].equals(oldSourceLocations[o])) {
                    block20: {
                        try {
                            if (((ClasspathMultiDirectory)newSourceLocations[n]).sourceFolder.members().length == 0) {
                                --o;
                                break block19;
                            }
                            if (!this.lastState.isSourceFolderEmpty(((ClasspathMultiDirectory)oldSourceLocations[o]).sourceFolder)) break block20;
                            --n;
                            break block19;
                        }
                        catch (CoreException coreException) {}
                    }
                    if (DEBUG) {
                        JavaModelManager.trace("JavaBuilder: New location: " + String.valueOf(newSourceLocations[n]) + "\n!= old location: " + String.valueOf(oldSourceLocations[o]));
                        this.printLocations(newSourceLocations, oldSourceLocations);
                    }
                    return true;
                }
            }
            ++n;
            ++o;
        }
        while (n < newLength) {
            try {
                if (newSourceLocations[n].sourceFolder.members().length == 0) {
                    ++n;
                    continue;
                }
            }
            catch (CoreException coreException) {}
            if (DEBUG) {
                JavaModelManager.trace("JavaBuilder: Added non-empty source folder");
                this.printLocations(newSourceLocations, oldSourceLocations);
            }
            return true;
        }
        while (o < oldLength) {
            if (this.lastState.isSourceFolderEmpty(oldSourceLocations[o].sourceFolder)) {
                ++o;
                continue;
            }
            if (DEBUG) {
                JavaModelManager.trace("JavaBuilder: Removed non-empty source folder");
                this.printLocations(newSourceLocations, oldSourceLocations);
            }
            return true;
        }
        ClasspathLocation[] newBinaryLocations = (compilationGroup == CompilationGroup.MAIN ? this.nameEnvironment : this.testNameEnvironment).binaryLocations;
        ClasspathLocation[] oldBinaryLocations = compilationGroup == CompilationGroup.MAIN ? this.lastState.binaryLocations : this.lastState.testBinaryLocations;
        newLength = newBinaryLocations.length;
        oldLength = oldBinaryLocations.length;
        o = 0;
        n = 0;
        while (n < newLength && o < oldLength) {
            if (!newBinaryLocations[n].equals(oldBinaryLocations[o])) {
                if (DEBUG) {
                    JavaModelManager.trace("JavaBuilder: New test location: " + String.valueOf(newBinaryLocations[n]) + "\n!= old test location: " + String.valueOf(oldBinaryLocations[o]));
                    this.printLocations(newBinaryLocations, oldBinaryLocations);
                }
                return true;
            }
            ++n;
            ++o;
        }
        if (n < newLength || o < oldLength) {
            if (DEBUG) {
                JavaModelManager.trace("JavaBuilder: Number of test binary folders/jar files has changed:");
                this.printLocations(newBinaryLocations, oldBinaryLocations);
            }
            return true;
        }
        return false;
    }

    private boolean hasJavaBuilder(IProject project) throws CoreException {
        ICommand[] buildCommands;
        ICommand[] iCommandArray = buildCommands = project.getDescription().getBuildSpec();
        int n = buildCommands.length;
        int n2 = 0;
        while (n2 < n) {
            ICommand buildCommand = iCommandArray[n2];
            if (buildCommand.getBuilderName().equals("org.eclipse.jdt.core.javabuilder")) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean hasStructuralDelta() {
        ClasspathLocation[] classFoldersAndJars;
        IResourceDelta delta = this.getDelta(this.currentProject);
        if (delta != null && delta.getKind() != 0 && (classFoldersAndJars = this.binaryLocationsPerProject.get(this.currentProject)) != null) {
            ClasspathLocation[] classpathLocationArray = classFoldersAndJars;
            int n = classFoldersAndJars.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta binaryDelta;
                IPath p;
                ClasspathLocation classFolderOrJar = classpathLocationArray[n2];
                if (classFolderOrJar != null && (p = classFolderOrJar.getProjectRelativePath()) != null && (binaryDelta = delta.findMember(p)) != null && binaryDelta.getKind() != 0) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private int initializeBuilder(int kind, boolean forBuild) throws CoreException {
        this.javaProject = (JavaProject)JavaCore.create(this.currentProject);
        this.workspaceRoot = this.currentProject.getWorkspace().getRoot();
        if (forBuild) {
            this.participants = JavaModelManager.getJavaModelManager().compilationParticipants.getCompilationParticipants(this.javaProject);
            if (this.participants != null) {
                CompilationParticipant[] compilationParticipantArray = this.participants;
                int n = this.participants.length;
                int n2 = 0;
                while (n2 < n) {
                    CompilationParticipant participant = compilationParticipantArray[n2];
                    if (participant.aboutToBuild(this.javaProject) == 2) {
                        kind = 6;
                    }
                    ++n2;
                }
            }
            String projectName = this.currentProject.getName();
            if (builtProjects == null || builtProjects.contains(projectName)) {
                builtProjects = new LinkedHashSet();
            }
            builtProjects.add(projectName);
        }
        this.binaryLocationsPerProject = new HashMap<IProject, ClasspathLocation[]>(3);
        this.nameEnvironment = new NameEnvironment(this.workspaceRoot, this.javaProject, this.binaryLocationsPerProject, this.notifier, CompilationGroup.MAIN, -1);
        this.testNameEnvironment = new NameEnvironment(this.workspaceRoot, this.javaProject, this.binaryLocationsPerProject, this.notifier, CompilationGroup.TEST, -1);
        if (forBuild) {
            char[][] filters;
            String filterSequence = this.javaProject.getOption("org.eclipse.jdt.core.builder.resourceCopyExclusionFilter", true);
            char[][] cArray = filters = filterSequence != null && filterSequence.length() > 0 ? CharOperation.splitAndTrimOn((char)',', (char[])filterSequence.toCharArray()) : null;
            if (filters == null) {
                this.extraResourceFileFilters = null;
                this.extraResourceFolderFilters = null;
            } else {
                char[] f;
                int fileCount = 0;
                int folderCount = 0;
                char[][] cArray2 = filters;
                int n = filters.length;
                int n3 = 0;
                while (n3 < n) {
                    f = cArray2[n3];
                    if (f.length != 0) {
                        if (f[f.length - 1] == '/') {
                            ++folderCount;
                        } else {
                            ++fileCount;
                        }
                    }
                    ++n3;
                }
                this.extraResourceFileFilters = new char[fileCount][];
                this.extraResourceFolderFilters = new String[folderCount];
                cArray2 = filters;
                n = filters.length;
                n3 = 0;
                while (n3 < n) {
                    f = cArray2[n3];
                    if (f.length != 0) {
                        if (f[f.length - 1] == '/') {
                            this.extraResourceFolderFilters[--folderCount] = new String(f, 0, f.length - 1);
                        } else {
                            this.extraResourceFileFilters[--fileCount] = f;
                        }
                    }
                    ++n3;
                }
            }
        }
        return kind;
    }

    INameEnvironment getNameEnvironment(int release) throws CoreException {
        Object environment;
        if (this.releaseSpecificEnvironments == null) {
            this.releaseSpecificEnvironments = new HashMap<Integer, INameEnvironment>();
        }
        if ((environment = this.releaseSpecificEnvironments.get(release)) == null) {
            environment = new NameEnvironment(this.workspaceRoot, this.javaProject, this.binaryLocationsPerProject, this.notifier, CompilationGroup.MAIN, release);
            this.releaseSpecificEnvironments.put(release, (INameEnvironment)environment);
        }
        return environment;
    }

    private boolean isClasspathBroken(JavaProject jProj, boolean tryRepair) throws CoreException {
        IMarker[] markers;
        IMarker[] iMarkerArray = markers = jProj.getProject().findMarkers("org.eclipse.jdt.core.buildpath_problem", false, 0);
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            if (marker.getAttribute("severity", -1) == 2) {
                Object code;
                if (tryRepair && (code = marker.getAttribute("id")) instanceof Integer && (Integer)code == 1014) {
                    new ClasspathValidation(jProj).validate();
                    return this.isClasspathBroken(jProj, false);
                }
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isWorthBuilding() throws CoreException {
        IProject[] requiredProjects;
        boolean abortBuilds = "abort".equals(this.javaProject.getOption("org.eclipse.jdt.core.builder.invalidClasspath", true));
        if (!abortBuilds) {
            if (DEBUG) {
                JavaModelManager.trace("JavaBuilder: Ignoring invalid classpath");
            }
            return true;
        }
        if (this.isClasspathBroken(this.javaProject, true)) {
            if (DEBUG) {
                JavaModelManager.trace("JavaBuilder: Aborted build because project has classpath errors (incomplete or involved in cycle)");
            }
            JavaBuilder.removeProblemsAndTasksFor((IResource)this.currentProject);
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("message", Messages.build_abortDueToClasspathProblems);
            attributes.put("severity", 2);
            attributes.put("categoryId", 10);
            attributes.put("sourceId", SOURCE_ID);
            this.currentProject.createMarker("org.eclipse.jdt.core.problem", attributes);
            return false;
        }
        if ("warning".equals(this.javaProject.getOption("org.eclipse.jdt.core.incompleteClasspath", true))) {
            return true;
        }
        IProject[] iProjectArray = requiredProjects = this.getRequiredProjects(false);
        int n = requiredProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject p = iProjectArray[n2];
            if (this.getLastState(p) == null) {
                JavaProject prereq = (JavaProject)JavaCore.create(p);
                if (prereq.hasCycleMarker() && "warning".equals(this.javaProject.getOption("org.eclipse.jdt.core.circularClasspath", true))) {
                    if (DEBUG) {
                        JavaModelManager.trace("JavaBuilder: Continued to build even though prereq project " + p.getName() + " was not built since its part of a cycle");
                    }
                } else if (!this.hasJavaBuilder(p)) {
                    if (DEBUG) {
                        JavaModelManager.trace("JavaBuilder: Continued to build even though prereq project " + p.getName() + " is not built by JavaBuilder");
                    }
                } else {
                    if (DEBUG) {
                        JavaModelManager.trace("JavaBuilder: Aborted build because prereq project " + p.getName() + " was not built");
                    }
                    JavaBuilder.removeProblemsAndTasksFor((IResource)this.currentProject);
                    HashMap<String, Object> attributes = new HashMap<String, Object>();
                    attributes.put("message", this.isClasspathBroken(prereq, true) ? Messages.bind(Messages.build_prereqProjectHasClasspathProblems, p.getName()) : Messages.bind(Messages.build_prereqProjectMustBeRebuilt, p.getName()));
                    attributes.put("severity", 2);
                    attributes.put("categoryId", 10);
                    attributes.put("sourceId", SOURCE_ID);
                    this.currentProject.createMarker("org.eclipse.jdt.core.problem", attributes);
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }

    void mustPropagateStructuralChanges() {
        LinkedHashSet<IPath> cycleParticipants = new LinkedHashSet<IPath>(3);
        this.javaProject.updateCycleParticipants(new ArrayList<IPath>(), cycleParticipants, new HashMap<IPath, List<JavaProject.CycleInfo>>(), this.workspaceRoot, new HashSet(3), null);
        IPath currentPath = this.javaProject.getPath();
        HashSet<IProject> toRebuild = new HashSet<IProject>();
        for (IPath participantPath : cycleParticipants) {
            IProject project;
            if (participantPath == currentPath || !this.hasBeenBuilt(project = this.workspaceRoot.getProject(participantPath.segment(0)))) continue;
            if (DEBUG) {
                JavaModelManager.trace("JavaBuilder: Requesting another build iteration since cycle participant " + project.getName() + " has not yet seen some structural changes");
            }
            toRebuild.add(project);
        }
        if (!toRebuild.isEmpty()) {
            this.requestProjectsRebuild(toRebuild);
        }
    }

    private void printLocations(ClasspathLocation[] newLocations, ClasspathLocation[] oldLocations) {
        JavaModelManager.trace("JavaBuilder: New locations:");
        ClasspathLocation[] classpathLocationArray = newLocations;
        int n = newLocations.length;
        int n2 = 0;
        while (n2 < n) {
            ClasspathLocation newLocation = classpathLocationArray[n2];
            JavaModelManager.trace("    " + newLocation.debugPathString());
            ++n2;
        }
        JavaModelManager.trace("JavaBuilder: Old locations:");
        classpathLocationArray = oldLocations;
        n = oldLocations.length;
        n2 = 0;
        while (n2 < n) {
            ClasspathLocation oldLocation = classpathLocationArray[n2];
            JavaModelManager.trace("    " + oldLocation.debugPathString());
            ++n2;
        }
    }

    private void recordNewState(State state) {
        Set<IProject> keyTable = this.binaryLocationsPerProject.keySet();
        for (IProject proj : keyTable) {
            IProject prereqProject = proj;
            if (prereqProject == null || prereqProject == this.currentProject) continue;
            state.recordStructuralDependency(prereqProject, this.getLastState(prereqProject));
        }
        if (DEBUG) {
            JavaModelManager.trace("JavaBuilder: Recording new state : " + String.valueOf(state));
        }
        JavaModelManager.getJavaModelManager().setLastBuiltState(this.currentProject, state);
    }

    public String toString() {
        return this.currentProject == null ? "JavaBuilder for unknown project" : "JavaBuilder for " + this.currentProject.getName();
    }

    public SourceFile findSourceByPath(IPath path) {
        int i;
        if ((path = path.removeFirstSegments(1)).isEmpty()) {
            return null;
        }
        IFile file = this.currentProject.getFile(path);
        if (file.exists() && (i = 0) < this.nameEnvironment.sourceLocations.length) {
            ClasspathMultiDirectory md = this.nameEnvironment.sourceLocations[i];
            return new SourceFile(file, md);
        }
        return null;
    }

    private static /* synthetic */ boolean lambda$1() {
        return false;
    }
}

