/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.lifting;

import java.util.Arrays;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.Block;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.EqualExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.eclipse.jdt.internal.compiler.ast.IfStatement;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.ReturnStatement;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.ThisReference;
import org.eclipse.jdt.internal.compiler.ast.ThrowStatement;
import org.eclipse.jdt.internal.compiler.ast.TryStatement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.ast.UnaryExpression;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileConstants;
import org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.ExtraCompilerModifiers;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeIds;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.core.exceptions.InternalCompilerError;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.RoleInitializationMethod;
import org.eclipse.objectteams.otdt.internal.core.compiler.lifting.ArrayLifting;
import org.eclipse.objectteams.otdt.internal.core.compiler.lifting.ArrayLowering;
import org.eclipse.objectteams.otdt.internal.core.compiler.lifting.DeclaredLifting;
import org.eclipse.objectteams.otdt.internal.core.compiler.lifting.LiftingEnvironment;
import org.eclipse.objectteams.otdt.internal.core.compiler.lifting.TreeNode;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.ITeamAnchor;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.RoleTypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.WeakenedTypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.MethodModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.RoleModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.TeamModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer.AbstractStatementsGenerator;
import org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer.SwitchOnBaseTypeGenerator;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstConverter;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstEdit;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstGenerator;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.TSuperHelper;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.TypeAnalyzer;

public class Lifting
extends SwitchOnBaseTypeGenerator
implements TypeIds,
ClassFileConstants,
ExtraCompilerModifiers {
    private RoleModel _boundRootRoleModel = null;
    private AstGenerator _gen = null;
    public char[] variableName = MY_ROLE;
    protected LookupEnvironment _environment;

    public static boolean isLiftToMethod(MethodBinding method) {
        return CharOperation.prefixEquals(IOTConstants._OT_LIFT_TO, method.selector) || CharOperation.prefixEquals(DeclaredLifting.OT_LIFT_DYNAMIC, method.selector);
    }

    public static boolean isLiftToMethodCall(Expression expr) {
        if (!(expr instanceof MessageSend)) {
            return false;
        }
        char[] selector = ((MessageSend)expr).selector;
        return CharOperation.prefixEquals(IOTConstants._OT_LIFT_TO, selector) || CharOperation.prefixEquals(DeclaredLifting.OT_LIFT_DYNAMIC, selector);
    }

    public static char[] getLiftMethodName(TypeBinding roleType) {
        assert (!roleType.isBaseType());
        if (roleType.isArrayType()) {
            roleType = roleType.leafComponentType();
        }
        return Lifting.getLiftMethodName(roleType.sourceName());
    }

    public static char[] getLiftMethodName(char[] roleName) {
        return CharOperation.concat(IOTConstants._OT_LIFT_TO, roleName);
    }

    public static MessageSend liftCall(BlockScope scope, Expression teamExpr, Expression unliftedExpr, TypeBinding providedType, TypeBinding expectedRole, boolean needLowering) {
        AstGenerator gen = new AstGenerator(unliftedExpr.sourceStart, unliftedExpr.sourceEnd);
        return Lifting.liftCall(scope, teamExpr, unliftedExpr, providedType, expectedRole, needLowering, gen);
    }

    public static MessageSend liftCall(BlockScope scope, Expression teamExpr, Expression unliftedExpr, TypeBinding providedType, TypeBinding expectedRole, boolean needLowering, AstGenerator gen) {
        if (providedType.isArrayType()) {
            if (needLowering) {
                SingleNameReference dumExpr = new SingleNameReference("dummy".toCharArray(), 0L);
                new ArrayLowering(teamExpr).ensureTransformMethod(scope, dumExpr, expectedRole, providedType, false);
            }
            ArrayLifting arrayLifting = new ArrayLifting();
            return arrayLifting.liftArray(scope, teamExpr, unliftedExpr, providedType, expectedRole);
        }
        MessageSend send = gen.messageSend(teamExpr, Lifting.getLiftMethodName(expectedRole), new Expression[]{unliftedExpr});
        return send;
    }

    public ConstructorDeclaration createLiftToConstructorDeclaration(TreeNode roleNode, boolean needMethodBodies) {
        ReferenceBinding parent;
        TreeNode instantiableBoundRootRoleNode = roleNode.getTopmostBoundParent(false);
        if (instantiableBoundRootRoleNode == null) {
            return null;
        }
        RoleModel roleModel = roleNode.getTreeObject();
        TypeDeclaration roleDecl = roleModel.getAst();
        ClassScope scope = roleDecl.scope;
        if (instantiableBoundRootRoleNode == TreeNode.ProblemNode) {
            scope.problemReporter().overlappingRoleHierarchies(roleDecl, TreeNode.ProblemNode.toString());
            return null;
        }
        TypeDeclaration roleType = roleModel.getAst();
        ConstructorDeclaration existingConstructor = Lifting.findLiftToConstructor(roleType);
        if (!(existingConstructor != null || roleNode.hasBoundParent(false) || roleModel.isIgnoreFurtherInvestigation() || this.hasEmptyConstructor(parent = roleModel.getBinding().superclass()))) {
            scope.problemReporter().missingEmptyCtorForLiftingCtor(roleDecl, parent);
            return null;
        }
        this._boundRootRoleModel = roleNode.getTopmostBoundParent(true).getTreeObject();
        if (this._boundRootRoleModel != null) {
            roleModel._boundRootRole = this._boundRootRoleModel;
        }
        TypeDeclaration teamTypeDeclaration = roleType.enclosingType;
        ReferenceBinding baseClassBinding = roleType.binding.baseclass();
        if (baseClassBinding == null && (roleType.binding.tagBits & 0x20000L) != 0L) {
            return null;
        }
        AstGenerator gen = existingConstructor == null ? new AstGenerator(roleType) : new AstGenerator(existingConstructor);
        gen.replaceableEnclosingClass = roleType.binding.enclosingType();
        Argument arg = gen.argument(BASE, gen.baseclassReference(baseClassBinding));
        ConstructorDeclaration generatedConstructor = gen.constructor(teamTypeDeclaration.compilationResult, 1, roleType.name, new Argument[]{arg});
        gen.addNonNullAnnotation(arg, scope.environment());
        RoleModel implicitSuperRole = roleModel.getImplicitSuperRole();
        char[] baseArgName = BASE;
        if (existingConstructor != null) {
            if (existingConstructor.isCopied && implicitSuperRole.isBound()) {
                return null;
            }
            baseArgName = existingConstructor.arguments[0].name;
        }
        if (needMethodBodies) {
            boolean shouldCallTSuper;
            boolean bl = shouldCallTSuper = implicitSuperRole != null && implicitSuperRole.isBound() && !roleModel._refinesExtends;
            if (existingConstructor != null) {
                shouldCallTSuper &= existingConstructor.constructorCall == null || existingConstructor.constructorCall.isImplicitSuper();
            }
            if (instantiableBoundRootRoleNode == roleNode) {
                this.genLiftToConstructorStatements(baseClassBinding, roleType, generatedConstructor, baseArgName, shouldCallTSuper, gen);
            } else {
                Lifting.genLiftToConstructorSuperCall(baseClassBinding, roleType, generatedConstructor, baseArgName, shouldCallTSuper, gen);
            }
        }
        this._boundRootRoleModel = null;
        if (existingConstructor != null) {
            if (needMethodBodies) {
                if (existingConstructor.statements != null) {
                    int len1 = generatedConstructor.statements.length;
                    int len2 = existingConstructor.statements.length;
                    Statement[] newStatements = new Statement[len1 + len2];
                    System.arraycopy(generatedConstructor.statements, 0, newStatements, 0, len1);
                    System.arraycopy(existingConstructor.statements, 0, newStatements, len1, len2);
                    existingConstructor.setStatements(newStatements);
                } else {
                    existingConstructor.setStatements(generatedConstructor.statements);
                }
                if (existingConstructor.constructorCall == null || existingConstructor.constructorCall.isImplicitSuper()) {
                    existingConstructor.constructorCall = generatedConstructor.constructorCall;
                }
            }
            return existingConstructor;
        }
        AstEdit.addMethod(roleType, generatedConstructor);
        return generatedConstructor;
    }

    private boolean hasEmptyConstructor(ReferenceBinding role) {
        MethodBinding defCtor = role.getExactConstructor(Binding.NO_PARAMETERS);
        if (defCtor != null) {
            return defCtor.isValidBinding();
        }
        if (role.getMethods(TypeConstants.INIT) != Binding.NO_METHODS) {
            return false;
        }
        boolean hasExplicitConstructor = false;
        if (role.roleModel != null) {
            ReferenceBinding[] referenceBindingArray = role.roleModel.getTSuperRoleBindings();
            int n = referenceBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                ReferenceBinding tsuper = referenceBindingArray[n2];
                MethodBinding[] methodBindingArray = tsuper.getMethods(TypeConstants.INIT);
                int n3 = methodBindingArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    MethodBinding ctor = methodBindingArray[n4];
                    if (ctor.isValidBinding() && ctor.parameters == Binding.NO_PARAMETERS) {
                        return true;
                    }
                    hasExplicitConstructor = true;
                    ++n4;
                }
                ++n2;
            }
        }
        return !hasExplicitConstructor;
    }

    private static ConstructorDeclaration findLiftToConstructor(TypeDeclaration roleType) {
        if (roleType.methods == null) {
            return null;
        }
        roleType.binding.getMethods(TypeConstants.INIT);
        int i = 0;
        while (i < roleType.methods.length) {
            AbstractMethodDeclaration method = roleType.methods[i];
            if (Lifting.isLiftToConstructor(method, (ReferenceBinding)roleType.binding)) {
                return (ConstructorDeclaration)method;
            }
            ++i;
        }
        return null;
    }

    private static void genLiftToConstructorSuperCall(ReferenceBinding baseClassBinding, TypeDeclaration roleType, ConstructorDeclaration liftToConstructorDeclaration, char[] baseArgName, boolean shouldCallTSuper, AstGenerator gen) {
        liftToConstructorDeclaration.constructorCall = gen.explicitConstructorCall(shouldCallTSuper ? 4 : 2);
        liftToConstructorDeclaration.constructorCall.arguments = new Expression[]{gen.singleNameReference(baseArgName)};
        liftToConstructorDeclaration.setStatements(new Statement[]{RoleInitializationMethod.genInvokeInitMethod(gen.thisReference(), roleType.binding, gen)});
    }

    private void genLiftToConstructorStatements(ReferenceBinding baseClassBinding, TypeDeclaration roleType, ConstructorDeclaration liftToConstructorDeclaration, char[] baseArgName, boolean shouldCallTSuper, AstGenerator gen) {
        Statement[] statements;
        boolean useRoleCache = RoleModel.getInstantiationPolicy(roleType.binding).isOndemand();
        int idx = 0;
        if (shouldCallTSuper) {
            liftToConstructorDeclaration.constructorCall = gen.explicitConstructorCall(4);
            liftToConstructorDeclaration.constructorCall.arguments = new Expression[]{gen.singleNameReference(baseArgName)};
            statements = new Statement[]{};
        } else {
            liftToConstructorDeclaration.constructorCall = gen.explicitConstructorCall(2);
            statements = new Statement[useRoleCache ? 3 : 1];
            SingleNameReference lhs = gen.singleNameReference(_OT_BASE);
            statements[idx++] = gen.assignment(lhs, gen.singleNameReference(baseArgName));
            if (useRoleCache) {
                Statement[] regStats = Lifting.genRoleRegistrationStatements(this._boundRootRoleModel.getAst().scope, this._boundRootRoleModel, baseClassBinding, liftToConstructorDeclaration, gen);
                System.arraycopy(regStats, 0, statements, idx, regStats.length);
            }
        }
        liftToConstructorDeclaration.setStatements(statements);
    }

    public static Statement[] genRoleRegistrationStatements(Scope scope, RoleModel boundRootRoleModel, ReferenceBinding baseClassBinding, ConstructorDeclaration liftToConstructorDeclaration, AstGenerator gen) {
        Statement[] statements = new Statement[2];
        Expression _this = gen.thisReference();
        _this = gen.castExpression(_this, gen.typeReference(boundRootRoleModel.getBinding()), 0);
        statements[0] = gen.messageSend(gen.singleNameReference(LiftingEnvironment.getCacheName(boundRootRoleModel)), PUT, new Expression[]{gen.baseNameReference(_OT_BASE), _this});
        Expression roleExpression = gen.thisReference();
        if (TypeAnalyzer.isConfined(boundRootRoleModel.getBinding())) {
            roleExpression.resolvedType = scope.getJavaLangObject();
            roleExpression.constant = Constant.NotAConstant;
        } else {
            roleExpression = gen.castExpression(roleExpression, gen.qualifiedTypeReference(TypeConstants.JAVA_LANG_OBJECT), 2);
        }
        statements[1] = boundRootRoleModel.getWeavingScheme() == CompilerOptions.WeavingScheme.OTDRE ? gen.messageSend(gen.castExpression(gen.singleNameReference(_OT_BASE), gen.qualifiedTypeReference(ORG_OBJECTTEAMS_IBOUNDBASE2), 2), ADD_REMOVE_ROLE, new Expression[]{roleExpression, gen.booleanLiteral(true)}) : gen.messageSend(gen.castExpression(gen.singleNameReference(_OT_BASE), gen.qualifiedTypeReference(ORG_OBJECTTEAMS_IBOUNDBASE), 2), ADD_ROLE, new Expression[]{roleExpression});
        return statements;
    }

    public static boolean isLiftingCtor(MethodBinding binding) {
        int expectedParams;
        if (!binding.isConstructor()) {
            return false;
        }
        int n = expectedParams = TSuperHelper.isTSuper(binding) ? 2 : 1;
        if (binding.parameters.length != expectedParams) {
            return false;
        }
        return TypeBinding.equalsEquals(binding.parameters[0], binding.declaringClass.baseclass());
    }

    public static boolean isLiftToConstructor(AbstractMethodDeclaration method, ReferenceBinding role) {
        if (!method.isConstructor()) {
            return false;
        }
        if (method.ignoreFurtherInvestigation) {
            return false;
        }
        if (method.arguments == null || method.arguments.length != 1) {
            return false;
        }
        if (method.binding == null) {
            assert (method.scope.referenceType().ignoreFurtherInvestigation) : "binding should only be missing in a problem type";
            return false;
        }
        TypeBinding param = method.binding.parameters[0];
        if (param.isBaseType()) {
            return false;
        }
        if (param.isArrayType()) {
            return false;
        }
        if (((ReferenceBinding)param).isRole()) {
            param = TeamModel.strengthenRoleType(role, param);
        }
        ReferenceBinding paramClass = ((ReferenceBinding)param).getRealClass();
        ReferenceBinding baseclass = WeakenedTypeBinding.getBytecodeType(role.baseclass());
        return RoleTypeBinding.type_eq(paramClass, baseclass);
    }

    public static boolean isLiftToConstructor(MethodBinding method, ReferenceBinding role) {
        if (method == null) {
            return false;
        }
        if (!method.isConstructor()) {
            return false;
        }
        if (!method.isValidBinding()) {
            return false;
        }
        if (method.parameters == null || method.parameters.length != 1) {
            return false;
        }
        TypeBinding param = method.parameters[0];
        if (param.isBaseType()) {
            return false;
        }
        if (param.isArrayType()) {
            return false;
        }
        ReferenceBinding paramClass = ((ReferenceBinding)param).getRealClass();
        ReferenceBinding baseclass = role.baseclass();
        if (baseclass == null) {
            return false;
        }
        return RoleTypeBinding.type_eq(paramClass, baseclass.getRealClass());
    }

    public static boolean isUnsafeLiftCall(TypeBinding exceptionType, ASTNode location) {
        if (!(exceptionType instanceof ReferenceBinding)) {
            return false;
        }
        if (!CharOperation.equals(((ReferenceBinding)exceptionType).compoundName, IOTConstants.O_O_LIFTING_FAILED_EXCEPTION)) {
            return false;
        }
        if (!(location instanceof MessageSend)) {
            return false;
        }
        return Lifting.isLiftToMethod(((MessageSend)location).binding);
    }

    public void createLiftToMethod(final TypeDeclaration teamTypeDeclaration, TreeNode roleNode, final RoleModel[] caseObjects) {
        TreeNode boundRootRoleNode = roleNode.getTopmostBoundParent(true);
        if (boundRootRoleNode == null) {
            return;
        }
        final RoleModel roleModel = roleNode.getTreeObject();
        TypeDeclaration typeDecl = roleModel.getAst();
        if (typeDecl == null) {
            typeDecl = teamTypeDeclaration;
        }
        if (boundRootRoleNode == TreeNode.ProblemNode) {
            typeDecl.scope.problemReporter().overlappingRoleHierarchies(typeDecl, TreeNode.ProblemNode.toString());
            return;
        }
        this._boundRootRoleModel = boundRootRoleNode.getTreeObject();
        this._gen = new AstGenerator(typeDecl.sourceStart, typeDecl.sourceEnd);
        this._gen.replaceableEnclosingClass = teamTypeDeclaration.binding;
        try {
            final SourceTypeBinding teamBinding = teamTypeDeclaration.binding;
            ReferenceBinding roleClassBinding = roleModel.getBinding();
            final ReferenceBinding baseClassBinding = roleClassBinding.baseclass();
            if (RoleModel.hasTagBit(roleClassBinding, 4)) {
                this._boundRootRoleModel = null;
                this._gen = null;
                return;
            }
            char[] methodName = Lifting.getLiftMethodName(roleClassBinding.sourceName());
            Argument[] arguments = new Argument[]{this._gen.argument(BASE, this._gen.baseclassReference(baseClassBinding))};
            MethodDeclaration liftToMethodDeclaration = AstConverter.findAndAdjustCopiedMethod(teamTypeDeclaration, methodName, arguments);
            boolean needToAdd = false;
            if (liftToMethodDeclaration == null) {
                liftToMethodDeclaration = this.createLiftToMethodDeclaration(teamTypeDeclaration, roleClassBinding, methodName, arguments, baseClassBinding);
                this._gen.maybeAddTypeParametersToMethod(baseClassBinding, liftToMethodDeclaration);
                needToAdd = true;
            }
            final int problemId = teamBinding.getTeamModel().canLiftingFail(roleClassBinding);
            if (caseObjects.length == 0 && teamBinding.isAbstract()) {
                liftToMethodDeclaration.modifiers |= 0x1000400;
                if (liftToMethodDeclaration.binding != null) {
                    liftToMethodDeclaration.binding.modifiers |= 0x400;
                }
            } else {
                final MethodDeclaration newMethod = liftToMethodDeclaration;
                final AstGenerator gen = this._gen;
                final RoleModel boundRootRole = this._boundRootRoleModel;
                MethodModel.getModel(newMethod).setStatementsGenerator(new AbstractStatementsGenerator(){

                    @Override
                    public boolean generateStatements(AbstractMethodDeclaration methodDecl) {
                        try {
                            Lifting.this._gen = gen;
                            Lifting.this._boundRootRoleModel = boundRootRole;
                            Lifting.this._environment = teamTypeDeclaration.scope.environment();
                            boolean bl = Lifting.this.createLiftToMethodStatements(newMethod, teamBinding, roleModel, baseClassBinding, caseObjects, problemId);
                            return bl;
                        }
                        finally {
                            Lifting.this._gen = null;
                            Lifting.this._boundRootRoleModel = null;
                        }
                    }
                });
            }
            if (needToAdd) {
                TypeDeclaration interfaceAst;
                if (problemId != 0) {
                    liftToMethodDeclaration.thrownExceptions = new TypeReference[]{this._gen.qualifiedTypeReference(O_O_LIFTING_FAILED_EXCEPTION)};
                }
                if (teamTypeDeclaration.isRole() && (interfaceAst = teamTypeDeclaration.getRoleModel().getInterfaceAst()) != null) {
                    MethodDeclaration ifcMethod = AstConverter.genRoleIfcMethod(interfaceAst, liftToMethodDeclaration);
                    AstEdit.addMethod(interfaceAst, ifcMethod);
                    liftToMethodDeclaration.modifiers = liftToMethodDeclaration.modifiers & 0xFFFFFFFB | 1;
                }
                AstEdit.addMethod(teamTypeDeclaration, liftToMethodDeclaration);
            }
        }
        finally {
            this._boundRootRoleModel = null;
            this._gen = null;
        }
    }

    private MethodDeclaration createLiftToMethodDeclaration(TypeDeclaration teamDecl, ReferenceBinding returnType, char[] methodName, Argument[] arguments, ReferenceBinding baseType) {
        return this._gen.method(teamDecl.compilationResult, returnType.modifiers & 0x25, this.createRoleTypeReference(returnType, false), methodName, arguments);
    }

    private TypeReference createRoleTypeReference(ReferenceBinding roleType, boolean useClassPart) {
        TypeVariableBinding[] typeVariables = roleType.typeVariables();
        if (typeVariables == Binding.NO_TYPE_VARIABLES) {
            return this._gen.singleTypeReference(useClassPart ? roleType.sourceName : roleType.sourceName());
        }
        TypeReference[] typeParameters = new TypeReference[typeVariables.length];
        int i = 0;
        while (i < typeVariables.length) {
            typeParameters[i] = this._gen.typeReference(typeVariables[i]);
            ++i;
        }
        return this._gen.parameterizedSingleTypeReference(roleType.internalName(), typeParameters, 0);
    }

    private boolean createLiftToMethodStatements(MethodDeclaration liftToMethodDeclaration, ReferenceBinding teamBinding, RoleModel roleModel, ReferenceBinding baseClassBinding, RoleModel[] caseObjects, int problemId) {
        ReferenceBinding roleClassBinding = roleModel.getBinding();
        TypeVariableBinding[] typeVariables = liftToMethodDeclaration.binding.typeVariables;
        if (typeVariables != Binding.NO_TYPE_VARIABLES) {
            TypeBinding[] typeArguments = (TypeBinding[])Arrays.copyOf(typeVariables, typeVariables.length, TypeBinding[].class);
            roleClassBinding = this._environment.createParameterizedType(roleClassBinding, typeArguments, roleClassBinding.enclosingType());
        }
        if (this._boundRootRoleModel.isRoleFile()) {
            this._gen = MethodModel.setupSourcePositionMapping(liftToMethodDeclaration, liftToMethodDeclaration.sourceStart, teamBinding._teamModel.getAst(), roleModel, this._gen);
        }
        liftToMethodDeclaration.setStatements(new Statement[]{this._gen.synchronizedStatement(this.createCacheFieldRef(), new Statement[]{this._gen.localVariable(MY_ROLE, this.createRoleTypeReference(roleClassBinding, false), (Expression)this._gen.nullLiteral()), this.createSanityCheck(), this.maybeCreateTeamMemberCheck(baseClassBinding), RoleModel.getInstantiationPolicy(roleClassBinding).isOndemand() ? this.createRoleExistentCheck(roleClassBinding, baseClassBinding, teamBinding, caseObjects, problemId) : this.createCreationCascade(roleClassBinding, teamBinding, caseObjects, problemId), this.createReturnStatement(roleClassBinding)})});
        return true;
    }

    private IfStatement createSanityCheck() {
        return this._gen.ifStatement(this._gen.nullCheck(this._gen.singleNameReference(BASE)), this._gen.block(new Statement[]{this._gen.returnStatement(this._gen.nullLiteral())}));
    }

    private Statement maybeCreateTeamMemberCheck(ReferenceBinding baseClass) {
        NameReference anchorRef;
        if (!(baseClass instanceof RoleTypeBinding)) {
            return this._gen.emptyStatement();
        }
        RoleTypeBinding baseRole = (RoleTypeBinding)baseClass;
        if (!baseRole.hasExplicitAnchor()) {
            return this._gen.emptyStatement();
        }
        ITeamAnchor[] bestNamePath = baseRole._teamAnchor.getBestNamePath();
        if (bestNamePath.length == 1) {
            anchorRef = this._gen.singleNameReference(baseRole._teamAnchor.internalName());
        } else {
            char[][] names = new char[bestNamePath.length][];
            int i = 0;
            while (i < names.length) {
                names[i] = bestNamePath[i].internalName();
                ++i;
            }
            anchorRef = this._gen.qualifiedNameReference(names);
        }
        return this._gen.ifStatement(new EqualExpression(this._gen.messageSend(this._gen.baseNameReference(BASE), _OT_GETTEAM, null), anchorRef, 20), this._gen.block(new Statement[]{this._gen.throwStatement(this._gen.allocation(this._gen.qualifiedTypeReference(ORG_OBJECTTEAMS_LIFTING_VETO), new Expression[]{this._gen.thisReference(), this._gen.singleNameReference(BASE)}))}));
    }

    private IfStatement createRoleExistentCheck(ReferenceBinding returnType, ReferenceBinding baseType, ReferenceBinding teamType, RoleModel[] caseObjects, int problemId) {
        return this._gen.ifStatement((Expression)this.createRoleExistentCheck(baseType), this.createCreationCascade(returnType, teamType, caseObjects, problemId), this.createElseBlock(returnType, teamType));
    }

    private UnaryExpression createRoleExistentCheck(ReferenceBinding baseType) {
        return this._gen.setPos(new UnaryExpression(this._gen.messageSend(this.createCacheFieldRef(), CONTAINS_KEY, new Expression[]{this._gen.singleNameReference(BASE)}), 11));
    }

    private Block createCreationCascade(ReferenceBinding roleType, ReferenceBinding teamType, RoleModel[] caseObjects, int problemId) {
        return this._gen.block(new Statement[]{caseObjects.length > 0 ? this.createSwitchStatement(teamType, roleType, caseObjects, problemId, this._gen) : Lifting.genLiftingFailedException(BASE, roleType, problemId, this._gen)});
    }

    @Override
    protected Statement createCaseStatement(RoleModel role, ReferenceBinding staticRoleType, AstGenerator gen) {
        if (role.hasBaseclassProblem()) {
            return null;
        }
        Expression allocation = gen.allocation(this.createRoleTypeReference(role.getBinding(), true), new Expression[]{gen.castExpression(gen.singleNameReference(BASE), gen.baseclassReference(WeakenedTypeBinding.getBytecodeType(role.getBaseTypeBinding())), 0)});
        if (!role.getBinding().isCompatibleWith(staticRoleType)) {
            allocation = gen.castExpression(allocation, gen.typeReference(staticRoleType), 2);
        }
        return gen.assignment(gen.singleNameReference(this.variableName), allocation);
    }

    @Override
    protected Statement createStatementForAmbiguousBase(AstGenerator gen) {
        return Lifting.genLiftingFailedException(BASE, this._boundRootRoleModel.getBinding(), 141003, gen);
    }

    @Override
    protected Statement createDefaultStatement(ReferenceBinding roleType, int problemId, AstGenerator gen) {
        return Lifting.genLiftingFailedException(BASE, roleType, problemId, gen);
    }

    public static ThrowStatement genLiftingFailedException(char[] baseVarName, ReferenceBinding roleType, int problemId, AstGenerator gen) {
        return gen.throwStatement(gen.allocation(problemId == 0 ? gen.qualifiedTypeReference(SOFT_LIFTING_FAILED_EXCEPTION) : gen.qualifiedTypeReference(O_O_LIFTING_FAILED_EXCEPTION), new Expression[]{gen.singleNameReference(baseVarName), gen.stringLiteral(roleType.sourceName())}));
    }

    private Block createElseBlock(ReferenceBinding returnType, ReferenceBinding teamType) {
        TryStatement tryStatement = new TryStatement();
        tryStatement.sourceStart = this._gen.sourceStart;
        tryStatement.sourceEnd = this._gen.sourceEnd;
        tryStatement.tryBlock = this.createTryCastBlock(returnType);
        this.createCatchClassCastExceptionBlock(returnType, teamType, tryStatement);
        return this._gen.block2(this.createCacheLookupLocalDeclaration(), tryStatement);
    }

    private LocalDeclaration createCacheLookupLocalDeclaration() {
        char[] roleType = this._boundRootRoleModel.getName();
        MessageSend getCall = this._gen.messageSend(this.createCacheFieldRef(), GET, new Expression[]{this._gen.singleNameReference(BASE)});
        return this._gen.localVariable(ROLE, this._gen.singleTypeReference(roleType), (Expression)getCall);
    }

    private FieldReference createCacheFieldRef() {
        return this._gen.fieldReference(this._gen.setPos(ThisReference.implicitThis()), LiftingEnvironment.getCacheName(this._boundRootRoleModel), Expression.DecapsulationState.REPORTED);
    }

    private Block createTryCastBlock(ReferenceBinding returnType) {
        return this._gen.block(new Statement[]{this._gen.assignment(this._gen.singleNameReference(MY_ROLE), this._gen.castExpression(this._gen.singleNameReference(ROLE), this.createRoleTypeReference(returnType, false), 0))});
    }

    private void createCatchClassCastExceptionBlock(ReferenceBinding returnType, ReferenceBinding teamType, TryStatement tryStatement) {
        tryStatement.catchArguments = new Argument[]{this._gen.argument(CLASS_CAST_EXCEPTION, this._gen.singleTypeReference(_CLASS_CAST_EXCEPTION_))};
        tryStatement.catchBlocks = new Block[]{this._gen.block(new Statement[]{this._gen.throwStatement(this._gen.allocation(this._gen.qualifiedTypeReference(new char[][]{ORG, OBJECTTEAMS, WRONG_ROLE_EXCEPTION}), new Expression[]{this._gen.classLiteralAccess(this._gen.typeReference(returnType)), this._gen.singleNameReference(BASE), this._gen.singleNameReference(ROLE)}))})};
    }

    private ReturnStatement createReturnStatement(ReferenceBinding returnType) {
        return this._gen.returnStatement(this._gen.singleNameReference(MY_ROLE));
    }

    public static void createDuplicateRoleCheck(CodeStream codeStream, AbstractMethodDeclaration method) {
        MethodBinding binding = method.binding;
        MethodScope scope = method.scope;
        ReferenceBinding roleType = (ReferenceBinding)binding.returnType;
        String roleName = new String(roleType.readableName());
        char[] cacheName = LiftingEnvironment.getCacheName(roleType.roleModel.getBoundRootRole());
        ReferenceBinding teamBinding = roleType.enclosingType();
        FieldBinding cache = TypeAnalyzer.findField(teamBinding, cacheName, false, false, 17);
        if (cache == null) {
            throw new InternalCompilerError("generated cache field not found: " + new String(cacheName));
        }
        ReferenceBinding map = (ReferenceBinding)scope.getType(IOTConstants.WEAK_HASH_MAP, 3);
        MethodBinding contains = map.getMethod(scope, IOTConstants.CONTAINS_KEY);
        ReferenceBinding exc = (ReferenceBinding)scope.getType(IOTConstants.ORG_OBJECTTEAMS_DUPLICATE_ROLE, 3);
        TypeBinding[] types = new TypeBinding[]{scope.getJavaLangString()};
        MethodBinding excInit = exc.getExactConstructor(types);
        BranchLabel normalCase = new BranchLabel(codeStream);
        codeStream.aload_0();
        codeStream.fieldAccess((byte)-76, cache, teamBinding);
        codeStream.aload_1();
        codeStream.invoke((byte)-74, contains, map);
        codeStream.ifeq(normalCase);
        codeStream.new_(exc);
        codeStream.dup();
        codeStream.ldc(roleName);
        codeStream.invoke((byte)-73, excInit, exc);
        codeStream.athrow();
        normalCase.place();
    }

    public static enum InstantiationPolicy {
        NEVER,
        ONDEMAND,
        SINGLETON,
        ALWAYS,
        ERROR;


        public boolean isAlways() {
            return this == ALWAYS;
        }

        public boolean isOndemand() {
            return this == ONDEMAND;
        }
    }
}

