/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Initializer;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.codegen.ConstantPool;
import org.eclipse.jdt.internal.compiler.flow.ExceptionHandlingFlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.InitializationFlowContext;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.AbortMethod;

public class Clinit
extends AbstractMethodDeclaration {
    private static int ENUM_CONSTANTS_THRESHOLD = 2000;
    private FieldBinding assertionSyntheticFieldBinding = null;

    public Clinit(CompilationResult compilationResult) {
        super(compilationResult);
        this.modifiers = 0;
        this.selector = TypeConstants.CLINIT;
    }

    public void analyseCode(ClassScope classScope, InitializationFlowContext staticInitializerFlowContext, FlowInfo flowInfo) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        try {
            FieldBinding[] fields;
            ExceptionHandlingFlowContext clinitContext = new ExceptionHandlingFlowContext(staticInitializerFlowContext.parent, this, Binding.NO_EXCEPTIONS, staticInitializerFlowContext, this.scope, FlowInfo.DEAD_END);
            if ((flowInfo.tagBits & 1) == 0) {
                this.bits |= 0x40;
            }
            flowInfo = flowInfo.mergedWith(staticInitializerFlowContext.initsOnReturn);
            FieldBinding[] fieldBindingArray = fields = this.scope.enclosingSourceType().fields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                FieldBinding field = fieldBindingArray[n2];
                if (field.copyInheritanceSrc == null && field.isStatic() && !flowInfo.isDefinitelyAssigned(field)) {
                    if (field.isFinal()) {
                        this.scope.problemReporter().uninitializedBlankFinalField(field, this.scope.referenceType().declarationOf(field.original()));
                    } else if (field.isNonNull()) {
                        this.scope.problemReporter().uninitializedNonNullField(field, this.scope.referenceType().declarationOf(field.original()));
                    }
                }
                ++n2;
            }
            staticInitializerFlowContext.checkInitializerExceptions(this.scope, clinitContext, flowInfo);
        }
        catch (AbortMethod abortMethod) {
            this.ignoreFurtherInvestigation = true;
        }
    }

    @Override
    public void generateCode(ClassScope classScope, ClassFile classFile) {
        TypeDeclaration referenceContext;
        int clinitOffset = 0;
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        CompilationResult unitResult = null;
        int problemCount = 0;
        if (classScope != null && (referenceContext = classScope.referenceContext) != null) {
            unitResult = referenceContext.compilationResult();
            problemCount = unitResult.problemCount;
        }
        boolean restart = false;
        do {
            try {
                clinitOffset = classFile.contentsOffset;
                this.generateCode(classScope, classFile, clinitOffset);
                restart = false;
            }
            catch (AbortMethod e) {
                if (e.compilationResult == CodeStream.RESTART_IN_WIDE_MODE) {
                    classFile.contentsOffset = clinitOffset;
                    --classFile.methodCount;
                    classFile.codeStream.resetInWideMode();
                    if (unitResult != null) {
                        unitResult.problemCount = problemCount;
                    }
                    restart = true;
                    continue;
                }
                if (e.compilationResult == CodeStream.RESTART_CODE_GEN_FOR_UNUSED_LOCALS_MODE) {
                    classFile.contentsOffset = clinitOffset;
                    --classFile.methodCount;
                    classFile.codeStream.resetForCodeGenUnusedLocals();
                    if (unitResult != null) {
                        unitResult.problemCount = problemCount;
                    }
                    restart = true;
                    continue;
                }
                classFile.contentsOffset = clinitOffset;
                --classFile.methodCount;
                restart = false;
            }
        } while (restart);
    }

    private void generateCode(ClassScope classScope, ClassFile classFile, int clinitOffset) {
        int n;
        int sourcePosition;
        FieldDeclaration[] fieldDeclarations;
        TypeDeclaration declaringType;
        CodeStream codeStream;
        int codeAttributeOffset;
        int constantPoolIndex;
        int constantPoolOffset;
        ConstantPool constantPool;
        block42: {
            TypeDeclaration ifcPart;
            boolean isJava9;
            MethodScope staticInitializerScope;
            block39: {
                int max;
                int count;
                int enumCount;
                int remainingFieldCount;
                block41: {
                    block40: {
                        constantPool = classFile.constantPool;
                        constantPoolOffset = constantPool.currentOffset;
                        constantPoolIndex = constantPool.currentIndex;
                        classFile.generateMethodInfoHeaderForClinit();
                        codeAttributeOffset = classFile.contentsOffset;
                        classFile.generateCodeAttributeHeader();
                        codeStream = classFile.codeStream;
                        this.resolve(classScope);
                        codeStream.reset(this, classFile);
                        declaringType = classScope.referenceContext;
                        codeStream.pushPatternAccessTrapScope(this.scope);
                        staticInitializerScope = declaringType.staticInitializerScope;
                        staticInitializerScope.computeLocalVariablePositions(0, codeStream);
                        if (this.assertionSyntheticFieldBinding != null) {
                            codeStream.generateClassLiteralAccessForType(classScope, classScope.outerMostClassScope().enclosingSourceType());
                            codeStream.invokeJavaLangClassDesiredAssertionStatus();
                            BranchLabel falseLabel = new BranchLabel(codeStream);
                            codeStream.ifne(falseLabel);
                            codeStream.iconst_1();
                            BranchLabel jumpLabel = new BranchLabel(codeStream);
                            codeStream.goto_(jumpLabel);
                            falseLabel.place();
                            codeStream.iconst_0();
                            jumpLabel.place();
                            codeStream.fieldAccess((byte)-77, this.assertionSyntheticFieldBinding, null);
                        }
                        isJava9 = classScope.compilerOptions().complianceLevel >= 0x350000L;
                        fieldDeclarations = declaringType.fields;
                        sourcePosition = -1;
                        remainingFieldCount = 0;
                        if (TypeDeclaration.kind(declaringType.modifiers) != 3) break block39;
                        enumCount = declaringType.enumConstantsCounter;
                        if (isJava9 || enumCount <= ENUM_CONSTANTS_THRESHOLD) break block40;
                        int begin = -1;
                        count = 0;
                        if (fieldDeclarations == null) break block41;
                        max = fieldDeclarations.length;
                        int i = 0;
                        while (i < max) {
                            FieldDeclaration fieldDecl = fieldDeclarations[i];
                            if (fieldDecl.isStatic()) {
                                if (fieldDecl.getKind() == 3) {
                                    if (begin == -1) {
                                        begin = i;
                                    }
                                    if (++count > ENUM_CONSTANTS_THRESHOLD) {
                                        SyntheticMethodBinding syntheticMethod = declaringType.binding.addSyntheticMethodForEnumInitialization(begin, i);
                                        codeStream.invoke((byte)-72, syntheticMethod, null);
                                        begin = i;
                                        count = 1;
                                    }
                                } else {
                                    ++remainingFieldCount;
                                }
                            }
                            ++i;
                        }
                        if (count == 0) break block41;
                        SyntheticMethodBinding syntheticMethod = declaringType.binding.addSyntheticMethodForEnumInitialization(begin, max);
                        codeStream.invoke((byte)-72, syntheticMethod, null);
                        break block41;
                    }
                    if (fieldDeclarations != null) {
                        FieldDeclaration[] syntheticMethod = fieldDeclarations;
                        max = fieldDeclarations.length;
                        count = 0;
                        while (count < max) {
                            FieldDeclaration fieldDecl = syntheticMethod[count];
                            if (fieldDecl.isStatic()) {
                                if (fieldDecl.getKind() == 3) {
                                    fieldDecl.generateCode(staticInitializerScope, codeStream);
                                } else {
                                    ++remainingFieldCount;
                                }
                            }
                            ++count;
                        }
                    }
                }
                codeStream.generateInlinedValue(enumCount);
                codeStream.anewarray(declaringType.binding);
                if (enumCount > 0 && fieldDeclarations != null) {
                    FieldDeclaration[] syntheticMethod = fieldDeclarations;
                    max = fieldDeclarations.length;
                    count = 0;
                    while (count < max) {
                        FieldDeclaration fieldDecl = syntheticMethod[count];
                        if (fieldDecl.getKind() == 3) {
                            codeStream.dup();
                            codeStream.generateInlinedValue(fieldDecl.binding.id);
                            codeStream.fieldAccess((byte)-78, fieldDecl.binding, null);
                            codeStream.aastore();
                        }
                        ++count;
                    }
                }
                codeStream.fieldAccess((byte)-77, declaringType.enumValuesSyntheticfield, null);
                if (remainingFieldCount != 0) {
                    int i = 0;
                    int max2 = fieldDeclarations.length;
                    while (i < max2 && remainingFieldCount >= 0) {
                        FieldDeclaration fieldDecl = fieldDeclarations[i];
                        switch (fieldDecl.getKind()) {
                            case 3: {
                                break;
                            }
                            case 2: {
                                if (!fieldDecl.isStatic()) break;
                                --remainingFieldCount;
                                sourcePosition = ((Initializer)fieldDecl).block.sourceEnd;
                                fieldDecl.generateCode(staticInitializerScope, codeStream);
                                break;
                            }
                            case 1: {
                                if (!fieldDecl.binding.isStatic()) break;
                                --remainingFieldCount;
                                sourcePosition = fieldDecl.declarationEnd;
                                fieldDecl.generateCode(staticInitializerScope, codeStream);
                            }
                        }
                        ++i;
                    }
                }
                break block42;
            }
            if (fieldDeclarations != null) {
                FieldDeclaration[] fieldDeclarationArray = fieldDeclarations;
                n = fieldDeclarations.length;
                int i = 0;
                while (i < n) {
                    FieldDeclaration fieldDecl = fieldDeclarationArray[i];
                    switch (fieldDecl.getKind()) {
                        case 2: {
                            if (!fieldDecl.isStatic()) break;
                            sourcePosition = ((Initializer)fieldDecl).block.sourceEnd;
                            fieldDecl.generateCode(staticInitializerScope, codeStream);
                            break;
                        }
                        case 1: {
                            if (!fieldDecl.binding.isStatic()) break;
                            int previousPosition = codeStream.position;
                            sourcePosition = fieldDecl.declarationEnd;
                            fieldDecl.generateCode(staticInitializerScope, codeStream);
                            if (previousPosition == codeStream.position || !classScope.referenceContext.isRole()) break;
                            classScope.problemReporter().roleCantInitializeStaticField(fieldDecl);
                        }
                    }
                    ++i;
                }
            }
            if (declaringType.isRole() && declaringType.getRoleModel() != null && (ifcPart = declaringType.getRoleModel().getInterfaceAst()) != null && ifcPart.fields != null) {
                FieldDeclaration[] fieldDeclarationArray = ifcPart.fields;
                int n2 = ifcPart.fields.length;
                n = 0;
                while (n < n2) {
                    FieldDeclaration ifcField = fieldDeclarationArray[n];
                    if (ifcField.binding.constant() == Constant.NotAConstant) {
                        classScope.problemReporter().roleCantInitializeStaticField(ifcField);
                    }
                    ++n;
                }
            }
            if (isJava9) {
                declaringType.binding.generateSyntheticFinalFieldInitialization(codeStream);
            }
        }
        if (codeStream.position == 0) {
            classFile.contentsOffset = clinitOffset;
            --classFile.methodCount;
            constantPool.resetForClinit(constantPoolIndex, constantPoolOffset);
        } else {
            if ((this.bits & 0x40) != 0) {
                int before = codeStream.position;
                codeStream.return_();
                if (sourcePosition != -1) {
                    codeStream.recordPositionsFrom(before, sourcePosition);
                }
            }
            codeStream.handleRecordAccessorExceptions(this.scope);
            codeStream.recordPositionsFrom(0, declaringType.sourceStart);
            classFile.completeCodeAttributeForClinit(codeAttributeOffset, classScope);
        }
        if (TypeDeclaration.kind(declaringType.modifiers) != 3 && fieldDeclarations != null) {
            int constantFlags = 24;
            FieldDeclaration[] fieldDeclarationArray = fieldDeclarations;
            int n3 = fieldDeclarations.length;
            n = 0;
            while (n < n3) {
                FieldDeclaration fieldDecl = fieldDeclarationArray[n];
                if ((fieldDecl.modifiers & constantFlags) == constantFlags && fieldDecl.initialization != null) {
                    NameReference.emitDeclaringClassOfConstant(fieldDecl.initialization, codeStream);
                }
                ++n;
            }
        }
    }

    @Override
    public boolean isClinit() {
        return true;
    }

    @Override
    public boolean isInitializationMethod() {
        return true;
    }

    @Override
    public boolean isStatic() {
        return true;
    }

    @Override
    public void parseStatements(Parser parser, CompilationUnitDeclaration unit) {
    }

    @Override
    public StringBuilder print(int tab, StringBuilder output) {
        Clinit.printIndent(tab, output).append("<clinit>()");
        this.printBody(tab + 1, output);
        return output;
    }

    @Override
    public void resolve(ClassScope classScope) {
        this.scope = new MethodScope(classScope, classScope.referenceContext, true);
    }

    @Override
    public void traverse(ASTVisitor visitor, ClassScope classScope) {
        visitor.visit(this, classScope);
        visitor.endVisit(this, classScope);
    }

    public void setAssertionSupport(FieldBinding assertionSyntheticFieldBinding) {
        this.assertionSyntheticFieldBinding = assertionSyntheticFieldBinding;
    }
}

