/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otre;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Unknown;
import org.apache.bcel.generic.ACONST_NULL;
import org.apache.bcel.generic.ALOAD;
import org.apache.bcel.generic.ATHROW;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.CompoundInstruction;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.DUP;
import org.apache.bcel.generic.FieldGen;
import org.apache.bcel.generic.GOTO;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.LocalVariableGen;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.NOP;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.POP;
import org.apache.bcel.generic.PUSH;
import org.apache.bcel.generic.RETURN;
import org.apache.bcel.generic.SWAP;
import org.apache.bcel.generic.Type;
import org.eclipse.objectteams.otre.ClassEnhancer;
import org.eclipse.objectteams.otre.OTConstants;
import org.eclipse.objectteams.otre.ObjectTeamsTransformation;
import org.eclipse.objectteams.otre.jplis.JPLISEnhancer;
import org.eclipse.objectteams.otre.util.CallinBindingManager;
import org.eclipse.objectteams.otre.util.TeamIdDispenser;

public class TeamInterfaceImplementation
extends ObjectTeamsTransformation {
    public TeamInterfaceImplementation(Object loader) {
        super(loader);
    }

    public void doTransformCode(ClassGen cg) {
        this.factory = new InstructionFactory(cg);
        if (!TeamInterfaceImplementation.classNeedsTeamExtensions(cg)) {
            return;
        }
        ConstantPoolGen cpg = cg.getConstantPool();
        String class_name = cg.getClassName();
        this.genImplicitActivation(cg, cpg);
        InstructionList implicitSuperRoleRegistrations = this.genImplicitSuperRegistration(cg, cpg);
        if (!implicitSuperRoleRegistrations.isEmpty()) {
            Method clinitMethod = cg.containsMethod("<clinit>", "()V");
            this.addToMethodStart(implicitSuperRoleRegistrations, clinitMethod, cg, cpg);
        }
        if (CallinBindingManager.getBasesPerTeam(class_name) == null) {
            return;
        }
        int nextTeamId = TeamIdDispenser.getTeamId(class_name);
        this.addStaticInitializations(nextTeamId, cg, cpg);
    }

    private void addStaticInitializations(int nextTeamId, ClassGen cg, ConstantPoolGen cpg) {
        Method clinitMethod = cg.containsMethod("<clinit>", "()V");
        MethodGen mg = TeamInterfaceImplementation.newMethodGen(clinitMethod, cg.getClassName(), cpg);
        InstructionList il = mg.getInstructionList();
        InstructionList addedInitialization = new InstructionList();
        addedInitialization.append(this.createIntegerPush(cpg, nextTeamId));
        addedInitialization.append((Instruction)this.factory.createFieldAccess(cg.getClassName(), "_OT$ID", (Type)Type.INT, (short)179));
        il.insert(addedInitialization);
        mg.setMaxStack();
        mg.setMaxLocals();
        Method newClinit = mg.getMethod();
        cg.replaceMethod(clinitMethod, newClinit);
        JPLISEnhancer.requireClassFileVersionLessThan51(cg);
        il.dispose();
    }

    private InstructionList genImplicitSuperRegistration(ClassGen cg, ConstantPoolGen cpg) {
        InstructionList il = new InstructionList();
        List<String> inheritedRoleNames = this.getInheritedRoleNames(cg, cpg);
        if (inheritedRoleNames.isEmpty()) {
            return il;
        }
        for (String roleName : inheritedRoleNames) {
            String potientialImplicitSuperRoleName;
            String unqualifiedRoleName = roleName.substring(roleName.lastIndexOf(36) + 1);
            if (!CallinBindingManager.isBoundBaseAndRoleClass(roleName) || !CallinBindingManager.isBoundBaseAndRoleClass(potientialImplicitSuperRoleName = cg.getSuperclassName() + "$" + unqualifiedRoleName)) continue;
            il.append((CompoundInstruction)new PUSH(cpg, roleName));
            il.append((Instruction)this.factory.createInvoke("java.lang.Class", "forName", (Type)classType, new Type[]{Type.STRING}, (short)184));
            il.append((Instruction)this.factory.createInvoke(potientialImplicitSuperRoleName, "_OT$registerObserver", (Type)Type.VOID, new Type[]{classType}, (short)184));
        }
        return il;
    }

    public void doTransformInterface(ClassEnhancer ce, ClassGen cg) {
        String class_name = cg.getClassName();
        ConstantPoolGen cpg = cg.getConstantPool();
        this.checkReadClassAttributes(ce, cg, class_name, cpg);
        if (!TeamInterfaceImplementation.classNeedsTeamExtensions(cg)) {
            return;
        }
        this.factory = new InstructionFactory(cg);
        this.addStaticInitializer(cg, cpg, class_name, ce);
        List<String> handledBases = CallinBindingManager.getBasesPerTeam(class_name);
        if (handledBases == null) {
            return;
        }
        if (logging) {
            TeamInterfaceImplementation.printLogMessage("Adding the general Team infrastructure to " + class_name);
        }
        int accessFlags = 25;
        FieldGen IDField = new FieldGen(accessFlags, (Type)Type.INT, "_OT$ID", cpg);
        ce.addField(IDField.getField(), cg);
        this.factory = new InstructionFactory(cpg);
        InstructionList il = new InstructionList();
        MethodGen getIDMethod = new MethodGen(1, (Type)Type.INT, Type.NO_ARGS, new String[0], "_OT$getID", class_name, il, cpg);
        il.append((Instruction)this.factory.createFieldAccess(class_name, "_OT$ID", (Type)Type.INT, (short)178));
        il.append((Instruction)InstructionFactory.createReturn((Type)Type.INT));
        getIDMethod.setMaxStack();
        getIDMethod.setMaxLocals();
        ce.addMethod(getIDMethod.getMethod(), cg);
        ce.addMethod(this.generateTeamRegistrationMethod(cpg, class_name, handledBases), cg);
        ce.addMethod(this.generateTeamUnregistrationMethod(cpg, class_name, handledBases), cg);
        Method[] base_call_surrogates = this.generateStaticBaseCallSurrogates(class_name, cpg, cg);
        int i = 0;
        while (i < base_call_surrogates.length) {
            ce.addOrReplaceMethod(base_call_surrogates[i], cg);
            ++i;
        }
        il.dispose();
    }

    private void addToMethodStart(InstructionList additionalInstructions, Method method, ClassGen cg, ConstantPoolGen cpg) {
        MethodGen mg = TeamInterfaceImplementation.newMethodGen(method, cg.getClassName(), cpg);
        InstructionList il = mg.getInstructionList();
        il.insert(additionalInstructions);
        mg.setMaxStack();
        mg.setMaxLocals();
        Method newMethod = mg.getMethod();
        cg.replaceMethod(method, newMethod);
        JPLISEnhancer.requireClassFileVersionLessThan51(cg);
        il.dispose();
    }

    void addStaticInitializer(ClassGen cg, ConstantPoolGen cpg, String class_name, ClassEnhancer ce) {
        Method existingClinit = cg.containsMethod("<clinit>", "()V");
        if (existingClinit == null) {
            InstructionList il = new InstructionList();
            MethodGen clinitMethodGen = new MethodGen(8, (Type)Type.VOID, Type.NO_ARGS, new String[0], "<clinit>", class_name, il, cpg);
            il.append((Instruction)InstructionFactory.createReturn((Type)Type.VOID));
            clinitMethodGen.setMaxStack();
            clinitMethodGen.setMaxLocals();
            Method clinitMethod = clinitMethodGen.getMethod();
            ce.addMethod(clinitMethod, cg);
        }
    }

    Method generateTeamRegistrationMethod(ConstantPoolGen cpg, String class_name, List<String> handledBases) {
        InstructionList il = new InstructionList();
        MethodGen mg = new MethodGen(1, (Type)Type.VOID, Type.NO_ARGS, null, "_OT$registerAtBases", class_name, il, cpg);
        for (String actBase : handledBases) {
            if (CallinBindingManager.teamAdaptsSuperBaseClass(class_name, actBase)) continue;
            InstructionHandle startTry = il.append((Instruction)new ALOAD(0));
            il.append((Instruction)this.factory.createFieldAccess(class_name, "_OT$ID", (Type)Type.INT, (short)178));
            il.append((Instruction)this.factory.createInvoke(actBase, "_OT$addTeam", (Type)Type.VOID, new Type[]{teamType, Type.INT}, (short)184));
            this.addNoSuchMethodErrorHandling(startTry, il.getEnd(), this.getErrorMessage(class_name, actBase, "Activation"), il, mg, cpg);
        }
        il.append((Instruction)new RETURN());
        mg.setMaxStack();
        mg.setMaxLocals();
        return mg.getMethod();
    }

    Method generateTeamUnregistrationMethod(ConstantPoolGen cpg, String class_name, List<String> handledBases) {
        InstructionList il = new InstructionList();
        MethodGen mg = new MethodGen(1, (Type)Type.VOID, Type.NO_ARGS, null, "_OT$unregisterFromBases", class_name, il, cpg);
        for (String actBase : handledBases) {
            if (CallinBindingManager.teamAdaptsSuperBaseClass(class_name, actBase)) continue;
            InstructionHandle startTry = il.append((Instruction)new ALOAD(0));
            il.append((Instruction)this.factory.createInvoke(actBase, "_OT$removeTeam", (Type)Type.VOID, new Type[]{teamType}, (short)184));
            this.addNoSuchMethodErrorHandling(startTry, il.getEnd(), this.getErrorMessage(class_name, actBase, "Deactivation"), il, mg, cpg);
        }
        il.append((Instruction)new RETURN());
        mg.setMaxStack();
        mg.setMaxLocals();
        return mg.getMethod();
    }

    private String getErrorMessage(String teamName, String baseName, String action) {
        String errorMessage = action + " of team '" + teamName + "' failed! Callins of this team have NOT been WOVEN into base class '" + baseName + "'!\nThis is probably caused by a loading order problem.";
        return errorMessage;
    }

    private void addNoSuchMethodErrorHandling(InstructionHandle startTry, InstructionHandle endTry, String errorMessage, InstructionList il, MethodGen mg, ConstantPoolGen cpg) {
        GOTO skipHdlr = null;
        skipHdlr = new GOTO(null);
        il.append((BranchInstruction)skipHdlr);
        InstructionHandle hdlr = il.append((Instruction)new POP());
        il.append((Instruction)this.factory.createNew(OTConstants.unsupportedFeature));
        il.append((Instruction)new DUP());
        il.append((CompoundInstruction)new PUSH(cpg, errorMessage));
        il.append((Instruction)this.factory.createInvoke(OTConstants.unsupportedFeature.getClassName(), "<init>", (Type)Type.VOID, new Type[]{Type.STRING}, (short)183));
        il.append((Instruction)new ATHROW());
        InstructionHandle nop = il.append((Instruction)new NOP());
        skipHdlr.setTarget(nop);
        mg.addExceptionHandler(startTry, endTry, hdlr, new ObjectType("java.lang.NoSuchMethodError"));
    }

    void genImplicitActivation(ClassGen cg, ConstantPoolGen cpg) {
        Method[] methods = cg.getMethods();
        int i = 0;
        while (i < methods.length) {
            Method m = methods[i];
            if (TeamInterfaceImplementation.candidateForImplicitActivation(m, cg, cpg)) {
                if (logging) {
                    TeamInterfaceImplementation.printLogMessage("Adding implicit activation to " + m.getName());
                }
                cg.replaceMethod(m, this.genImplicitActivation(m, cg.getClassName(), cpg, false));
                JPLISEnhancer.requireClassFileVersionLessThan51(cg);
            }
            ++i;
        }
    }

    private Method[] generateStaticBaseCallSurrogates(String class_name, ConstantPoolGen cpg, ClassGen cg) {
        HashSet<String> roleMethodKeys = new HashSet<String>();
        Attribute[] attributes = cg.getAttributes();
        int k = 0;
        while (k < attributes.length) {
            Unknown attr = TeamInterfaceImplementation.isOTAttribute(attributes[k]);
            if (attr != null && attr.getName().equals("StaticReplaceBindings")) {
                byte[] indizes = attr.getBytes();
                int count = TeamInterfaceImplementation.combineTwoBytes(indizes, 0);
                int numberOfEntries = 0;
                numberOfEntries = 5;
                int i = 2;
                int n = 0;
                while (n < count) {
                    String[] names = new String[numberOfEntries];
                    i = TeamInterfaceImplementation.scanStrings(names, indizes, i, cpg);
                    int index = 0;
                    String role_name = names[index++];
                    String role_method_name = names[index++];
                    String role_method_signature = names[index++];
                    String lift_method_name = names[index++];
                    String lift_method_signature = names[index++];
                    String roleMethodKey = TeamInterfaceImplementation.genRoleMethodKey(class_name, role_name, role_method_name, role_method_signature, lift_method_name, lift_method_signature);
                    roleMethodKeys.add(roleMethodKey);
                    int base_len = TeamInterfaceImplementation.combineTwoBytes(indizes, i);
                    i += 2;
                    names = new String[3];
                    int n_base = 0;
                    while (n_base < base_len) {
                        byte flags;
                        int[] positions = null;
                        i = TeamInterfaceImplementation.scanStrings(names, indizes, i, cpg);
                        boolean baseIsCallin = ((flags = indizes[i++]) & 1) != 0;
                        boolean baseIsRoleMethod = (flags & 2) != 0;
                        boolean baseIsStatic = (flags & 4) != 0;
                        int pos_len = TeamInterfaceImplementation.combineTwoBytes(indizes, i);
                        i += 2;
                        if (pos_len > 0) {
                            positions = new int[pos_len];
                        }
                        int pos = 0;
                        while (pos < pos_len) {
                            positions[pos] = TeamInterfaceImplementation.combineTwoBytes(indizes, i);
                            i += 2;
                            ++pos;
                        }
                        int translationFlags = (TeamInterfaceImplementation.combineTwoBytes(indizes, i) << 16) + TeamInterfaceImplementation.combineTwoBytes(indizes, i + 2);
                        i += 4;
                        ObjectTeamsTransformation.BaseMethodInfo baseMethod = new ObjectTeamsTransformation.BaseMethodInfo(names[0], names[1], names[2], baseIsCallin, baseIsRoleMethod, baseIsStatic, positions, translationFlags);
                        CallinBindingManager.assignBaseCallTag(names[0], names[1], names[2]);
                        CallinBindingManager.addStaticReplaceBindingForRoleMethod(roleMethodKey, baseMethod);
                        ++n_base;
                    }
                    ++n;
                }
                break;
            }
            ++k;
        }
        Iterator roleMethodIter = roleMethodKeys.iterator();
        int count = roleMethodKeys.size();
        Method[] generatedSurrogates = new Method[count];
        int j = 0;
        while (roleMethodIter.hasNext()) {
            String roleMethodKey = (String)roleMethodIter.next();
            LinkedList<ObjectTeamsTransformation.BaseMethodInfo> baseMethods = CallinBindingManager.getStaticReplaceBindingsForRoleMethod(roleMethodKey);
            int firstPointIndex = roleMethodKey.indexOf("..");
            int secondPointIndex = roleMethodKey.indexOf("..", firstPointIndex + 1);
            int thirdPointIndex = roleMethodKey.indexOf("..", secondPointIndex + 1);
            int fourthPointIndex = roleMethodKey.indexOf("..", thirdPointIndex + 1);
            int fifthPointIndex = roleMethodKey.indexOf("..", fourthPointIndex + 1);
            String role_name = roleMethodKey.substring(firstPointIndex + 2, secondPointIndex);
            String role_method_name = roleMethodKey.substring(secondPointIndex + 2, thirdPointIndex);
            String role_method_signature = roleMethodKey.substring(thirdPointIndex + 2, fourthPointIndex);
            String lift_method_name = null;
            String lift_method_signature = null;
            if (fourthPointIndex + 2 <= fifthPointIndex && fifthPointIndex + 2 < roleMethodKey.length()) {
                lift_method_name = roleMethodKey.substring(fourthPointIndex + 2, fifthPointIndex);
                lift_method_signature = roleMethodKey.substring(fifthPointIndex + 2, roleMethodKey.length());
            }
            generatedSurrogates[j] = this.genBaseCallSurrogate(cg, role_name, role_method_name, role_method_signature, lift_method_name, lift_method_signature, baseMethods);
            ++j;
        }
        return generatedSurrogates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Method genBaseCallSurrogate(ClassGen cg, String role_name, String role_method_name, String role_method_signature, String lift_method_name, String lift_method_signature, LinkedList<ObjectTeamsTransformation.BaseMethodInfo> base_methods) {
        ConstantPoolGen cpg = cg.getConstantPool();
        String class_name = cg.getClassName();
        if (base_methods.isEmpty()) {
            return null;
        }
        Type[] enhancedArgumentTypes = TeamInterfaceImplementation.enhanceArgumentTypes(Type.getArgumentTypes((String)role_method_signature));
        Type enhancedReturnType = TeamInterfaceImplementation.generalizeReturnType(Type.getReturnType((String)role_method_signature));
        String[] enhancedArgumentNames = null;
        InstructionList il = new InstructionList();
        int accessFlags = 4;
        MethodGen baseCallSurrogate = new MethodGen(accessFlags, enhancedReturnType, enhancedArgumentTypes, enhancedArgumentNames, TeamInterfaceImplementation.getBaseCallSurrogateName(role_name, role_method_name), class_name, il, cpg);
        LocalVariableGen otResult = null;
        otResult = baseCallSurrogate.addLocalVariable("_OT$result", enhancedReturnType, null, null);
        il.insert((Instruction)InstructionFactory.createStore((Type)enhancedReturnType, (int)otResult.getIndex()));
        il.insert((Instruction)new ACONST_NULL());
        il.setPositions();
        if (logging) {
            TeamInterfaceImplementation.printLogMessage("base-call switch has to be inserted!");
        }
        InstructionList loading = new InstructionList();
        loading.append(InstructionFactory.createThis());
        int index = 1;
        int i = 0;
        while (i < enhancedArgumentTypes.length) {
            loading.append((Instruction)InstructionFactory.createLoad((Type)enhancedArgumentTypes[i], (int)index));
            index += enhancedArgumentTypes[i].getSize();
            ++i;
        }
        Type[] argumentTypes = Type.getArgumentTypes((String)role_method_signature);
        Type returnType = Type.getReturnType((String)role_method_signature);
        if (debugging) {
            baseCallSurrogate.addLineNumber(il.getStart(), 65534);
        }
        LinkedList<ObjectTeamsTransformation.BaseMethodInfo> linkedList = base_methods;
        synchronized (linkedList) {
            il.append(this.genBaseCallSwitch(cpg, base_methods, baseCallSurrogate, argumentTypes, returnType, lift_method_name, lift_method_signature, otResult, loading, cg.getClassName()));
        }
        il.append((Instruction)InstructionFactory.createLoad((Type)enhancedReturnType, (int)otResult.getIndex()));
        il.append((Instruction)InstructionFactory.createReturn((Type)enhancedReturnType));
        il.setPositions();
        baseCallSurrogate.removeNOPs();
        baseCallSurrogate.setMaxStack();
        baseCallSurrogate.setMaxLocals();
        return baseCallSurrogate.getMethod();
    }

    private static String getBaseCallSurrogateName(String class_name, String method_name) {
        return "_OT$" + class_name + "$" + method_name + "$base";
    }

    InstructionList genBaseCallSwitch(ConstantPoolGen cpg, LinkedList<ObjectTeamsTransformation.BaseMethodInfo> base_methods, MethodGen enhancedMethod, Type[] argumentTypes, Type returnType, String liftMethodName, String liftMethodSignature, LocalVariableGen otResult, InstructionList loading, String teamName) {
        short invocationKind = 184;
        String className = enhancedMethod.getClassName();
        Type enhancedMethodReturnType = enhancedMethod.getReturnType();
        boolean callinHasReturnValue = returnType != Type.VOID;
        InstructionList il = new InstructionList();
        int localResult = -1;
        LocalVariableGen lg = null;
        if (callinHasReturnValue) {
            lg = enhancedMethod.addLocalVariable("_OT$tmpResult", returnType, null, null);
            localResult = lg.getIndex();
            il.append(InstructionFactory.createNull((Type)returnType));
            il.append((Instruction)InstructionFactory.createStore((Type)returnType, (int)localResult));
        }
        InstructionHandle switchStart = il.append((Instruction)InstructionFactory.createLoad((Type)Type.INT, (int)5));
        HashSet<Integer> baseMethodTags = new HashSet<Integer>();
        for (ObjectTeamsTransformation.BaseMethodInfo baseMethod : base_methods) {
            int baseMethodTag = CallinBindingManager.getBaseCallTag(baseMethod.getBaseClassName(), baseMethod.getBaseMethodName(), baseMethod.getBaseMethodSignature());
            baseMethodTags.add(baseMethodTag);
        }
        int numberOfCases = baseMethodTags.size();
        GOTO[] breaks = new GOTO[numberOfCases];
        int i = 0;
        while (i < numberOfCases) {
            breaks[i] = new GOTO(null);
            ++i;
        }
        int[] matches = new int[numberOfCases];
        InstructionHandle[] targets = new InstructionHandle[numberOfCases];
        int caseCounter = 0;
        baseMethodTags.clear();
        Type[] enhancedMethodArguments = enhancedMethod.getArgumentTypes();
        Type[] enhancedArgumentsForBaseCall = new Type[enhancedMethodArguments.length - 1];
        System.arraycopy(enhancedMethodArguments, 0, enhancedArgumentsForBaseCall, 0, enhancedArgumentsForBaseCall.length);
        for (ObjectTeamsTransformation.BaseMethodInfo baseMethod : base_methods) {
            boolean resultLiftingNecessary;
            String baseMethodSignature;
            String baseMethodName;
            String baseClassName = baseMethod.getBaseClassName();
            int base_method_tag = CallinBindingManager.getBaseCallTag(baseClassName, baseMethodName = baseMethod.getBaseMethodName(), baseMethodSignature = baseMethod.getBaseMethodSignature());
            Integer bmt = base_method_tag;
            if (baseMethodTags.contains(bmt)) continue;
            baseMethodTags.add(bmt);
            int[] parameterPositions = baseMethod.getParameterPositions();
            int len = Type.getArgumentTypes((String)baseMethodSignature).length;
            if (baseMethod.isCallin) {
                len += 6;
            }
            matches[caseCounter] = CallinBindingManager.getBaseCallTag(baseClassName, baseMethodName, baseMethodSignature);
            InstructionHandle nextBranch = il.append((Instruction)new NOP());
            Type[] baseMethodArgumentTypes = Type.getArgumentTypes((String)baseMethodSignature);
            Type baseMethodReturnType = Type.getReturnType((String)baseMethodSignature);
            String baseChainMethodName = TeamInterfaceImplementation.genChainMethName(baseMethodName);
            ObjectType baseChainReturnType = object;
            Type[] enhancedBaseArgumentTypes = TeamInterfaceImplementation.enhanceArgumentTypes(baseMethodArgumentTypes);
            int idx = 0;
            while (idx < 6) {
                il.append((Instruction)InstructionFactory.createLoad((Type)enhancedMethodArguments[idx], (int)(idx + 1)));
                ++idx;
            }
            InstructionHandle baseCallLine = il.append(this.translateLoads(this.splitLoading(cpg, loading.copy(), argumentTypes), enhancedMethodArguments, enhancedBaseArgumentTypes, parameterPositions, teamName, null, baseMethod, 6, cpg));
            il.append((Instruction)this.factory.createInvoke(baseClassName, baseChainMethodName, (Type)baseChainReturnType, enhancedBaseArgumentTypes, invocationKind));
            boolean bl = resultLiftingNecessary = (baseMethod.translationFlags & 1) != 0;
            if (resultLiftingNecessary) {
                Type[] liftMethodArgs = Type.getArgumentTypes((String)liftMethodSignature);
                Type liftMethodReturnType = Type.getReturnType((String)liftMethodSignature);
                il.append(this.factory.createCast((Type)baseChainReturnType, baseMethodReturnType));
                il.append(InstructionFactory.createThis());
                il.append(this.factory.createCast((Type)object, (Type)new ObjectType(teamName)));
                il.append((Instruction)new SWAP());
                il.append((Instruction)this.factory.createInvoke(teamName, liftMethodName, liftMethodReturnType, liftMethodArgs, (short)182));
            }
            il.append((Instruction)new DUP());
            if (!resultLiftingNecessary) {
                this.adjustValue(il, null, (Type)baseChainReturnType, enhancedMethodReturnType);
            }
            il.append((Instruction)InstructionFactory.createStore((Type)enhancedMethodReturnType, (int)otResult.getIndex()));
            InstructionHandle afterBaseCallLine = il.append((Instruction)new NOP());
            this.adjustValue(il, null, (Type)baseChainReturnType, returnType);
            if (callinHasReturnValue) {
                il.append((Instruction)InstructionFactory.createStore((Type)returnType, (int)localResult));
            }
            targets[caseCounter] = nextBranch;
            il.append((BranchInstruction)breaks[caseCounter]);
            ++caseCounter;
            if (!debugging) continue;
            enhancedMethod.addLineNumber(baseCallLine, 65533);
            enhancedMethod.addLineNumber(afterBaseCallLine, 65534);
        }
        InstructionHandle defaultBranch = il.append((Instruction)new NOP());
        if (logging) {
            TeamInterfaceImplementation.printLogMessage("Exeption has to be thrown! Base-Call is impossible.");
        }
        il.append((Instruction)this.factory.createNew(OTConstants.unsupportedFeature));
        il.append((Instruction)new DUP());
        il.append((CompoundInstruction)new PUSH(cpg, "Binding-Error: base-call from " + className + "." + enhancedMethod.getName() + "impossible! This problem is documented in OTLD $XY."));
        il.append((Instruction)this.factory.createInvoke(OTConstants.unsupportedFeature.getClassName(), "<init>", (Type)Type.VOID, new Type[]{Type.STRING}, (short)183));
        il.append((Instruction)new ATHROW());
        InstructionHandle afterSwitch = il.append((Instruction)new NOP());
        il.append(switchStart, TeamInterfaceImplementation.createLookupSwitch(matches, targets, breaks, defaultBranch, afterSwitch));
        if (callinHasReturnValue) {
            il.append((Instruction)InstructionFactory.createLoad((Type)returnType, (int)localResult));
            lg.setStart(il.getStart());
            lg.setEnd(il.getEnd());
        }
        return il;
    }

    private static String genRoleMethodKey(String teamClassName, String roleClassName, String roleMethodName, String roleMethodSignature, String liftMethodName, String liftMethodSignature) {
        StringBuilder roleMethodKey = new StringBuilder(64);
        roleMethodKey.append(teamClassName);
        roleMethodKey.append("..");
        roleMethodKey.append(roleClassName);
        roleMethodKey.append("..");
        roleMethodKey.append(roleMethodName);
        roleMethodKey.append("..");
        roleMethodKey.append(roleMethodSignature);
        roleMethodKey.append("..");
        roleMethodKey.append(liftMethodName);
        roleMethodKey.append("..");
        roleMethodKey.append(liftMethodSignature);
        return roleMethodKey.toString();
    }

    private List<String> getInheritedRoleNames(ClassGen cg, ConstantPoolGen cpg) {
        Attribute[] attributes = cg.getAttributes();
        LinkedList<String> inheritedRoleNames = new LinkedList<String>();
        int i = 0;
        while (i < attributes.length) {
            Attribute actAttr = attributes[i];
            if (actAttr instanceof Unknown) {
                Unknown attr = (Unknown)actAttr;
                byte[] indizes = attr.getBytes();
                int count = TeamInterfaceImplementation.combineTwoBytes(indizes, 0);
                if (attr.getName().equals("InheritedRoles")) {
                    int j = 2;
                    while (j <= 2 * count) {
                        String[] names = new String[1];
                        j = TeamInterfaceImplementation.scanStrings(names, indizes, j, cpg);
                        String inherited_role = names[0];
                        inheritedRoleNames.add(inherited_role);
                    }
                }
            }
            ++i;
        }
        return inheritedRoleNames;
    }
}

